/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.util;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import java.util.HashMap;
import java.util.Map;

public class MappingContextFactory {
    private static final Map _contextCache = new HashMap();

    public static Model getDefaultModel() {
        return Model.DEVELOPMENT;
    }

    public static MappingContext getDefault() {
        return MappingContextFactory.getMappingContext(MappingContextFactory.getDefaultModel());
    }

    public static MappingContext getMappingContext(Model model) {
        return MappingContextFactory.getMappingContext(model, null, MappingContextFactory.class.getClassLoader());
    }

    public static MappingContext getMappingContext(Model model, String brandingSuffix, ClassLoader classLoader) {
        return MappingContextFactory.getMappingContext(model, brandingSuffix, true, classLoader);
    }

    public static synchronized MappingContext getMappingContext(Model model, String brandingSuffix, boolean isJDOExposed, ClassLoader classLoader) {
        ComplexKey key = new ComplexKey(model, brandingSuffix, isJDOExposed);
        MappingContext value = (MappingContext)_contextCache.get(key);
        if (value == null) {
            value = new MappingContext(model, brandingSuffix, isJDOExposed, classLoader);
            _contextCache.put(key, value);
        }
        return value;
    }

    private static final class ComplexKey {
        private final Model _model;
        private final String _suffix;
        private final boolean _isJDOExposed;

        private ComplexKey(Model model, String suffix, boolean isJDOExposed) {
            this._model = model;
            this._suffix = suffix;
            this._isJDOExposed = isJDOExposed;
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass().equals(obj.getClass())) {
                ComplexKey o = (ComplexKey)obj;
                if (this._model.equals(o._model) && this._isJDOExposed == o._isJDOExposed && (this._suffix == null && o._suffix == null || this._suffix.equals(o._suffix))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode += this._model != null ? this._model.hashCode() : 0;
            hashCode += this._suffix != null ? this._suffix.hashCode() : 0;
            return hashCode += this._isJDOExposed ? 1 : 0;
        }
    }
}

