/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship;

import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.RelationshipState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.MapToKeyStep;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipMappingWizard;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipTablePanel;
import com.sun.jdo.modules.persistence.mapping.core.util.DBListElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.ui.CustomListCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.IconWrapper;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.TableElement;

public class MapLocalToJoinKeyStep
extends MapToKeyStep {
    private JTextField thisFieldTextField;
    private JPanel tablePanel;
    private JComboBox joinTableComboBox;
    private JTextField thisClassTextField;

    public MapLocalToJoinKeyStep(RelationshipMappingWizard wizard) {
        super(wizard, 1);
        this.initComponents();
        this.addRelationshipTablePanel(this.tablePanel);
        this.initAccessibility();
    }

    private void initAccessibility() {
        MappingContext context = this.getMappingContext();
        this.getAccessibleContext().setAccessibleDescription(context.getString("RMW_Map_To_Key_Local_To_Join_Top_Text"));
        this.getTablePanel().getAccessibleContext().setAccessibleDescription(context.getString("RMW_Map_To_Key_Local_To_Join_Bottom_Text"));
    }

    private void initComponents() {
        MappingContext mappingContext = this.getMappingContext();
        JTextArea mapLocalToJoinTopTextArea = new JTextArea();
        JPanel classFieldPanel = new JPanel();
        JLabel thisClassLabel = new JLabel();
        JLabel thisFieldLabel = new JLabel();
        JLabel joinTableLabel = new JLabel();
        this.thisClassTextField = new JTextField();
        this.thisFieldTextField = new JTextField();
        this.joinTableComboBox = new JComboBox();
        this.tablePanel = new JPanel();
        JTextArea mapLocalToJoinBottomTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        mapLocalToJoinTopTextArea.setWrapStyleWord(true);
        mapLocalToJoinTopTextArea.setLineWrap(true);
        mapLocalToJoinTopTextArea.setEditable(false);
        mapLocalToJoinTopTextArea.setColumns(70);
        mapLocalToJoinTopTextArea.setRows(2);
        mapLocalToJoinTopTextArea.setForeground((Color)UIManager.getDefaults().get("Label.foreground"));
        mapLocalToJoinTopTextArea.setFont(UIManager.getFont("Label.font"));
        mapLocalToJoinTopTextArea.setText(mappingContext.getString("RMW_Map_To_Key_Local_To_Join_Top_Text"));
        mapLocalToJoinTopTextArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        mapLocalToJoinTopTextArea.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        mapLocalToJoinTopTextArea.setPreferredSize(new Dimension(840, 80));
        mapLocalToJoinTopTextArea.setMinimumSize(new Dimension(460, 80));
        mapLocalToJoinTopTextArea.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)mapLocalToJoinTopTextArea, gridBagConstraints);
        classFieldPanel.setLayout(new GridBagLayout());
        thisClassLabel.setText(mappingContext.getString("RMW_This_Class"));
        thisClassLabel.setDisplayedMnemonic(mappingContext.getMnemonic("RMW_Mnemonic_This_Class"));
        thisClassLabel.setLabelFor(this.thisClassTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        classFieldPanel.add((Component)thisClassLabel, gridBagConstraints);
        thisFieldLabel.setText(mappingContext.getString("RMW_This_Field"));
        thisFieldLabel.setDisplayedMnemonic(mappingContext.getMnemonic("RMW_Mnemonic_This_Field"));
        thisFieldLabel.setLabelFor(this.thisFieldTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        classFieldPanel.add((Component)thisFieldLabel, gridBagConstraints);
        joinTableLabel.setText(mappingContext.getString("RMW_Join_Table"));
        joinTableLabel.setDisplayedMnemonic(mappingContext.getMnemonic("RMW_Mnemonic_Join_Table"));
        joinTableLabel.setLabelFor(this.joinTableComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        classFieldPanel.add((Component)joinTableLabel, gridBagConstraints);
        this.thisClassTextField.setEditable(false);
        this.thisClassTextField.setPreferredSize(new Dimension(150, 20));
        this.thisClassTextField.setMinimumSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 50.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        classFieldPanel.add((Component)this.thisClassTextField, gridBagConstraints);
        this.thisFieldTextField.setEditable(false);
        this.thisFieldTextField.setPreferredSize(new Dimension(150, 20));
        this.thisFieldTextField.setMinimumSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 50.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        classFieldPanel.add((Component)this.thisFieldTextField, gridBagConstraints);
        this.joinTableComboBox.setModel(new DefaultComboBoxModel());
        this.joinTableComboBox.setRenderer(new CustomListCellRenderer());
        SwingUtils.makeLightWeight(this.joinTableComboBox);
        this.joinTableComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MapLocalToJoinKeyStep.this.joinTableComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 50.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        classFieldPanel.add((Component)this.joinTableComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)classFieldPanel, gridBagConstraints);
        this.tablePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.tablePanel, gridBagConstraints);
        mapLocalToJoinBottomTextArea.setWrapStyleWord(true);
        mapLocalToJoinBottomTextArea.setLineWrap(true);
        mapLocalToJoinBottomTextArea.setEditable(false);
        mapLocalToJoinBottomTextArea.setColumns(70);
        mapLocalToJoinBottomTextArea.setRows(2);
        mapLocalToJoinBottomTextArea.setForeground((Color)UIManager.getDefaults().get("Label.foreground"));
        mapLocalToJoinBottomTextArea.setFont(UIManager.getFont("Label.font"));
        mapLocalToJoinBottomTextArea.setText(mappingContext.getString("RMW_Map_To_Key_Local_To_Join_Bottom_Text"));
        mapLocalToJoinBottomTextArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        mapLocalToJoinBottomTextArea.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        mapLocalToJoinBottomTextArea.setPreferredSize(new Dimension(840, 80));
        mapLocalToJoinBottomTextArea.setMinimumSize(new Dimension(460, 80));
        mapLocalToJoinBottomTextArea.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)mapLocalToJoinBottomTextArea, gridBagConstraints);
    }

    public void requestFocus() {
        if (this.getJoinTable() == null) {
            this.joinTableComboBox.requestFocus();
        }
    }

    private void joinTableComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.areListenersDisabled()) {
            boolean shouldSearch = !this.getMappingContext().getString("VALUE_join_table").equals(this.joinTableComboBox.getSelectedItem().toString());
            ((RelationshipMappingWizard)this.wizard).replaceStateObject(shouldSearch, true);
            this.updateTable();
            this.setButtonStates();
            if (this.getJoinTable() != null) {
                this.getTablePanel().selectAndFocusPair();
            }
            if (this.joinTableComboBox.getSelectedIndex() != 0 && this.joinTableComboBox.getItemAt(0) instanceof IconWrapper) {
                this.joinTableComboBox.removeItemAt(0);
            }
            this.fireChange();
        }
    }

    protected String getSubtitleKey() {
        return "RMW_Map_To_Key_Local_To_Join_Step";
    }

    protected String getImageName() {
        return "localJoin.gif";
    }

    public boolean isValid() {
        return super.isValid() && this.getJoinTable() != null;
    }

    public TableElement getJoinTable() {
        Object lElement = this.joinTableComboBox.getSelectedItem();
        return lElement != null && lElement instanceof DBListElement ? (TableElement)((DBListElement)lElement).getFirstElement() : null;
    }

    protected void populateFromState() {
        RelationshipState state = this.getRelationshipState();
        String selection = this.updateTable();
        this.thisClassTextField.setText(this.getShortClassName());
        this.thisFieldTextField.setText(this.getField().toString());
        this.setupJoinTableComboBox(selection);
    }

    private String updateTable() {
        RelationshipState state = this.getRelationshipState();
        String joinTable = null;
        if (state != null) {
            this.updateCellEditors();
            joinTable = state.getJoinTable();
            if (joinTable != null) {
                this.populateTableFromColumns(this.getPairState());
            }
        }
        return joinTable;
    }

    protected String getLocalHeader() {
        return this.getTablePanel().getColumnHeader()[1][0];
    }

    protected String getForeignHeader() {
        return this.getTablePanel().getColumnHeader()[1][1];
    }

    protected List getColumnsForHeader(String header) {
        if (header.equals(this.getLocalHeader())) {
            return this.getLocalColumns();
        }
        if (header.equals(this.getForeignHeader())) {
            return this.getJoinColumns();
        }
        return null;
    }

    private void setupJoinTableComboBox(String tableName) {
        String chooseJoin = this.getMappingContext().getString("VALUE_join_table");
        DefaultComboBoxModel lComboModel = (DefaultComboBoxModel)this.joinTableComboBox.getModel();
        DBListElement[] lTablelist = new DBListElement[]{new DBListElement(chooseJoin)};
        FieldHolderState holder = this.getHolderState();
        String relatedClass = holder.getCurrentRelatedClass(this.getField());
        TableElement selection = this.getTable(tableName);
        if (relatedClass != null) {
            TableState tableStateObject = holder.getTableState();
            String primaryTable = tableStateObject.getCurrentPrimaryTableName();
            TableElement relatedPrimaryTable = this.getRelatedPrimaryTable();
            ArrayList<String> excludeList = new ArrayList<String>();
            List tableList = null;
            if (primaryTable != null) {
                excludeList.add(primaryTable);
            }
            if (relatedPrimaryTable != null) {
                excludeList.add(relatedPrimaryTable.getName().getName());
            }
            if ((tableList = tableStateObject.getSortedSchemaTables(excludeList)) != null && tableList.size() > 0) {
                lTablelist = DBListElement.convertArray(tableList, chooseJoin, false);
            }
        }
        SwingUtils.replaceItems(lComboModel, Arrays.asList(lTablelist));
        if (selection != null) {
            lComboModel.setSelectedItem(new DBListElement((DBElement)selection, null));
        } else if (!StringHelper.isEmpty(tableName)) {
            IconWrapper iconWrapper = new IconWrapper(tableName, Util.getIllegalIcon());
            lComboModel.insertElementAt(iconWrapper, 0);
            lComboModel.setSelectedItem(iconWrapper);
        }
    }

    protected void initGUI() throws Exception {
    }

    protected void setButtonStates() {
        RelationshipTablePanel tablePanel = this.getTablePanel();
        TableElement joinTable = this.getJoinTable();
        boolean hasInvalidJoinTable = false;
        if (joinTable == null) {
            RelationshipState relationshipState = this.getRelationshipState();
            String joinTableName = relationshipState != null ? relationshipState.getJoinTable() : null;
            hasInvalidJoinTable = joinTableName != null;
        }
        tablePanel.setButtonStates(joinTable != null);
        tablePanel.getMappingTable().setEnabled(!hasInvalidJoinTable);
    }
}

