/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.io.IOException;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.nodes.AntTargetNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

final class AntProjectChildren
extends Children.Keys
implements ChangeListener,
Comparator {
    private static Collator SORTER = Collator.getInstance();
    private final AntProjectCookie cookie;
    private SortedSet allTargets;

    public AntProjectChildren(AntProjectCookie cookie) {
        this.cookie = cookie;
    }

    protected void addNotify() {
        super.addNotify();
        this.refreshKeys(true);
        this.cookie.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        super.removeNotify();
        this.setKeys(Collections.EMPTY_SET);
        AntProjectChildren antProjectChildren = this;
        synchronized (antProjectChildren) {
            this.allTargets = null;
        }
        this.cookie.removeChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshKeys(boolean createKeys) {
        try {
            SortedSet keys;
            Set _allTargets = TargetLister.getTargets(this.cookie);
            AntProjectChildren antProjectChildren = this;
            synchronized (antProjectChildren) {
                if (this.allTargets == null && !createKeys) {
                    return;
                }
                this.allTargets = new TreeSet(this);
                this.allTargets.addAll(_allTargets);
                Iterator it = this.allTargets.iterator();
                while (it.hasNext()) {
                    TargetLister.Target t = (TargetLister.Target)it.next();
                    if (!t.isOverridden()) continue;
                    it.remove();
                }
                keys = this.allTargets;
            }
            if (keys != null) {
                this.setKeys(keys);
            }
        }
        catch (IOException e) {
            AntModule.err.notify(1, (Throwable)e);
            this.setKeys(Collections.EMPTY_SET);
        }
    }

    protected Node[] createNodes(Object key) {
        TargetLister.Target t = (TargetLister.Target)key;
        return new Node[]{new AntTargetNode(this.cookie, t, this.allTargets)};
    }

    public void stateChanged(ChangeEvent ev) {
        this.refreshKeys(false);
    }

    public int compare(Object o1, Object o2) {
        TargetLister.Target t1 = (TargetLister.Target)o1;
        TargetLister.Target t2 = (TargetLister.Target)o2;
        int x = SORTER.compare(t1.getName(), t2.getName());
        if (x != 0 || t1 == t2) {
            return x;
        }
        return System.identityHashCode(t1) - System.identityHashCode(t2);
    }
}

