/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.spi.AutomaticExtraClasspathProvider;
import org.openide.execution.NbClassPath;
import org.openide.modules.InstalledFileLocator;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class AntSettings
extends SystemOption
implements ChangeListener {
    public static final String PROP_VERBOSITY = "verbosity";
    public static final String PROP_PROPERTIES = "properties";
    public static final String PROP_SAVE_ALL = "saveAll";
    public static final String PROP_CUSTOM_DEFS = "customDefs";
    public static final String PROP_ANT_VERSION = "antVersion";
    public static final String PROP_ANT_HOME = "antHome";
    public static final String PROP_EXTRA_CLASSPATH = "extraClasspath";
    public static final String PROP_AUTOMATIC_EXTRA_CLASSPATH = "automaticExtraClasspath";
    public static final String PROP_AUTO_CLOSE_TABS = "autoCloseTabs";
    public static final String PROP_ALWAYS_SHOW_OUTPUT = "alwaysShowOutput";
    private static final long serialVersionUID = -4457782585534082966L;
    private static File defaultAntHome;
    private NbClassPath defAECP = null;
    private Lookup.Result aecpResult = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void initialize() {
        super.initialize();
        this.setVerbosity(2);
        Properties p = new Properties();
        p.setProperty("build.compiler.emacs", "true");
        this.setProperties(p);
        this.setSaveAll(true);
        this.setCustomDefs(new IntrospectedInfo());
        this.setAutoCloseTabs(true);
        this.setAlwaysShowOutput(true);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)AntSettings.class, (String)"LBL_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.apache.tools.ant.module.settings");
    }

    public static AntSettings getDefault() {
        return (AntSettings)AntSettings.findObject((Class)AntSettings.class, (boolean)true);
    }

    public int getVerbosity() {
        return (Integer)this.getProperty(PROP_VERBOSITY);
    }

    public void setVerbosity(int v) {
        this.putProperty(PROP_VERBOSITY, new Integer(v), true);
    }

    public Properties getProperties() {
        HashMap m = (HashMap)this.getProperty(PROP_PROPERTIES);
        Properties p = new Properties();
        p.putAll((Map<?, ?>)m);
        return p;
    }

    public void setProperties(Properties p) {
        HashMap<Object, Object> m = new HashMap<Object, Object>(p);
        this.putProperty(PROP_PROPERTIES, m, true);
    }

    public boolean getSaveAll() {
        return (Boolean)this.getProperty(PROP_SAVE_ALL);
    }

    public void setSaveAll(boolean sa) {
        this.putProperty(PROP_SAVE_ALL, sa ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public IntrospectedInfo getCustomDefs() {
        return (IntrospectedInfo)this.getProperty(PROP_CUSTOM_DEFS);
    }

    public void setCustomDefs(IntrospectedInfo ii) {
        this.putProperty(PROP_CUSTOM_DEFS, ii, true);
        ii.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)ii));
    }

    public String getAntVersion() {
        String v = (String)this.getProperty(PROP_ANT_VERSION);
        if (v == null) {
            v = AntBridge.getInterface().getAntVersion();
            this.putProperty(PROP_ANT_VERSION, v, false);
        }
        return v;
    }

    public void stateChanged(ChangeEvent e) {
        this.firePropertyChange(PROP_CUSTOM_DEFS, null, null);
    }

    static File getDefaultAntHome() {
        if (defaultAntHome == null) {
            File antJar = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
            if (!$assertionsDisabled && antJar == null) {
                throw new AssertionError((Object)"Missing binding for ant/lib/ant.jar in InstalledFileLocator");
            }
            defaultAntHome = antJar.getParentFile().getParentFile();
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("getDefaultAntHome: " + defaultAntHome);
            }
        }
        if (!$assertionsDisabled && defaultAntHome == null) {
            throw new AssertionError();
        }
        return defaultAntHome;
    }

    public File getAntHomeWithDefault() {
        File f = this.getAntHome();
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("getAntHomeWithDefault: antHome=" + f);
        }
        if (f == null) {
            f = AntSettings.getDefaultAntHome();
        }
        if (!$assertionsDisabled && f == null) {
            throw new AssertionError();
        }
        return f;
    }

    public File getAntHome() {
        return (File)this.getProperty(PROP_ANT_HOME);
    }

    public void setAntHome(File f) {
        if (f != null && f.equals(AntSettings.getDefaultAntHome())) {
            f = null;
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("setAntHome: " + f);
        }
        this.putProperty(PROP_ANT_HOME, f, true);
        this.putProperty(PROP_ANT_VERSION, null, false);
        this.firePropertyChange(PROP_ANT_VERSION, null, null);
    }

    public NbClassPath getExtraClasspath() {
        NbClassPath p = (NbClassPath)this.getProperty(PROP_EXTRA_CLASSPATH);
        if (p == null) {
            p = new NbClassPath(new File[0]);
            this.putProperty(PROP_EXTRA_CLASSPATH, p, false);
        }
        return p;
    }

    public void setExtraClasspath(NbClassPath p) {
        this.putProperty(PROP_EXTRA_CLASSPATH, p, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NbClassPath getAutomaticExtraClasspath() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.aecpResult == null) {
                this.aecpResult = Lookup.getDefault().lookup(new Lookup.Template(AutomaticExtraClasspathProvider.class));
                this.aecpResult.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        AntSettings.this.defAECP = null;
                        AntSettings.this.firePropertyChange(AntSettings.PROP_AUTOMATIC_EXTRA_CLASSPATH, null, null);
                    }
                });
            }
            if (this.defAECP == null) {
                ArrayList<Object> items = new ArrayList<Object>();
                Iterator it = this.aecpResult.allInstances().iterator();
                while (it.hasNext()) {
                    AutomaticExtraClasspathProvider provider = (AutomaticExtraClasspathProvider)it.next();
                    items.addAll(Arrays.asList((Object[])provider.getClasspathItems()));
                }
                this.defAECP = new NbClassPath(items.toArray(new File[items.size()]));
            }
            return this.defAECP;
        }
    }

    public boolean getAutoCloseTabs() {
        return (Boolean)this.getProperty(PROP_AUTO_CLOSE_TABS);
    }

    public void setAutoCloseTabs(boolean b) {
        this.putProperty(PROP_AUTO_CLOSE_TABS, b, true);
    }

    public boolean getAlwaysShowOutput() {
        return (Boolean)this.getProperty(PROP_ALWAYS_SHOW_OUTPUT);
    }

    public void setAlwaysShowOutput(boolean b) {
        this.putProperty(PROP_ALWAYS_SHOW_OUTPUT, b, true);
    }

    static {
        $assertionsDisabled = !AntSettings.class.desiredAssertionStatus();
        defaultAntHome = null;
    }
}

