/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.Registry;

public class HTMLSyntaxSupport
extends ExtSyntaxSupport
implements InvalidateListener {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private DTD dtd;
    private String docType;

    public HTMLSyntaxSupport(BaseDocument doc) {
        super(doc);
    }

    public void dtdInvalidated(InvalidateEvent evt) {
        if (this.dtd != null && evt.isInvalidatedIdentifier(this.docType)) {
            this.dtd = null;
        }
    }

    public DTD getDTD() {
        String type = this.getDocType();
        if (type == null) {
            type = FALLBACK_DOCTYPE;
        }
        if (this.dtd != null && type == this.docType) {
            return this.dtd;
        }
        this.docType = type;
        this.dtd = Registry.getDTD(this.docType, null);
        return this.dtd;
    }

    protected String getDocType() {
        try {
            SyntaxElement elem = this.getElementChain(0);
            if (elem == null) {
                return null;
            }
            int type = elem.getType();
            while (type != 1 && type != 4 && (elem = elem.getNext()) != null) {
                type = elem.getType();
            }
            if (type == 1) {
                return ((SyntaxElement.Declaration)elem).getPublicIdentifier();
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] findMatchingBlock(int offset, boolean simpleSearch) throws BadLocationException {
        int start;
        TokenItem toki;
        TokenItem token;
        TokenItem tokenOnOffset = token = this.getTokenChain(offset, offset + 1);
        if (token != null && token.getTokenID().getNumericID() == 15) {
            token = token.getPrevious();
        }
        boolean isInside = false;
        if (token != null) {
            if (HTMLSyntaxSupport.isTagButNotSymbol(token)) {
                isInside = true;
            } else if (token.getTokenID() == HTMLTokenContext.TAG_OPEN_SYMBOL) {
                if ((token = token.getNext()) == null || token.getTokenID() != HTMLTokenContext.TAG_CLOSE && token.getTokenID() != HTMLTokenContext.TAG_OPEN) return null;
                isInside = true;
            } else {
                for (token = token.getPrevious(); token != null && !HTMLSyntaxSupport.isTagButNotSymbol(token) && token.getTokenID().getNumericID() != 15; token = token.getPrevious()) {
                }
                if (token != null && HTMLSyntaxSupport.isTagButNotSymbol(token)) {
                    isInside = true;
                }
            }
        }
        if (token != null && HTMLSyntaxSupport.isTagButNotSymbol(token) && isInside) {
            String tag;
            int poss = -1;
            if (token.getTokenID() == HTMLTokenContext.TAG_CLOSE) {
                tag = token.getImage().trim().toLowerCase();
                while (token != null) {
                    if (HTMLSyntaxSupport.isTagButNotSymbol(token)) {
                        if (token.getImage().trim().toLowerCase().equals(tag) && token.getTokenID() == HTMLTokenContext.TAG_OPEN && !this.isSingletonTag(token)) {
                            if (poss == 0) {
                                int start2 = token.getPrevious().getOffset();
                                token = token.getNext();
                                int end = token.getOffset() + (token.getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL ? token.getImage().length() : 0);
                                return new int[]{start2, end};
                            }
                            --poss;
                        } else if (token.getImage().toLowerCase().indexOf(tag) > -1 && !this.isSingletonTag(token)) {
                            ++poss;
                        }
                    }
                    token = token.getPrevious();
                }
            } else {
                if (token.getImage().charAt(0) == '>') {
                    return null;
                }
                if (this.isSingletonTag(token)) {
                    return null;
                }
                tag = token.getImage().toLowerCase();
                while (token != null) {
                    if (HTMLSyntaxSupport.isTagButNotSymbol(token)) {
                        if (token.getImage().trim().toLowerCase().equals(tag) && token.getTokenID() == HTMLTokenContext.TAG_CLOSE) {
                            if (poss == 0) {
                                int start3 = token.getPrevious().getOffset();
                                int end = token.getOffset() + token.getImage().length() + 1;
                                for (token = token.getNext(); token != null && token.getTokenID().getNumericID() != 15; token = token.getNext()) {
                                }
                                if (token == null) return new int[]{start3, end};
                                end = token.getOffset() + token.getImage().length();
                                return new int[]{start3, end};
                            }
                            --poss;
                        } else if (token.getImage().toLowerCase().equals(tag) && !this.isSingletonTag(token)) {
                            ++poss;
                        }
                    }
                    token = token.getNext();
                }
            }
        }
        if (tokenOnOffset == null || tokenOnOffset.getTokenID() != HTMLTokenContext.BLOCK_COMMENT) return null;
        String tokenImage = tokenOnOffset.getImage();
        if (tokenImage.startsWith("<!--") && offset < tokenOnOffset.getOffset() + "<!--".length()) {
            for (toki = tokenOnOffset; toki != null && toki.getTokenID() == HTMLTokenContext.BLOCK_COMMENT; toki = toki.getNext()) {
                if (!toki.getImage().endsWith("-->")) continue;
                start = toki.getOffset() + toki.getImage().length() - "-->".length();
                int end = toki.getOffset() + toki.getImage().length();
                return new int[]{start, end};
            }
        }
        if (!tokenImage.endsWith("-->") || offset < tokenOnOffset.getOffset() + tokenOnOffset.getImage().length() - "-->".length()) return null;
        while (toki != null && toki.getTokenID() == HTMLTokenContext.BLOCK_COMMENT) {
            if (toki.getImage().startsWith("<!--")) {
                start = toki.getOffset();
                int end = toki.getOffset() + "<!--".length();
                return new int[]{start, end};
            }
            toki = toki.getPrevious();
        }
        return null;
    }

    public boolean isSingletonTag(TokenItem tagTokenItem) {
        for (TokenItem ti = tagTokenItem; ti != null; ti = ti.getNext()) {
            if (ti.getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                if ("/>".equals(ti.getImage())) {
                    return true;
                }
                if (">".equals(ti.getImage())) break;
            }
            if (ti.getTokenID() == HTMLTokenContext.TEXT || ti.getTokenID() == HTMLTokenContext.TAG_OPEN_SYMBOL) break;
        }
        return false;
    }

    private final int getTokenEnd(TokenItem item) {
        return item.getOffset() + item.getImage().length();
    }

    public SyntaxElement getElementChain(int offset) throws BadLocationException {
        TokenItem first;
        TokenItem item;
        for (item = first = this.getTokenChain(offset, Math.min(offset + 10, this.getDocument().getLength())); item != null && !item.getTokenContextPath().contains(HTMLTokenContext.contextPath); item = item.getPrevious()) {
        }
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        int beginning = item.getOffset();
        if (id == HTMLTokenContext.CHARACTER) {
            while (id != null && id == HTMLTokenContext.CHARACTER) {
                beginning = item.getOffset();
                id = (item = item.getPrevious()) == null ? null : item.getTokenID();
            }
            if (id != HTMLTokenContext.VALUE && id != HTMLTokenContext.TEXT) {
                return this.getNextElement(beginning);
            }
        }
        if (id == HTMLTokenContext.WS || id == HTMLTokenContext.ARGUMENT || id == HTMLTokenContext.OPERATOR || id == HTMLTokenContext.VALUE) {
            do {
                item = item.getPrevious();
                id = item.getTokenID();
            } while (!HTMLSyntaxSupport.isTag(item));
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.TEXT) {
            while (id != null && (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER)) {
                beginning = item.getOffset();
                id = (item = item.getPrevious()) == null ? null : item.getTokenID();
            }
            return this.getNextElement(beginning);
        }
        if (HTMLSyntaxSupport.isTag(item)) {
            if (item.getTokenID() == HTMLTokenContext.TAG_OPEN || item.getTokenID() == HTMLTokenContext.TAG_OPEN_SYMBOL) {
                return this.getNextElement(item.getOffset());
            }
            TokenItem prev = null;
            do {
                if ((prev = item.getPrevious()) == null) {
                    return this.getNextElement(item.getOffset());
                }
                item = prev;
                id = item.getTokenID();
            } while (!HTMLSyntaxSupport.isTag(item));
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, item.getOffset(), this.getTokenEnd(item), 2);
        }
        if (id == HTMLTokenContext.BLOCK_COMMENT) {
            TokenItem prev = null;
            while (id == HTMLTokenContext.BLOCK_COMMENT && !item.getImage().startsWith("<!--")) {
                prev = item;
                item = item.getPrevious();
                id = item.getTokenID();
            }
            if (item.getTokenID() != HTMLTokenContext.BLOCK_COMMENT) {
                item = prev;
            }
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.DECLARATION || id == HTMLTokenContext.SGML_COMMENT) {
            while (id != HTMLTokenContext.DECLARATION || !item.getImage().startsWith("<!")) {
                item = item.getPrevious();
                id = item.getTokenID();
            }
            return this.getNextElement(item.getOffset());
        }
        return null;
    }

    SyntaxElement getPreviousElement(int offset) throws BadLocationException {
        return offset == 0 ? null : this.getElementChain(offset - 1);
    }

    private static String getQuotedString(StringBuffer data) {
        char stopMark;
        int startIndex = 0;
        if (data == null || data.length() == 0) {
            return null;
        }
        while (data.charAt(startIndex) == ' ') {
            ++startIndex;
        }
        if ((stopMark = data.charAt(startIndex++)) == '\"' || stopMark == '\'') {
            for (int index = startIndex; index < data.length(); ++index) {
                if (data.charAt(index) != stopMark) continue;
                String quoted = data.substring(startIndex, index);
                data.delete(0, index + 1);
                return quoted;
            }
        }
        return null;
    }

    public SyntaxElement getNextElement(int offset) throws BadLocationException {
        TokenItem item = this.getTokenChain(offset, Math.min(offset + 10, this.getDocument().getLength()));
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        int lastOffset = this.getTokenEnd(item);
        if (id == HTMLTokenContext.BLOCK_COMMENT) {
            while (id == HTMLTokenContext.BLOCK_COMMENT) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
            }
            return new SyntaxElement(this, offset, lastOffset, 0);
        }
        if (id == HTMLTokenContext.DECLARATION) {
            String si;
            String image;
            StringBuffer sb = new StringBuffer(item.getImage());
            while (id == HTMLTokenContext.DECLARATION || id == HTMLTokenContext.SGML_COMMENT) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
                if (id != HTMLTokenContext.DECLARATION) continue;
                sb.append(item.getImage());
            }
            if (!(image = sb.toString()).startsWith("<!DOCTYPE")) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
            }
            int index = (image = image.substring(9).trim()).indexOf(32);
            if (index < 0) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
            }
            String rootElem = image.substring(0, index);
            if ((image = image.substring(index).trim()).startsWith("PUBLIC")) {
                sb = new StringBuffer(image = image.substring(6).trim());
                String pi = HTMLSyntaxSupport.getQuotedString(sb);
                if (pi != null) {
                    String si2 = HTMLSyntaxSupport.getQuotedString(sb);
                    return new SyntaxElement.Declaration(this, offset, lastOffset, rootElem, pi, si2);
                }
            } else if (image.startsWith("SYSTEM") && (si = HTMLSyntaxSupport.getQuotedString(sb = new StringBuffer(image = image.substring(6).trim()))) != null) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, rootElem, null, si);
            }
            return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
        }
        if (id == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, item.getOffset(), lastOffset, 2);
        }
        if (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER) {
            while (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
            }
            return new SyntaxElement(this, offset, lastOffset, 3);
        }
        String text = item.getImage();
        if (id == HTMLTokenContext.TAG_CLOSE || id == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
            String name = text;
            TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
            while (id == HTMLTokenContext.WS) {
                lastOffset = this.getTokenEnd(item);
                id = (item = item.getNext()) == null ? null : item.getTokenID();
            }
            if (id == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                return new SyntaxElement.Named(this, offset, this.getTokenEnd(item), 5, name);
            }
            return new SyntaxElement.Named(this, offset, lastOffset, 5, name);
        }
        if (id == HTMLTokenContext.TAG_OPEN || id == HTMLTokenContext.TAG_OPEN_SYMBOL) {
            String name = text;
            ArrayList<String> attrs = new ArrayList<String>();
            TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
            while (!(id == null || id != HTMLTokenContext.WS && id != HTMLTokenContext.ARGUMENT && id != HTMLTokenContext.OPERATOR && id != HTMLTokenContext.VALUE && id != HTMLTokenContext.CHARACTER && item.getTokenContextPath().contains(HTMLTokenContext.contextPath))) {
                if (id == HTMLTokenContext.ARGUMENT) {
                    attrs.add(item.getImage());
                }
                lastOffset = this.getTokenEnd(item);
                id = (item = item.getNext()) == null ? null : item.getTokenID();
            }
            if (id == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                return new SyntaxElement.Tag(this, offset, this.getTokenEnd(item), name, attrs, item.getImage().equals("/>"));
            }
            return new SyntaxElement.Tag(this, offset, lastOffset, name, attrs);
        }
        return null;
    }

    public List getPossibleEndTags(int offset, String prefix) throws BadLocationException {
        prefix = prefix.toUpperCase();
        int prefixLen = prefix.length();
        SyntaxElement elem = this.getElementChain(offset);
        Stack<String> stack = new Stack<String>();
        ArrayList<HTMLCompletionQuery.EndTagItem> result = new ArrayList<HTMLCompletionQuery.EndTagItem>();
        HashSet<String> found = new HashSet<String>();
        DTD dtd = this.getDTD();
        if (elem == null) {
            if (offset > 0) {
                elem = this.getElementChain(offset - 1);
                if (elem == null) {
                    return result;
                }
            } else {
                return result;
            }
        }
        int itemsCount = 0;
        while (elem != null) {
            DTD.Element tag;
            if (elem.getType() == 5 && elem.getText().endsWith(">")) {
                tag = dtd.getElement(((SyntaxElement.Named)elem).getName().toUpperCase());
                if (tag != null && !tag.isEmpty()) {
                    stack.push(((SyntaxElement.Named)elem).getName().toUpperCase());
                }
            } else if (elem.getType() == 4 && !elem.getText().startsWith("<") && (tag = dtd.getElement(((SyntaxElement.Tag)elem).getName().toUpperCase())) != null && !tag.isEmpty()) {
                String name = tag.getName();
                if (stack.empty()) {
                    if (name.startsWith(prefix) && !found.contains(name)) {
                        found.add(name);
                        result.add(new HTMLCompletionQuery.EndTagItem(name, offset - 2 - prefixLen, prefixLen + 2, name, itemsCount));
                    }
                    if (!tag.hasOptionalEnd()) {
                        break;
                    }
                } else if (stack.peek().equals(name)) {
                    stack.pop();
                } else if (!tag.hasOptionalEnd()) break;
            }
            elem = elem.getPrevious();
        }
        return result;
    }

    public List getAutocompletedEndTag(int offset) {
        ArrayList<HTMLCompletionQuery.AutocompleteEndTagItem> l = new ArrayList<HTMLCompletionQuery.AutocompleteEndTagItem>();
        try {
            SyntaxElement elem = this.getElementChain(offset - 1);
            if (elem != null && elem.getType() == 4) {
                String tagName = ((SyntaxElement.Named)elem).getName();
                DTD.Element dtdElem = this.getDTD().getElement(tagName.toUpperCase());
                if (dtdElem == null || !dtdElem.isEmpty()) {
                    HTMLCompletionQuery.AutocompleteEndTagItem eti = new HTMLCompletionQuery.AutocompleteEndTagItem(tagName, offset);
                    l.add(eti);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return l;
    }

    public int checkCompletion(JTextComponent target, String typedText, boolean visible) {
        boolean retVal = true;
        int dotPos = target.getCaret().getDot();
        BaseDocument doc = (BaseDocument)target.getDocument();
        switch (typedText.charAt(typedText.length() - 1)) {
            case '/': {
                if (dotPos < 2) break;
                try {
                    String txtBeforeSpace = doc.getText(dotPos - 2, 2);
                    if (txtBeforeSpace.equals("</")) {
                        return 0;
                    }
                }
                catch (BadLocationException e) {}
                break;
            }
            case ' ': {
                HTMLSyntaxSupport sup = (HTMLSyntaxSupport)doc.getSyntaxSupport().get(HTMLSyntaxSupport.class);
                try {
                    TokenItem ti = sup.getTokenChain(dotPos - 1, dotPos);
                    if (ti != null && ti.getTokenID() == HTMLTokenContext.WS) {
                        return 0;
                    }
                }
                catch (BadLocationException e) {}
                break;
            }
            case '&': 
            case '<': {
                return 0;
            }
            case ';': {
                return 4;
            }
            case '>': {
                HTMLSyntaxSupport sup = (HTMLSyntaxSupport)doc.getSyntaxSupport().get(HTMLSyntaxSupport.class);
                try {
                    SyntaxElement se = this.getElementChain(dotPos - 1);
                    if (se != null && se.getType() == 4) {
                        return 0;
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                return 4;
            }
        }
        return 3;
    }

    public static boolean isTag(TokenItem ti) {
        return ti.getTokenID() == HTMLTokenContext.TAG_OPEN || ti.getTokenID() == HTMLTokenContext.TAG_CLOSE || ti.getTokenID() == HTMLTokenContext.TAG_OPEN_SYMBOL || ti.getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL;
    }

    public static boolean isTagButNotSymbol(TokenItem ti) {
        return ti.getTokenID() == HTMLTokenContext.TAG_OPEN || ti.getTokenID() == HTMLTokenContext.TAG_CLOSE;
    }
}

