/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.EditorPropertyDisplayer;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.ModelProperty;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyDisplayer_Editable;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class CustomEditorDisplayer
implements PropertyDisplayer_Editable {
    private int updatePolicy = 0;
    private Node.Property prop;
    private PropertyEnv env = null;
    private PropertyEditor editor = null;
    private Component customEditor = null;
    boolean ignoreChanges = false;
    private PropertyChangeListener editorListener = null;
    private EnvListener envListener = null;
    private PropertyModel model = null;
    private Object originalValue = null;
    private EventListenerList listenerList = null;
    private boolean ignoreChanges2 = false;
    private PropertyChangeListener remoteEnvListener = null;
    private VetoableChangeListener remotevEnvListener = null;

    public CustomEditorDisplayer(Node.Property prop) {
        this.prop = prop;
    }

    public CustomEditorDisplayer(Node.Property prop, PropertyModel mdl) {
        this(prop);
        this.model = mdl;
    }

    public void setUpdatePolicy(int i) {
        this.updatePolicy = i;
        if (this.env != null) {
            this.env.setChangeImmediate(i != 2);
        }
    }

    private Component getCustomEditor() {
        if (this.customEditor == null) {
            this.customEditor = this.getPropertyEditor().getCustomEditor();
        }
        return this.customEditor;
    }

    PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.setPropertyEditor(PropUtils.getPropertyEditor(this.getProperty()));
        }
        return this.editor;
    }

    public synchronized void dispose() {
        PropertyEditor pred = this.editor;
        Node.Property property = this.prop;
        PropertyEnv penv = this.env;
        Component custom = this.customEditor;
        PropertyModel mdl = this.model;
        PropertyChangeListener pcl = this.remoteEnvListener;
        VetoableChangeListener vcl = this.remotevEnvListener;
        this.setPropertyEnv(null);
        this.setPropertyEditor(null);
        this.remotevEnvListener = null;
        this.remoteEnvListener = null;
        this.customEditor = null;
        this.editor = null;
        this.prop = null;
        this.model = null;
        if (this.getUpdatePolicy() != 2) {
            new Spud(property, pred, mdl, penv, custom, pcl, vcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyEditor(PropertyEditor editor) {
        block8: {
            if (this.editor != null) {
                this.detachFromPropertyEditor(this.editor);
                this.ignoreChanges = true;
            }
            this.editor = editor;
            try {
                if (editor == null) break block8;
                if (!editor.supportsCustomEditor()) {
                    throw new IllegalArgumentException("Property editor " + editor + " for property " + this.getProperty() + " does not support a custom editor.");
                }
                try {
                    this.originalValue = editor.getValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
                PropertyEnv env = new PropertyEnv();
                env.setFeatureDescriptor(EditorPropertyDisplayer.findFeatureDescriptor(this));
                this.setPropertyEnv(env);
                if (editor instanceof ExPropertyEditor) {
                    ((ExPropertyEditor)editor).attachEnv(env);
                }
                this.attachToPropertyEditor(editor);
            }
            finally {
                this.ignoreChanges = false;
            }
        }
    }

    private void setPropertyEnv(PropertyEnv env) {
        if (this.env != null) {
            this.detachFromEnv(this.env);
        }
        this.env = env;
        if (env != null) {
            env.setChangeImmediate(this.getUpdatePolicy() != 2);
            this.attachToEnv(env);
        }
    }

    private void attachToEnv(PropertyEnv env) {
        env.addPropertyChangeListener(this.getEnvListener());
        env.addVetoableChangeListener(this.getEnvListener());
        env.setBeans(EditorPropertyDisplayer.findBeans(this));
    }

    private void detachFromEnv(PropertyEnv env) {
        env.removePropertyChangeListener(this.getEnvListener());
        env.removeVetoableChangeListener(this.getEnvListener());
    }

    private void attachToPropertyEditor(PropertyEditor editor) {
        editor.addPropertyChangeListener(this.getEditorListener());
    }

    private void detachFromPropertyEditor(PropertyEditor editor) {
        editor.removePropertyChangeListener(this.getEditorListener());
    }

    private PropertyChangeListener getEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new EditorListener();
        }
        return this.editorListener;
    }

    private EnvListener getEnvListener() {
        if (this.envListener == null) {
            this.envListener = new EnvListener();
        }
        return this.envListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() throws IllegalArgumentException {
        try {
            this.ignoreChanges = true;
            PropertyEditor editor = this.getPropertyEditor();
            Object entered = this.getEnteredValue();
            try {
                if (entered != null && entered.equals(this.getProperty().getValue())) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                try {
                    if (this.getProperty().canRead()) {
                        editor.setValue(this.model.getValue());
                    }
                }
                catch (ProxyNode.DifferentValuesException dve) {
                }
                catch (Exception ex) {
                    PropertyDialogManager.notify(ex);
                }
                boolean ex = false;
                return ex;
            }
            PropertyEnv env = this.getPropertyEnv();
            Exception exception = PropUtils.updatePropertyEditor(editor, entered);
            if (exception == null && env != null && PropertyEnv.STATE_NEEDS_VALIDATION.equals(env.getState())) {
                String msg = env.silentlySetState(PropertyEnv.STATE_VALID, entered);
                System.err.println("  result of silent set state: " + msg);
                if (msg != null && !PropertyEnv.STATE_VALID.equals(env.getState())) {
                    IllegalArgumentException iae = new IllegalArgumentException("Error setting value");
                    ErrorManager.getDefault().annotate((Throwable)iae, 256, null, msg, null, null);
                    if (!PropertyEnv.STATE_INVALID.equals(env.getState())) {
                        env.silentlySetState(PropertyEnv.STATE_INVALID, null);
                    }
                    throw iae;
                }
            }
            Object res = Boolean.FALSE;
            if (exception == null) {
                res = PropUtils.noDlgUpdateProp(this.getModel(), editor);
                this.originalValue = editor.getValue();
                if (res instanceof Exception && !(res instanceof ProxyNode.DifferentValuesException)) {
                    exception = (Exception)res;
                }
                if (res instanceof InvocationTargetException || res instanceof IllegalAccessException) {
                    PropertyDialogManager.notify((Exception)res);
                }
            }
            if (exception != null) {
                if (exception instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)exception;
                }
                PropertyDialogManager.notify(exception);
                IllegalArgumentException iae = new IllegalArgumentException("Error setting value");
                ErrorManager.getDefault().annotate((Throwable)iae, 256, null, PropUtils.findLocalizedMessage(exception, entered, this.getProperty().getDisplayName()), (Throwable)exception, null);
                throw iae;
            }
            boolean result = Boolean.TRUE.equals(res);
            if (result) {
                this.fireActionPerformed();
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    PropertyModel getModel() {
        if (this.model == null) {
            return new NodePropertyModel(this.getProperty(), null);
        }
        return this.model;
    }

    void setModel(PropertyModel mdl) {
        this.model = mdl;
    }

    public PropertyEnv getPropertyEnv() {
        return this.env;
    }

    public Component getComponent() {
        return this.getCustomEditor();
    }

    public Object getEnteredValue() {
        PropertyEditor editor = this.getPropertyEditor();
        Object result = editor instanceof EnhancedCustomPropertyEditor ? ((EnhancedCustomPropertyEditor)((Object)editor)).getPropertyValue() : editor.getValue();
        return result;
    }

    public Node.Property getProperty() {
        return this.prop;
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    public String isModifiedValueLegal() {
        boolean legal = true;
        String msg = null;
        PropertyEditor editor = this.getPropertyEditor();
        if (this.env != null) {
            legal = this.env.getState() != PropertyEnv.STATE_INVALID;
            System.err.println(" Attempting to validate env");
            if (legal) {
                if (PropertyEnv.STATE_NEEDS_VALIDATION.equals(this.env.getState())) {
                    msg = this.env.silentlySetState(PropertyEnv.STATE_VALID, this.getEnteredValue());
                    legal = msg == null;
                }
            }
        } else if (editor instanceof EnhancedCustomPropertyEditor) {
            Object entered = ((EnhancedCustomPropertyEditor)((Object)editor)).getPropertyValue();
            try {
                editor.setValue(entered);
            }
            catch (IllegalStateException ise) {
                legal = false;
                msg = PropUtils.findLocalizedMessage(ise, entered, this.getProperty().getDisplayName());
            }
        }
        if (!legal && msg == null) {
            msg = MessageFormat.format(NbBundle.getMessage((Class)CustomEditorDisplayer.class, (String)"FMT_CannotUpdateProperty"), editor.getValue(), this.getProperty().getDisplayName());
        }
        return msg;
    }

    public boolean isValueModified() {
        boolean result;
        PropertyEditor editor = this.getPropertyEditor();
        boolean bl = result = editor.getValue() != this.originalValue;
        if (!result && editor instanceof EnhancedCustomPropertyEditor) {
            Object entered = ((EnhancedCustomPropertyEditor)((Object)editor)).getPropertyValue();
            result = entered != null ? entered.equals(this.originalValue) : this.originalValue == null;
        }
        return result;
    }

    public void refresh() {
    }

    public void reset() {
        try {
            this.originalValue = this.getProperty().getValue();
            this.getPropertyEditor().setValue(this.originalValue);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
    }

    public void setEnabled(boolean enabled) {
        Container custEditor = (Container)this.getComponent();
        if (custEditor instanceof Container) {
            this.setEnabled(custEditor, enabled);
        }
        custEditor.setEnabled(enabled);
    }

    public void setEnabled(Container c, boolean enabled) {
        Component[] comp = c.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            Boolean val;
            if (!(comp[i] instanceof JScrollBar)) {
                comp[i].setEnabled(false);
            } else {
                ((JScrollBar)comp[i]).setFocusable(enabled);
            }
            if (!(comp[i] instanceof Container)) continue;
            boolean ignore = false;
            if (comp[i] instanceof JComponent && (val = (Boolean)((JComponent)comp[i]).getClientProperty("dontEnableMe")) != null) {
                ignore = val;
            }
            if (ignore) continue;
            this.setEnabled((Container)comp[i], enabled);
        }
        c.setEnabled(enabled);
    }

    public void setEnteredValue(Object o) {
        PropUtils.updatePropertyEditor(this.getPropertyEditor(), o);
    }

    public void setActionCommand(String val) {
    }

    public String getActionCommand() {
        return null;
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionPerformed() {
        ActionEvent event = new ActionEvent(this, 1001, "userChangedValue");
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? CustomEditorDisplayer.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    private void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? CustomEditorDisplayer.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    void setRemoteEnvListener(PropertyChangeListener l) {
        this.remoteEnvListener = l;
    }

    void setRemoteEnvVetoListener(VetoableChangeListener vl) {
        this.remotevEnvListener = vl;
    }

    private static final class Spud
    implements PropertyChangeListener,
    VetoableChangeListener {
        WeakReference envListener = null;
        WeakReference venvListener = null;
        WeakReference editor = null;
        WeakReference property = null;
        WeakReference env = null;
        WeakReference customEditor = null;
        WeakReference model = null;
        private boolean inGetModel = false;
        private boolean inGetProperty = false;
        private boolean ignoreChanges = false;

        public Spud(Node.Property prop, PropertyEditor editor, PropertyModel model, PropertyEnv env, Component customEditor, PropertyChangeListener envListener, VetoableChangeListener veto) {
            if (prop != null) {
                this.property = new WeakReference<WeakReference>(this.property);
            }
            if (editor != null) {
                this.editor = new WeakReference<PropertyEditor>(editor);
            }
            if (env != null) {
                this.env = new WeakReference<PropertyEnv>(env);
                env.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)env));
                env.addVetoableChangeListener(WeakListeners.vetoableChange((VetoableChangeListener)this, (Object)env));
            }
            if (customEditor != null) {
                this.customEditor = new WeakReference<Component>(customEditor);
            }
            if (envListener != null) {
                this.envListener = new WeakReference<PropertyChangeListener>(envListener);
            }
            if (veto != null) {
                this.venvListener = new WeakReference<VetoableChangeListener>(veto);
            }
            if (model != null) {
                this.model = new WeakReference<PropertyModel>(model);
                model.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)editor));
            }
            if (editor != null) {
                editor.addPropertyChangeListener(this);
            }
        }

        private PropertyEnv getEnv() {
            PropertyEnv result = null;
            if (this.env != null) {
                result = (PropertyEnv)this.env.get();
            }
            return result;
        }

        private Component getCustomEditor() {
            Component result = null;
            if (this.customEditor != null) {
                result = (Component)this.customEditor.get();
            }
            return result;
        }

        private VetoableChangeListener getVetoListener() {
            VetoableChangeListener result = null;
            if (this.venvListener != null) {
                result = (VetoableChangeListener)this.venvListener.get();
            }
            return result;
        }

        private PropertyChangeListener getPropListener() {
            PropertyChangeListener result = null;
            if (this.venvListener != null) {
                result = (PropertyChangeListener)this.venvListener.get();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Node.Property getProperty() {
            Node.Property result = null;
            this.inGetProperty = true;
            try {
                if (this.property != null) {
                    result = (Node.Property)this.property.get();
                }
                if (result == null && !this.inGetModel) {
                    PropertyModel propertyModel = this.getModel();
                }
            }
            finally {
                this.inGetProperty = false;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized PropertyModel getModel() {
            this.inGetModel = true;
            PropertyModel result = null;
            try {
                Node.Property prop;
                if (this.model != null) {
                    result = (PropertyModel)this.model.get();
                }
                if (result == null && !this.inGetProperty && (prop = this.getProperty()) != null) {
                    NodePropertyModel nodePropertyModel = new NodePropertyModel(prop, null);
                    return nodePropertyModel;
                }
            }
            finally {
                this.inGetModel = false;
            }
            return result;
        }

        private PropertyEditor getPropertyEditor() {
            PropertyModel mdl;
            Node.Property prop;
            PropertyEditor result = null;
            if (this.editor != null) {
                result = (PropertyEditor)this.editor.get();
            }
            if (result == null && (prop = this.getProperty()) != null) {
                result = prop.getPropertyEditor();
                this.editor = new WeakReference<PropertyEditor>(result);
            }
            if (result == null && (mdl = this.getModel()) != null) {
                Node.Property p = ModelProperty.toProperty(mdl);
                result = p.getPropertyEditor();
                this.editor = new WeakReference<PropertyEditor>(result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.ignoreChanges) {
                return;
            }
            if ("propertyValueValid".equals(evt.getPropertyName())) {
                return;
            }
            this.ignoreChanges = true;
            try {
                PropertyChangeListener pcl;
                if (evt.getSource() instanceof PropertyEnv && (pcl = this.getPropListener()) != null) {
                    pcl.propertyChange(evt);
                }
                if (evt.getSource() instanceof PropertyModel) {
                    // empty if block
                }
                if (evt.getSource() instanceof PropertyEditor) {
                    this.handleChangeFromEditor((PropertyEditor)evt.getSource());
                }
            }
            finally {
                this.ignoreChanges = false;
            }
        }

        private void handleChangeFromEditor(PropertyEditor ed) {
            this.commit(ed);
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            VetoableChangeListener vcl = this.getVetoListener();
            if (vcl != null) {
                vcl.vetoableChange(evt);
            }
        }

        public Object getEnteredValue(PropertyEditor editor) {
            Object result = null;
            Component custom = this.getCustomEditor();
            if (editor instanceof EnhancedCustomPropertyEditor) {
                result = ((EnhancedCustomPropertyEditor)((Object)editor)).getPropertyValue();
            } else if (this.customEditor instanceof EnhancedCustomPropertyEditor) {
                result = ((EnhancedCustomPropertyEditor)((Object)custom)).getPropertyValue();
            }
            if (result == null) {
                result = editor.getValue();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean commit(PropertyEditor editor) {
            try {
                Object value;
                PropertyModel model = this.getModel();
                Node.Property prop = this.getProperty();
                Object entered = this.getEnteredValue(editor);
                if (model != null) {
                    value = model.getValue();
                } else if (prop != null) {
                    value = prop.getValue();
                } else {
                    if (editor != null) {
                        editor.removePropertyChangeListener(this);
                    }
                    boolean bl = false;
                    return bl;
                }
                PropertyEnv env = this.getEnv();
                try {
                    if (entered != null && entered.equals(value)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    try {
                        if (prop.canRead()) {
                            editor.setValue(model.getValue());
                        }
                    }
                    catch (ProxyNode.DifferentValuesException dve) {
                    }
                    catch (Exception ex) {
                        PropertyDialogManager.notify(ex);
                    }
                    boolean ex = false;
                    return ex;
                }
                Exception exception = PropUtils.updatePropertyEditor(editor, entered);
                if (exception == null && env != null && PropertyEnv.STATE_NEEDS_VALIDATION.equals(env.getState())) {
                    String msg = env.silentlySetState(PropertyEnv.STATE_VALID, entered);
                    if (msg != null && !PropertyEnv.STATE_VALID.equals(env.getState())) {
                        IllegalArgumentException iae = new IllegalArgumentException("Error setting value");
                        ErrorManager.getDefault().annotate((Throwable)iae, 256, null, msg, null, null);
                        if (!PropertyEnv.STATE_INVALID.equals(env.getState())) {
                            env.silentlySetState(PropertyEnv.STATE_INVALID, null);
                        }
                        throw iae;
                    }
                }
                Object res = Boolean.FALSE;
                if (exception == null) {
                    res = PropUtils.noDlgUpdateProp(model, editor);
                    if (res instanceof Exception && !(res instanceof ProxyNode.DifferentValuesException)) {
                        exception = (Exception)res;
                    }
                    if (res instanceof InvocationTargetException || res instanceof IllegalAccessException) {
                        PropertyDialogManager.notify((Exception)res);
                    }
                }
                if (exception != null) {
                    if (exception instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)exception;
                    }
                    PropertyDialogManager.notify(exception);
                    IllegalArgumentException iae = new IllegalArgumentException("Error setting value");
                    ErrorManager.getDefault().annotate((Throwable)iae, 256, null, PropUtils.findLocalizedMessage(exception, entered, this.getProperty().getDisplayName()), (Throwable)exception, null);
                    throw iae;
                }
                boolean result = Boolean.TRUE.equals(res);
                if (result && env != null) {
                    env.setState(PropertyEnv.STATE_VALID);
                }
                boolean bl = result;
                return bl;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            finally {
                this.ignoreChanges = false;
            }
            return false;
        }
    }

    private class EditorListener
    implements PropertyChangeListener {
        private EditorListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (CustomEditorDisplayer.this.ignoreChanges) {
                return;
            }
            if ("propertyValueValid".equals(evt.getPropertyName())) {
                return;
            }
            if (CustomEditorDisplayer.this.ignoreChanges2) {
                return;
            }
            CustomEditorDisplayer.this.ignoreChanges2 = true;
            if (CustomEditorDisplayer.this.getUpdatePolicy() != 2) {
                CustomEditorDisplayer.this.commit();
            }
            CustomEditorDisplayer.this.fireStateChanged();
            CustomEditorDisplayer.this.ignoreChanges2 = false;
        }
    }

    private class EnvListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private EnvListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CustomEditorDisplayer.this.fireStateChanged();
            if (CustomEditorDisplayer.this.remoteEnvListener != null) {
                CustomEditorDisplayer.this.remoteEnvListener.propertyChange(evt);
            }
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (CustomEditorDisplayer.this.remotevEnvListener != null) {
                CustomEditorDisplayer.this.remotevEnvListener.vetoableChange(evt);
            }
        }
    }
}

