/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.DefaultHandle;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class AbstractNode
extends Node {
    private static final String[] icons = new String[]{"", "32", "", "32", "Open", "Open32", "Open", "Open32"};
    private static final int ICON_BASE = -1;
    private static final int OPENED_ICON_BASE = 3;
    private static final PasteType[] NO_PASTE_TYPES = new PasteType[0];
    private static final NewType[] NO_NEW_TYPES = new NewType[0];
    private static final String DEFAULT_ICON_BASE = "org/openide/resources/defaultNode";
    private static final String DEFAULT_ICON_EXTENSION = ".gif";
    private static final String DEFAULT_ICON = "org/openide/resources/defaultNode.gif";
    private static final WeakHashMap overridesGetDefaultAction = new WeakHashMap(27);
    protected MessageFormat displayFormat;
    private Action preferredAction;
    private String iconBase = "org/openide/resources/defaultNode";
    private String iconExtension = ".gif";
    private Object lookup;
    private Sheet sheet;
    protected SystemAction[] systemActions;
    private SheetAndCookieListener sheetCookieL = null;

    public AbstractNode(Children children) {
        this(children, null);
    }

    public AbstractNode(Children children, Lookup lookup) {
        super(children, lookup);
        super.setName("");
    }

    public Node cloneNode() {
        try {
            if (this instanceof Cloneable) {
                return (Node)this.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return new FilterNode(this);
    }

    public void setName(String s) {
        super.setName(s);
        MessageFormat mf = this.displayFormat;
        if (mf != null) {
            this.setDisplayName(mf.format(new Object[]{s}));
        } else {
            this.fireDisplayNameChange(null, null);
        }
    }

    public void setIconBase(String base) {
        this.setIconBaseWithExtension(base, DEFAULT_ICON_EXTENSION);
    }

    public final void setIconBaseWithExtension(String baseExt) {
        int lastDot = baseExt.lastIndexOf(46);
        int lastSlash = baseExt.lastIndexOf(47);
        if (lastSlash > lastDot || lastDot == -1) {
            this.setIconBaseWithExtension(baseExt, "");
        } else {
            String base = baseExt.substring(0, lastDot);
            String ext = baseExt.substring(lastDot);
            this.setIconBaseWithExtension(base, ext);
        }
    }

    private final void setIconBaseWithExtension(String base, String extension) {
        if (base.equals(this.iconBase) && extension.equals(this.iconExtension)) {
            return;
        }
        this.iconBase = base;
        this.iconExtension = extension;
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Image getIcon(int type) {
        return this.findIcon(type, -1);
    }

    public Image getOpenedIcon(int type) {
        return this.findIcon(type, 3);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private Image findIcon(int type, int ib) {
        String res = this.iconBase + icons[type + ib] + this.iconExtension;
        Image im = Utilities.loadImage((String)res, (boolean)true);
        if (im != null) {
            return im;
        }
        res = this.iconBase + icons[1 + ib] + this.iconExtension;
        im = Utilities.loadImage((String)res, (boolean)true);
        if (im != null) {
            return im;
        }
        if (ib == 3) {
            return this.findIcon(type, -1);
        }
        return this.getDefaultIcon();
    }

    Image getDefaultIcon() {
        Image i = Utilities.loadImage((String)DEFAULT_ICON, (boolean)true);
        if (i == null) {
            throw new MissingResourceException("No default icon", "", DEFAULT_ICON);
        }
        return i;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    protected final synchronized void setSheet(Sheet s) {
        this.setSheetImpl(s);
        this.firePropertySetsChange(null, null);
    }

    private synchronized void setSheetImpl(Sheet s) {
        if (this.sheetCookieL == null) {
            this.sheetCookieL = new SheetAndCookieListener();
        }
        if (this.sheet != null) {
            this.sheet.removePropertyChangeListener(this.sheetCookieL);
        }
        s.addPropertyChangeListener(this.sheetCookieL);
        this.sheet = s;
    }

    protected Sheet createSheet() {
        return new Sheet();
    }

    protected final synchronized Sheet getSheet() {
        if (this.sheet != null) {
            return this.sheet;
        }
        this.setSheetImpl(this.createSheet());
        return this.sheet;
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet s = this.getSheet();
        return s.toArray();
    }

    boolean propertySetsAreKnown() {
        return this.sheet != null;
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable(this, 1);
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable(this, 4);
    }

    public Transferable drag() throws IOException {
        return this.clipboardCopy();
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    protected void createPasteTypes(Transferable t, List s) {
        NodeTransfer.Paste p = NodeTransfer.findPaste(t);
        if (p != null) {
            s.addAll(Arrays.asList(p.types(this)));
        }
    }

    public final PasteType[] getPasteTypes(Transferable t) {
        LinkedList s = new LinkedList();
        this.createPasteTypes(t, s);
        return s.toArray(NO_PASTE_TYPES);
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        LinkedList s = new LinkedList();
        this.createPasteTypes(t, s);
        return s.isEmpty() ? null : (PasteType)s.get(0);
    }

    public NewType[] getNewTypes() {
        return NO_NEW_TYPES;
    }

    private boolean overridesAMethod(String name, Class[] arguments) {
        try {
            Method m = this.getClass().getMethod(name, arguments);
            if (m.getDeclaringClass() != AbstractNode.class) {
                return true;
            }
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action getPreferredAction() {
        boolean delegate = false;
        Class<?> c = this.getClass();
        if (c != AbstractNode.class) {
            WeakHashMap weakHashMap = overridesGetDefaultAction;
            synchronized (weakHashMap) {
                Boolean b;
                Object in = overridesGetDefaultAction.get(c);
                if (in == this) {
                    overridesGetDefaultAction.put(c, Boolean.FALSE);
                    return this.preferredAction;
                }
                if (in == null) {
                    Boolean bl = b = this.overridesAMethod("getDefaultAction", new Class[0]) ? Boolean.TRUE : Boolean.FALSE;
                    if (b.booleanValue()) {
                        overridesGetDefaultAction.put(c, this);
                        this.getDefaultAction();
                        if (overridesGetDefaultAction.get(c) == this) {
                            overridesGetDefaultAction.put(c, b);
                        }
                    } else {
                        overridesGetDefaultAction.put(c, b);
                    }
                } else {
                    b = (Boolean)in;
                }
                delegate = b;
            }
        }
        return delegate ? this.getDefaultAction() : this.preferredAction;
    }

    public SystemAction getDefaultAction() {
        Action a = this.getPreferredAction();
        if (a instanceof SystemAction) {
            return (SystemAction)a;
        }
        return null;
    }

    public void setDefaultAction(SystemAction action) {
        this.preferredAction = action;
    }

    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
            if (this.systemActions == null) {
                this.systemActions = super.getActions();
            }
        }
        return this.systemActions;
    }

    protected SystemAction[] createActions() {
        return null;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public Component getCustomizer() {
        return null;
    }

    protected final synchronized void setCookieSet(CookieSet s) {
        CookieSet cookieSet;
        if (this.internalLookup(false) != null) {
            throw new IllegalStateException("CookieSet cannot be used when lookup is associated with the node");
        }
        if (this.sheetCookieL == null) {
            this.sheetCookieL = new SheetAndCookieListener();
        }
        if ((cookieSet = (CookieSet)this.lookup) != null) {
            cookieSet.removeChangeListener(this.sheetCookieL);
        }
        s.addChangeListener(this.sheetCookieL);
        this.lookup = s;
        this.fireCookieChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        if (this.internalLookup(false) != null) {
            throw new IllegalStateException("CookieSet cannot be used when lookup is associated with the node");
        }
        CookieSet s = (CookieSet)this.lookup;
        if (s != null) {
            return s;
        }
        AbstractNode abstractNode = this;
        synchronized (abstractNode) {
            if (this.lookup != null) {
                return (CookieSet)this.lookup;
            }
            this.setCookieSet(new CookieSet());
            return (CookieSet)this.lookup;
        }
    }

    public Node.Cookie getCookie(Class type) {
        if (this.lookup instanceof CookieSet) {
            CookieSet c = (CookieSet)this.lookup;
            return c.getCookie(type);
        }
        return super.getCookie(type);
    }

    public Node.Handle getHandle() {
        return DefaultHandle.createHandle(this);
    }

    private final class SheetAndCookieListener
    implements PropertyChangeListener,
    ChangeListener {
        SheetAndCookieListener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            AbstractNode.this.firePropertySetsChange(null, null);
        }

        public void stateChanged(ChangeEvent ev) {
            AbstractNode.this.fireCookieChange();
        }
    }
}

