/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TCPClient;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.ZoneTransferException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZoneTransferIn {
    private static final int INITIALSOA = 0;
    private static final int FIRSTDATA = 1;
    private static final int IXFR_DELSOA = 2;
    private static final int IXFR_DEL = 3;
    private static final int IXFR_ADDSOA = 4;
    private static final int IXFR_ADD = 5;
    private static final int AXFR = 6;
    private static final int END = 7;
    private Name zname;
    private int qtype;
    private int dclass;
    private long ixfr_serial;
    private boolean want_fallback;
    private SocketAddress address;
    private TCPClient client;
    private TSIG tsig;
    private TSIG.StreamVerifier verifier;
    private long timeout;
    private int state;
    private long end_serial;
    private long current_serial;
    private Record initialsoa;
    private int rtype;
    private List axfr;
    private List ixfr;

    public static ZoneTransferIn newAXFR(Name name, SocketAddress socketAddress, TSIG tSIG) {
        return new ZoneTransferIn(name, 252, 0L, false, socketAddress, tSIG);
    }

    public static ZoneTransferIn newAXFR(Name name, String string, int n, TSIG tSIG) throws UnknownHostException {
        return ZoneTransferIn.newAXFR(name, new InetSocketAddress(string, n), tSIG);
    }

    public static ZoneTransferIn newAXFR(Name name, SimpleResolver simpleResolver) {
        ZoneTransferIn zoneTransferIn = ZoneTransferIn.newAXFR(name, simpleResolver.getAddress(), simpleResolver.getTSIGKey());
        zoneTransferIn.timeout = (long)simpleResolver.getTimeout() * 1000L;
        return zoneTransferIn;
    }

    public static ZoneTransferIn newAXFR(Name name, String string, TSIG tSIG) throws UnknownHostException {
        return ZoneTransferIn.newAXFR(name, string, 0, tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l, boolean bl, SocketAddress socketAddress, TSIG tSIG) {
        return new ZoneTransferIn(name, 251, l, bl, socketAddress, tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l, boolean bl, String string, int n, TSIG tSIG) throws UnknownHostException {
        return ZoneTransferIn.newIXFR(name, l, bl, new InetSocketAddress(string, n), tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l, boolean bl, SimpleResolver simpleResolver) {
        ZoneTransferIn zoneTransferIn = ZoneTransferIn.newIXFR(name, l, bl, simpleResolver.getAddress(), simpleResolver.getTSIGKey());
        zoneTransferIn.timeout = (long)simpleResolver.getTimeout() * 1000L;
        return zoneTransferIn;
    }

    public static ZoneTransferIn newIXFR(Name name, long l, boolean bl, String string, TSIG tSIG) throws UnknownHostException {
        return ZoneTransferIn.newIXFR(name, l, bl, string, 0, tSIG);
    }

    public Name getName() {
        return this.zname;
    }

    public int getType() {
        return this.qtype;
    }

    public void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeout cannt be negative");
        }
        this.timeout = 1000L * (long)n;
    }

    public void setDClass(int n) {
        DClass.check(n);
        this.dclass = n;
    }

    private final void openConnection() throws IOException {
        long l = System.currentTimeMillis() + this.timeout;
        this.client = new TCPClient(l);
        this.client.connect(this.address);
    }

    private final void sendQuery() throws IOException {
        Object object;
        Record record = Record.newRecord(this.zname, this.qtype, this.dclass);
        Message message = new Message();
        message.getHeader().setOpcode(0);
        message.addRecord(record, 0);
        if (this.qtype == 251) {
            object = new SOARecord(this.zname, this.dclass, 0L, Name.root, Name.root, this.ixfr_serial, 0L, 0L, 0L, 0L);
            message.addRecord((Record)object, 2);
        }
        if (this.tsig != null) {
            this.tsig.apply(message, null);
            this.verifier = new TSIG.StreamVerifier(this.tsig, message.getTSIG());
        }
        object = message.toWire((char)-1);
        this.client.send((byte[])object);
    }

    private final long getSOASerial(Record record) {
        SOARecord sOARecord = (SOARecord)record;
        return sOARecord.getSerial();
    }

    private final void logxfr(String string) {
        if (Options.check("verbose")) {
            System.out.println(this.zname + ": " + string);
        }
    }

    private final void fail(String string) throws ZoneTransferException {
        throw new ZoneTransferException(string);
    }

    private final void fallback() throws ZoneTransferException {
        if (!this.want_fallback) {
            this.fail("server doesn't support IXFR");
        }
        this.logxfr("falling back to AXFR");
        this.qtype = 252;
        this.state = 0;
    }

    private final void parseRR(Record record) throws ZoneTransferException {
        Name name = record.getName();
        int n = record.getType();
        switch (this.state) {
            case 0: {
                if (n != 6) {
                    this.fail("missing initial SOA");
                }
                this.initialsoa = record;
                this.end_serial = this.getSOASerial(record);
                if (this.qtype == 251 && this.end_serial <= this.ixfr_serial) {
                    this.logxfr("up to date");
                    this.state = 7;
                    break;
                }
                this.state = 1;
                break;
            }
            case 1: {
                if (this.qtype == 251 && n == 6 && this.getSOASerial(record) == this.ixfr_serial) {
                    this.rtype = 251;
                    this.ixfr = new ArrayList();
                    this.logxfr("got incremental response");
                    this.state = 2;
                } else {
                    this.rtype = 252;
                    this.axfr = new ArrayList();
                    this.axfr.add(this.initialsoa);
                    this.logxfr("got nonincremental response");
                    this.state = 6;
                }
                this.parseRR(record);
                return;
            }
            case 2: {
                Delta delta = new Delta();
                this.ixfr.add(delta);
                delta.start = this.getSOASerial(record);
                delta.deletes.add(record);
                this.state = 3;
                break;
            }
            case 3: {
                if (n == 6) {
                    this.current_serial = this.getSOASerial(record);
                    this.state = 4;
                    this.parseRR(record);
                    return;
                }
                Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
                delta.deletes.add(record);
                break;
            }
            case 4: {
                Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
                delta.end = this.getSOASerial(record);
                delta.adds.add(record);
                this.state = 5;
                break;
            }
            case 5: {
                if (n == 6) {
                    long l = this.getSOASerial(record);
                    if (l == this.end_serial) {
                        this.state = 7;
                        break;
                    }
                    if (l != this.current_serial) {
                        this.fail("IXFR out of sync: expected serial " + this.current_serial + " , got " + l);
                    } else {
                        this.state = 2;
                        this.parseRR(record);
                        return;
                    }
                }
                Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
                delta.adds.add(record);
                break;
            }
            case 6: {
                if (n == 1 && record.getDClass() != this.dclass) break;
                this.axfr.add(record);
                if (n != 6) break;
                this.state = 7;
                break;
            }
            case 7: {
                this.fail("extra data");
                break;
            }
            default: {
                this.fail("invalid state");
            }
        }
    }

    private final void closeConnection() {
        try {
            this.client.cleanup();
        }
        catch (IOException iOException) {}
    }

    private final Message parseMessage(byte[] byArray) throws WireParseException {
        try {
            return new Message(byArray);
        }
        catch (IOException iOException) {
            if (iOException instanceof WireParseException) {
                throw (WireParseException)iOException;
            }
            throw new WireParseException("Error parsing message");
        }
    }

    private final void doxfr() throws IOException, ZoneTransferException {
        this.sendQuery();
        while (this.state != 7) {
            int n;
            Object object;
            byte[] byArray = this.client.recv();
            Message message = this.parseMessage(byArray);
            if (message.getHeader().getRcode() == 0 && this.verifier != null) {
                object = message.getTSIG();
                n = this.verifier.verify(message, byArray);
                if (n == 0 && object != null) {
                    message.tsigState = 1;
                } else if (n == 0) {
                    message.tsigState = 2;
                } else {
                    this.fail("TSIG failure");
                }
            }
            object = message.getSectionArray(1);
            if (this.state == 0) {
                Record record;
                n = message.getRcode();
                if (n != 0) {
                    if (this.qtype == 251 && n == 4) {
                        this.fallback();
                        this.doxfr();
                        return;
                    }
                    this.fail(Rcode.string(n));
                }
                if ((record = message.getQuestion()) != null && record.getType() != this.qtype) {
                    this.fail("invalid question section");
                }
                if (((Record[])object).length == 0 && this.qtype == 251) {
                    this.fallback();
                    this.doxfr();
                    return;
                }
            }
            n = 0;
            while (n < ((Record[])object).length) {
                this.parseRR(object[n]);
                ++n;
            }
            if (this.state != 7 || message.tsigState != 2) continue;
            this.fail("last message must be signed");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List run() throws IOException, ZoneTransferException {
        this.openConnection();
        try {
            this.doxfr();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.closeConnection();
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.closeConnection();
            if (this.axfr != null) {
                return this.axfr;
            }
            return this.ixfr;
        }
    }

    public boolean isAXFR() {
        boolean bl = false;
        if (this.rtype == 252) {
            bl = true;
        }
        return bl;
    }

    public List getAXFR() {
        return this.axfr;
    }

    public boolean isIXFR() {
        boolean bl = false;
        if (this.rtype == 251) {
            bl = true;
        }
        return bl;
    }

    public List getIXFR() {
        return this.ixfr;
    }

    public boolean isCurrent() {
        boolean bl = false;
        if (this.axfr == null && this.ixfr == null) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.timeout = 900000L;
    }

    private ZoneTransferIn() {
        this.this();
    }

    private ZoneTransferIn(Name name, int n, long l, boolean bl, SocketAddress socketAddress, TSIG tSIG) {
        this.this();
        this.address = socketAddress;
        this.tsig = tSIG;
        if (name.isAbsolute()) {
            this.zname = name;
        } else {
            try {
                this.zname = Name.concatenate(name, Name.root);
            }
            catch (NameTooLongException nameTooLongException) {
                throw new IllegalArgumentException("ZoneTransferIn: name too long");
            }
        }
        this.qtype = n;
        this.dclass = 1;
        this.ixfr_serial = l;
        this.want_fallback = bl;
        this.state = 0;
    }

    public static class Delta {
        public long start;
        public long end;
        public List adds = new ArrayList();
        public List deletes = new ArrayList();

        private Delta() {
        }
    }
}

