/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;

public final class Bidi {
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    private static final int LTOR = 1;
    private static final int RTOL = 2;
    private char[] text;
    private int textOffset;
    private byte[] embeddings;
    private int embeddingOffset;
    private int length;
    private int flags;
    private int baseEmbedding;
    private byte[] types;
    private byte[] levels;
    private ArrayList formatterIndices;
    private int[] runs;
    private int resultFlags;

    private final void computeTypes() {
        this.types = new byte[this.length];
        int n = 0;
        while (n < this.length) {
            this.types[n] = Character.getDirectionality(this.text[this.textOffset + n]);
            ++n;
        }
    }

    private final int computeParagraphEmbeddingLevel() {
        if (this.flags == 0 || this.flags == 1) {
            return this.flags;
        }
        int n = 0;
        while (n < this.length) {
            byte by = this.types[n];
            if (by == 0) {
                return 0;
            }
            if (by == 1 || by == 1) {
                return 1;
            }
            ++n;
        }
        int n2 = 0;
        if (this.flags == -2) {
            n2 = 1;
        }
        return 1 - n2;
    }

    private final void computeExplicitLevels() {
        int n;
        int n2;
        int n3;
        this.levels = new byte[this.length];
        int n4 = this.baseEmbedding;
        int n5 = -1;
        byte[] byArray = new byte[62];
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.length) {
            if (this.embeddings != null && this.embeddings[this.embeddingOffset + n7] != 0) {
                n4 = this.embeddings[this.embeddingOffset + n7];
                if (n4 < 0) {
                    n4 = (byte)(-n4);
                    int n8 = 0;
                    if (n4 % 2 == 0) {
                        n8 = 1;
                    }
                    n5 = 1 - n8;
                } else {
                    n5 = -1;
                }
            } else {
                n3 = 0;
                n2 = 1;
                switch (this.types[n7]) {
                    case 14: 
                    case 15: {
                        n3 = 1;
                    }
                    case 16: 
                    case 17: {
                        n = n3 != 0 ? (int)((byte)((n4 & 0xFFFFFFFE) + 2)) : (int)((byte)(n4 + 1 | 1));
                        if (n >= 62) break;
                        if (n5 != -1) {
                            n4 = (byte)(n4 | 0xFFFFFF80);
                        }
                        byArray[n6++] = n4;
                        n4 = n;
                        if (this.types[n7] == 15) {
                            n5 = 0;
                            break;
                        }
                        if (this.types[n7] == 17) {
                            n5 = 1;
                            break;
                        }
                        n5 = -1;
                        break;
                    }
                    case 18: {
                        if (n6 == 0) break;
                        n = byArray[--n6];
                        n4 = (byte)(n & 0x7F);
                        if (n < 0) {
                            int n9 = 0;
                            if ((n & 1) == 0) {
                                n9 = 1;
                            }
                            n5 = 1 - n9;
                            break;
                        }
                        n5 = -1;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                this.levels[n7] = n4;
                if (n2 != 0) {
                    if (this.formatterIndices == null) {
                        this.formatterIndices = new ArrayList();
                    }
                    this.formatterIndices.add(n7);
                } else if (n5 != -1) {
                    this.types[n7] = n5;
                }
            }
            ++n7;
        }
        if (this.formatterIndices == null) {
            return;
        }
        n7 = 0;
        n3 = 0;
        n2 = this.formatterIndices.size();
        n = 0;
        while (n <= n2) {
            int n10 = n == n2 ? this.length : (Integer)this.formatterIndices.get(n);
            int n11 = n10 - n3;
            System.arraycopy(this.levels, n3, this.levels, n7, n11);
            System.arraycopy(this.types, n3, this.types, n7, n11);
            n7 += n11;
            n3 = n10 + 1;
            ++n;
        }
        this.length -= this.formatterIndices.size();
    }

    private final void computeRuns() {
        int n = 0;
        int n2 = this.baseEmbedding;
        int n3 = 0;
        while (n3 < this.length) {
            if (this.levels[n3] != n2) {
                n2 = this.levels[n3];
                ++n;
            }
            ++n3;
        }
        if (this.runs == null || this.runs.length != n + 1) {
            this.runs = new int[n + 1];
        }
        n3 = 0;
        int n4 = 0;
        n2 = this.baseEmbedding;
        int n5 = 0;
        while (n5 < this.length) {
            if (this.levels[n5] != n2) {
                this.runs[n3++] = n4;
                n4 = n5;
                n2 = this.levels[n5];
            }
            ++n5;
        }
        this.runs[n3++] = n4;
    }

    private final void resolveWeakTypes() {
        int n = this.getRunCount();
        int n2 = this.baseEmbedding;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.getRunStart(n3);
            int n5 = this.getRunLimit(n3);
            int n6 = this.getRunLevel(n3);
            int n7 = 0;
            if (Math.max(n2, n6) % 2 == 0) {
                n7 = 1;
            }
            int n8 = 1 - n7;
            int n9 = n3 == n - 1 ? this.baseEmbedding : this.getRunLevel(n3 + 1);
            int n10 = 0;
            if (Math.max(n6, n9) % 2 == 0) {
                n10 = 1;
            }
            int n11 = 1 - n10;
            int n12 = n8;
            int n13 = n8;
            int n14 = n4;
            while (n14 < n5) {
                int n15;
                int n16 = n15 = n14 == n5 - 1 ? n11 : this.types[n14 + 1];
                if (this.types[n14] == 8) {
                    this.types[n14] = n12;
                } else {
                    n12 = this.types[n14];
                }
                if (this.types[n14] == 3) {
                    if (n13 == 2) {
                        this.types[n14] = 6;
                    }
                } else if (this.types[n14] == 0 || this.types[n14] == 1 || this.types[n14] == 2) {
                    n13 = this.types[n14];
                }
                if (this.types[n14] == 2) {
                    this.types[n14] = 1;
                }
                if (n12 == 3 && n15 == 3) {
                    if (this.types[n14] == 4 || this.types[n14] == 7) {
                        this.types[n14] = n15;
                    }
                } else if (n12 == 6 && n15 == 6 && this.types[n14] == 7) {
                    this.types[n14] = n15;
                }
                if (this.types[n14] == 5 || this.types[n14] == 9) {
                    if (n12 == 3) {
                        this.types[n14] = n12;
                    } else {
                        int n17 = n14 + 1;
                        while (n17 < n5 && (this.types[n17] == 5 || this.types[n17] == 9)) {
                            ++n17;
                        }
                        if (n17 < n5 && this.types[n17] == 3) {
                            int n18 = n14;
                            while (n18 < n17) {
                                this.types[n18] = 3;
                                ++n18;
                            }
                        }
                    }
                }
                if (this.types[n14] == 5 || this.types[n14] == 5 || this.types[n14] == 7 || this.types[n14] == 9) {
                    this.types[n14] = 13;
                }
                if (n13 == 0 && this.types[n14] == 3) {
                    this.types[n14] = n13;
                }
                ++n14;
            }
            n2 = n6;
            ++n3;
        }
    }

    private final void resolveNeutralTypes() {
        int n = this.getRunCount();
        int n2 = this.baseEmbedding;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.getRunStart(n3);
            int n5 = this.getRunLimit(n3);
            int n6 = this.getRunLevel(n3);
            int n7 = 0;
            if (n6 % 2 == 0) {
                n7 = 1;
            }
            int n8 = 1 - n7;
            int n9 = 0;
            if (Math.max(n2, n6) % 2 == 0) {
                n9 = 1;
            }
            int n10 = 1 - n9;
            int n11 = n3 == n - 1 ? this.baseEmbedding : this.getRunLevel(n3 + 1);
            int n12 = 0;
            if (Math.max(n6, n11) % 2 == 0) {
                n12 = 1;
            }
            int n13 = 1 - n12;
            int n14 = n10;
            int n15 = -1;
            int n16 = n4;
            while (n16 <= n5) {
                int n17 = -1;
                int n18 = n16 == n5 ? n13 : this.types[n16];
                switch (n18) {
                    case 0: {
                        n17 = 0;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n17 = 1;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: {
                        if (n15 != -1) break;
                        n15 = n16;
                        break;
                    }
                }
                if (n17 != -1) {
                    if (n15 != -1) {
                        int n19 = n14 == n17 ? n14 : n8;
                        int n20 = n15;
                        while (n20 < n16) {
                            this.types[n16] = n19;
                            ++n20;
                        }
                    }
                    n14 = n17;
                    n15 = -1;
                }
                ++n16;
            }
            n2 = n6;
            ++n3;
        }
    }

    private final void resolveImplicitLevels() {
        int n = 0;
        while (n < this.length) {
            if ((this.levels[n] & 1) == 0) {
                if (this.types[n] == 1) {
                    int n2 = n;
                    this.levels[n2] = (byte)(this.levels[n2] + 1);
                } else if (this.types[n] == 6 || this.types[n] == 3) {
                    int n3 = n;
                    this.levels[n3] = (byte)(this.levels[n3] + 2);
                }
            } else if (this.types[n] == 0 || this.types[n] == 6 || this.types[n] == 3) {
                int n4 = n;
                this.levels[n4] = (byte)(this.levels[n4] + 1);
            }
            this.resultFlags |= 1 << (this.levels[n] & 1);
            ++n;
        }
        this.resultFlags |= 1 << this.baseEmbedding;
    }

    private final void reinsertFormattingCodes() {
        if (this.formatterIndices == null) {
            return;
        }
        int n = this.length;
        int n2 = this.levels.length;
        int n3 = this.formatterIndices.size() - 1;
        while (n3 >= 0) {
            int n4 = (Integer)this.formatterIndices.get(n3);
            int n5 = n2 - n4 - 1;
            n2 = n4;
            n -= n5;
            if (n4 + 1 < this.levels.length) {
                System.arraycopy(this.levels, n, this.levels, n4 + 1, n5);
            }
            int n6 = n2 == this.levels.length - 1 ? this.baseEmbedding : this.levels[n2 + 1];
            int n7 = n == 0 ? this.baseEmbedding : this.levels[n];
            this.levels[n2] = (byte)Math.max(n7, n6);
            --n3;
        }
        this.length = this.levels.length;
    }

    private final void runBidi() {
        this.computeTypes();
        this.baseEmbedding = this.computeParagraphEmbeddingLevel();
        this.computeExplicitLevels();
        this.computeRuns();
        this.resolveWeakTypes();
        this.resolveNeutralTypes();
        this.resolveImplicitLevels();
        this.types = null;
        this.reinsertFormattingCodes();
        this.computeRuns();
    }

    public final boolean baseIsLeftToRight() {
        boolean bl = false;
        if (this.baseEmbedding == 0) {
            bl = true;
        }
        return bl;
    }

    public final Bidi createLineBidi(int n, int n2) {
        int n3 = this.getLevelAt(n);
        int n4 = 0;
        if (n3 % 2 == 0) {
            n4 = 1;
        }
        int n5 = 1 - n4;
        return new Bidi(this.text, this.textOffset + n, this.embeddings, this.embeddingOffset + n, n2 - n, n5);
    }

    public final int getBaseLevel() {
        return this.baseEmbedding;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getLevelAt(int n) {
        if (n < 0 || n >= this.length) {
            return this.getBaseLevel();
        }
        return this.levels[n];
    }

    public final int getRunCount() {
        return this.runs.length;
    }

    public final int getRunLevel(int n) {
        return this.levels[this.runs[n]];
    }

    public final int getRunLimit(int n) {
        if (n == this.runs.length - 1) {
            return this.length;
        }
        return this.runs[n + 1];
    }

    public final int getRunStart(int n) {
        return this.runs[n];
    }

    public final boolean isLeftToRight() {
        boolean bl = false;
        if (this.resultFlags == 1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMixed() {
        boolean bl = false;
        if (this.resultFlags == 3) {
            bl = true;
        }
        return bl;
    }

    public final boolean isRightToLeft() {
        boolean bl = false;
        if (this.resultFlags == 2) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        return "Bidi Bidi Bidi I like you, Buck!";
    }

    /*
     * Unable to fully structure code
     */
    public static final void reorderVisually(byte[] var0, int var1_1, Object[] var2_2, int var3_3, int var4_4) {
        var5_5 = new byte[var4_4];
        var6_6 = 0;
        var7_7 = 63;
        var8_8 = 0;
        while (var8_8 < var4_4) {
            var5_5[var8_8] = var0[var1_1 + var8_8];
            var6_6 = Math.max(var5_5[var8_8], var6_6);
            if (var5_5[var8_8] % 2 != 0) {
                var7_7 = Math.min(var7_7, var5_5[var8_8]);
            }
            ++var8_8;
        }
        var8_8 = var6_6;
        while (var8_8 >= var7_7) {
            var9_9 = 0;
            ** GOTO lbl35
            {
                ++var9_9;
                do {
                    if (var9_9 < var4_4 && var5_5[var9_9] < var8_8) continue block2;
                    if (var9_9 == var4_4) break block2;
                    var10_10 = var9_9 + 1;
                    while (var10_10 < var4_4 && var5_5[var10_10] >= var8_8) {
                        ++var10_10;
                    }
                    var11_11 = 0;
                    while (var11_11 < (var10_10 - var9_9) / 2) {
                        var12_12 = var5_5[var10_10 - var11_11 - 1];
                        var5_5[var10_10 - var11_11 - 1] = var5_5[var9_9 + var11_11];
                        var5_5[var9_9 + var11_11] = var12_12;
                        var13_13 = var2_2[var3_3 + var10_10 - var11_11 - 1];
                        var2_2[var3_3 + var10_10 - var11_11 - 1] = var2_2[var3_3 + var9_9 + var11_11];
                        var2_2[var3_3 + var9_9 + var11_11] = var13_13;
                        ++var11_11;
                    }
                    var9_9 = var10_10 + 1;
lbl35:
                    // 2 sources

                } while (var9_9 < var4_4);
            }
            --var8_8;
        }
    }

    public static final boolean requiresBidi(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            byte by = Character.getDirectionality(cArray[n3]);
            if (by != 0 && by != 3 && by != 4 && by != 5 && by != 6 && by != 7 && by != 11 && by != 12) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public Bidi(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.RUN_DIRECTION);
        this.flags = object == TextAttribute.RUN_DIRECTION_LTR ? 0 : (object == TextAttribute.RUN_DIRECTION_RTL ? 1 : -2);
        NumericShaper numericShaper = null;
        object = attributedCharacterIterator.getAttribute(TextAttribute.NUMERIC_SHAPING);
        if (object instanceof NumericShaper) {
            numericShaper = (NumericShaper)object;
        }
        char[] cArray = new char[attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()];
        this.embeddings = new byte[this.text.length];
        this.embeddingOffset = 0;
        this.length = cArray.length;
        int n = 0;
        while (n < this.text.length) {
            this.text[n] = attributedCharacterIterator.current();
            object = attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING);
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                byte by = n2 < -62 || n2 > 62 ? (byte)0 : (byte)n2;
                this.embeddings[n] = by;
            }
            ++n;
        }
        if (numericShaper != null) {
            numericShaper.shape(this.text, 0, this.length);
        }
        this.runBidi();
    }

    public Bidi(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        if (n4 != -2 && n4 != -1 && n4 != 0 && n4 != 1) {
            throw new IllegalArgumentException("unrecognized 'flags' argument: " + n4);
        }
        this.text = cArray;
        this.textOffset = n;
        this.embeddings = byArray;
        this.embeddingOffset = n2;
        this.length = n3;
        this.flags = n4;
        this.runBidi();
    }

    public Bidi(String string, int n) {
        if (n != -2 && n != -1 && n != 0 && n != 1) {
            throw new IllegalArgumentException("unrecognized 'flags' argument: " + n);
        }
        this.text = string.toCharArray();
        this.textOffset = 0;
        this.embeddings = null;
        this.embeddingOffset = 0;
        this.length = string.length();
        this.flags = n;
        this.runBidi();
    }
}

