/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.Key;
import javax.crypto.interfaces.DHKey;
import javax.crypto.spec.DHParameterSpec;

public abstract class GnuDHKey
implements Key,
DHKey {
    protected BigInteger q;
    protected BigInteger p;
    protected BigInteger g;
    protected final int defaultFormat;

    public DHParameterSpec getParams() {
        if (this.q == null) {
            return new DHParameterSpec(this.p, this.g);
        }
        return new DHParameterSpec(this.p, this.g, this.q.bitLength());
    }

    public String getAlgorithm() {
        return "dh";
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.defaultFormat);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public BigInteger getQ() {
        return this.q;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DHKey)) {
            return false;
        }
        DHKey dHKey = (DHKey)object;
        boolean bl = false;
        if (this.p.equals(dHKey.getParams().getP()) && this.g.equals(dHKey.getParams().getG())) {
            bl = true;
        }
        return bl;
    }

    public abstract byte[] getEncoded(int var1);

    protected GnuDHKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n2 = 1;
        if (n > 0) {
            n2 = n;
        }
        this.defaultFormat = n2;
        this.q = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
    }
}

