/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.cipher;

import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.jce.spec.BlockCipherParameterSpec;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.PadFactory;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class CipherAdapter
extends CipherSpi {
    protected IBlockCipher cipher;
    protected IMode mode;
    protected IPad pad;
    protected int keyLen;
    protected Map attributes;
    protected byte[] partBlock;
    protected int partLen;
    protected int blockLen;
    static /* synthetic */ Class class$gnu$javax$crypto$jce$spec$BlockCipherParameterSpec;

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string.length() >= 3 && string.substring(0, 3).equalsIgnoreCase("CFB")) {
            if (string.length() > 3) {
                try {
                    int n = Integer.parseInt(string.substring(3));
                    this.attributes.put("gnu.crypto.mode.block.size", new Integer(n / 8));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NoSuchAlgorithmException(string);
                }
                string = "CFB";
            }
        } else {
            this.attributes.remove("gnu.crypto.mode.block.size");
        }
        this.mode = ModeFactory.getInstance(string, this.cipher, this.blockLen);
        if (this.mode == null) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string.equalsIgnoreCase("NoPadding")) {
            this.pad = null;
            return;
        }
        this.pad = PadFactory.getInstance(string);
        if (this.pad == null) {
            throw new NoSuchPaddingException(string);
        }
    }

    protected int engineGetBlockSize() {
        if (this.cipher != null) {
            return this.blockLen;
        }
        return 0;
    }

    protected int engineGetOutputSize(int n) {
        int n2 = this.mode.currentBlockSize();
        return (n + this.partLen) / n2 * n2;
    }

    protected byte[] engineGetIV() {
        byte[] byArray = (byte[])this.attributes.get("gnu.crypto.mode.iv");
        if (byArray == null) {
            return null;
        }
        return (byte[])byArray.clone();
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters;
        BlockCipherParameterSpec blockCipherParameterSpec = new BlockCipherParameterSpec((byte[])this.attributes.get("gnu.crypto.mode.iv"), this.cipher.currentBlockSize(), this.keyLen);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("BlockCipherParameters");
            algorithmParameters.init(blockCipherParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        return algorithmParameters;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        switch (n) {
            case 1: {
                this.attributes.put("gnu.crypto.mode.state", new Integer(1));
                break;
            }
            case 2: {
                this.attributes.put("gnu.crypto.mode.state", new Integer(2));
                break;
            }
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("bad key format " + key.getFormat());
        }
        byte[] byArray = key.getEncoded();
        if (this.keyLen == 0) {
            this.keyLen = byArray.length;
        } else if (this.keyLen < byArray.length) {
            byte[] byArray2 = byArray;
            byArray = new byte[this.keyLen];
            System.arraycopy(byArray2, 0, byArray, 0, this.keyLen);
        }
        this.attributes.put("gnu.crypto.cipher.key.material", byArray);
        this.reset();
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            byte[] byArray = new byte[this.blockLen];
            secureRandom.nextBytes(byArray);
            this.attributes.put("gnu.crypto.mode.iv", byArray);
            this.blockLen = this.cipher.defaultBlockSize();
            this.attributes.put("gnu.crypto.cipher.block.size", new Integer(this.blockLen));
            this.keyLen = 0;
        } else if (algorithmParameterSpec instanceof BlockCipherParameterSpec) {
            this.attributes.put("gnu.crypto.cipher.block.size", new Integer(((BlockCipherParameterSpec)algorithmParameterSpec).getBlockSize()));
            this.attributes.put("gnu.crypto.mode.iv", ((BlockCipherParameterSpec)algorithmParameterSpec).getIV());
            this.keyLen = ((BlockCipherParameterSpec)algorithmParameterSpec).getKeySize();
            this.blockLen = ((BlockCipherParameterSpec)algorithmParameterSpec).getBlockSize();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.attributes.put("gnu.crypto.mode.iv", ((IvParameterSpec)algorithmParameterSpec).getIV());
            this.blockLen = this.cipher.defaultBlockSize();
            this.attributes.put("gnu.crypto.cipher.block.size", new Integer(this.blockLen));
            this.keyLen = 0;
        }
        this.engineInit(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        try {
            if (algorithmParameters != null) {
                Class clazz = class$gnu$javax$crypto$jce$spec$BlockCipherParameterSpec;
                if (clazz == null) {
                    clazz = class$gnu$javax$crypto$jce$spec$BlockCipherParameterSpec = CipherAdapter.class("[Lgnu.javax.crypto.jce.spec.BlockCipherParameterSpec;", false);
                }
                algorithmParameterSpec = algorithmParameters.getParameterSpec(clazz);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {}
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3 = this.mode.currentBlockSize();
        int n4 = (this.partLen + n2) / n3;
        byte[] byArray2 = new byte[n4 * n3];
        try {
            this.engineUpdate(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            shortBufferException.printStackTrace(System.err);
        }
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        byte[] byArray3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.mode.currentBlockSize();
        int n5 = (this.partLen + n2) / n4;
        int n6 = n5 * n4;
        if (n6 > byArray2.length - n3) {
            throw new ShortBufferException();
        }
        if (n5 == 0) {
            System.arraycopy(byArray, n, this.partBlock, this.partLen, n2);
            this.partLen += n2;
            return 0;
        }
        if (this.partLen == 0) {
            byArray3 = byArray;
        } else {
            byArray3 = new byte[this.partLen + n2];
            System.arraycopy(this.partBlock, 0, byArray3, 0, this.partLen);
            if (byArray != null && n2 > 0) {
                System.arraycopy(byArray, n, byArray3, this.partLen, n2);
            }
            n = 0;
        }
        int n7 = 0;
        while (n7 < n5) {
            this.mode.update(byArray3, n, byArray2, n3);
            n += n4;
            n3 += n4;
            ++n7;
        }
        this.partLen += n2 - n6;
        if (this.partLen > 0) {
            System.arraycopy(byArray3, n, this.partBlock, 0, this.partLen);
        }
        return n6;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2;
        byte[] byArray3 = this.engineUpdate(byArray, n, n2);
        if (this.pad != null) {
            switch ((Integer)this.attributes.get("gnu.crypto.mode.state")) {
                case 1: {
                    byte[] byArray4 = this.pad.pad(this.partBlock, 0, this.partLen);
                    byte[] byArray5 = this.engineUpdate(byArray4, 0, byArray4.length);
                    byArray2 = new byte[byArray3.length + byArray5.length];
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                    System.arraycopy(byArray5, 0, byArray2, byArray3.length, byArray5.length);
                    break;
                }
                case 2: {
                    int n3;
                    try {
                        n3 = this.pad.unpad(byArray3, 0, byArray3.length);
                    }
                    catch (WrongPaddingException wrongPaddingException) {
                        throw new BadPaddingException(wrongPaddingException.getMessage());
                    }
                    byArray2 = new byte[byArray3.length - n3];
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            if (this.partLen > 0) {
                throw new IllegalBlockSizeException(this.partLen + " trailing bytes");
            }
            byArray2 = byArray3;
        }
        try {
            this.reset();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Error(invalidKeyException);
        }
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray2.length + n3 < byArray3.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    private final void reset() throws InvalidKeyException {
        this.mode.reset();
        this.mode.init(this.attributes);
        if (this.pad != null) {
            this.pad.reset();
            this.pad.init(this.blockLen);
        }
        this.partBlock = new byte[this.blockLen];
        this.partLen = 0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected CipherAdapter(String string, int n) {
        this.cipher = CipherFactory.getInstance(string);
        this.attributes = new HashMap();
        this.blockLen = n;
        this.mode = ModeFactory.getInstance("ECB", this.cipher, n);
        this.attributes.put("gnu.crypto.cipher.block.size", new Integer(n));
    }

    protected CipherAdapter(String string) {
        this.cipher = CipherFactory.getInstance(string);
        this.blockLen = this.cipher.defaultBlockSize();
        this.attributes = new HashMap();
        this.mode = ModeFactory.getInstance("ECB", this.cipher, this.blockLen);
        this.attributes.put("gnu.crypto.cipher.block.size", new Integer(this.blockLen));
    }
}

