/*
 * Decompiled with CFR 0.152.
 */
package junit.samples.money;

import java.util.Enumeration;
import java.util.Vector;
import junit.samples.money.IMoney;
import junit.samples.money.Money;

class MoneyBag
implements IMoney {
    private Vector fMonies = new Vector(5);

    MoneyBag() {
    }

    static IMoney create(IMoney m1, IMoney m2) {
        MoneyBag result = new MoneyBag();
        m1.appendTo(result);
        m2.appendTo(result);
        return result.simplify();
    }

    public IMoney add(IMoney m) {
        return m.addMoneyBag(this);
    }

    public IMoney addMoney(Money m) {
        return MoneyBag.create(m, this);
    }

    public IMoney addMoneyBag(MoneyBag s) {
        return MoneyBag.create(s, this);
    }

    void appendBag(MoneyBag aBag) {
        Enumeration e = aBag.fMonies.elements();
        while (e.hasMoreElements()) {
            this.appendMoney((Money)e.nextElement());
        }
    }

    void appendMoney(Money aMoney) {
        if (aMoney.isZero()) {
            return;
        }
        Money old = this.findMoney(aMoney.currency());
        if (old == null) {
            this.fMonies.addElement(aMoney);
            return;
        }
        this.fMonies.removeElement(old);
        IMoney sum = old.add(aMoney);
        if (sum.isZero()) {
            return;
        }
        this.fMonies.addElement(sum);
    }

    public boolean equals(Object anObject) {
        if (this.isZero() && anObject instanceof IMoney) {
            return ((IMoney)anObject).isZero();
        }
        if (anObject instanceof MoneyBag) {
            MoneyBag aMoneyBag = (MoneyBag)anObject;
            if (aMoneyBag.fMonies.size() != this.fMonies.size()) {
                return false;
            }
            Enumeration e = this.fMonies.elements();
            while (e.hasMoreElements()) {
                Money m = (Money)e.nextElement();
                if (aMoneyBag.contains(m)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Money findMoney(String currency) {
        Enumeration e = this.fMonies.elements();
        while (e.hasMoreElements()) {
            Money m = (Money)e.nextElement();
            if (!m.currency().equals(currency)) continue;
            return m;
        }
        return null;
    }

    private boolean contains(Money m) {
        Money found = this.findMoney(m.currency());
        if (found == null) {
            return false;
        }
        return found.amount() == m.amount();
    }

    public int hashCode() {
        int hash = 0;
        Enumeration e = this.fMonies.elements();
        while (e.hasMoreElements()) {
            Object m = e.nextElement();
            hash ^= m.hashCode();
        }
        return hash;
    }

    public boolean isZero() {
        return this.fMonies.size() == 0;
    }

    public IMoney multiply(int factor) {
        MoneyBag result = new MoneyBag();
        if (factor != 0) {
            Enumeration e = this.fMonies.elements();
            while (e.hasMoreElements()) {
                Money m = (Money)e.nextElement();
                result.appendMoney((Money)m.multiply(factor));
            }
        }
        return result;
    }

    public IMoney negate() {
        MoneyBag result = new MoneyBag();
        Enumeration e = this.fMonies.elements();
        while (e.hasMoreElements()) {
            Money m = (Money)e.nextElement();
            result.appendMoney((Money)m.negate());
        }
        return result;
    }

    private IMoney simplify() {
        if (this.fMonies.size() == 1) {
            return (IMoney)this.fMonies.elements().nextElement();
        }
        return this;
    }

    public IMoney subtract(IMoney m) {
        return this.add(m.negate());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        Enumeration e = this.fMonies.elements();
        while (e.hasMoreElements()) {
            buffer.append(e.nextElement());
        }
        buffer.append("}");
        return buffer.toString();
    }

    public void appendTo(MoneyBag m) {
        m.appendBag(this);
    }
}

