/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.AbstractBasicFileAttributeView;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixDirectoryStream;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnixSecureDirectoryStream
extends SecureDirectoryStream {
    private final UnixDirectoryStream ds;
    private final int dfd;

    UnixSecureDirectoryStream(UnixPath unixPath, long l, int n, DirectoryStream.Filter<? super Path> filter) {
        this.ds = new UnixDirectoryStream(unixPath, l, filter);
        this.dfd = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.ds.writeLock().lock();
        try {
            if (this.ds.closeImpl()) {
                UnixNativeDispatcher.close(this.dfd);
            }
        }
        finally {
            this.ds.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.ds.iterator(this);
    }

    private UnixPath getName(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureDirectoryStream newDirectoryStream(Path path, boolean bl, DirectoryStream.Filter<? super Path> filter) throws IOException {
        UnixPath unixPath = this.getName(path);
        UnixPath unixPath2 = this.ds.directory().resolve(unixPath);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            unixPath2.checkRead();
        }
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            int n = -1;
            int n2 = -1;
            long l = 0L;
            try {
                int n3 = 0;
                if (!bl) {
                    n3 |= 0x100;
                }
                n = UnixNativeDispatcher.openat(this.dfd, unixPath.asByteArray(), n3, 0);
                n2 = UnixNativeDispatcher.dup(n);
                l = UnixNativeDispatcher.fdopendir(n);
            }
            catch (UnixException unixException) {
                if (n != -1) {
                    UnixNativeDispatcher.close(n);
                }
                if (n2 != -1) {
                    UnixNativeDispatcher.close(n2);
                }
                if (unixException.errno() == 20) {
                    throw new NotDirectoryException(unixPath.toString());
                }
                unixException.rethrowAsIOException(unixPath);
            }
            UnixSecureDirectoryStream unixSecureDirectoryStream = new UnixSecureDirectoryStream(unixPath2, l, n2, filter);
            return unixSecureDirectoryStream;
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = this.getName(path);
        int n = UnixFileModeAttribute.toUnixMode(438, fileAttributeArray);
        String string = this.ds.directory().resolve(unixPath).getPathForPermissionCheck();
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            try {
                FileChannel fileChannel = UnixChannelFactory.newFileChannel(this.dfd, unixPath, string, set, n);
                return fileChannel;
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(unixPath);
                SeekableByteChannel seekableByteChannel = null;
                this.ds.readLock().unlock();
                return seekableByteChannel;
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implDelete(Path path, boolean bl, int n) throws IOException {
        UnixPath unixPath = this.getName(path);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.ds.directory().resolve(unixPath).checkDelete();
        }
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            if (!bl) {
                UnixFileAttributes unixFileAttributes = null;
                try {
                    unixFileAttributes = UnixFileAttributes.get(this.dfd, unixPath, false);
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(unixPath);
                }
                n = unixFileAttributes.isDirectory() ? 512 : 0;
            }
            try {
                UnixNativeDispatcher.unlinkat(this.dfd, unixPath.asByteArray(), n);
            }
            catch (UnixException unixException) {
                if ((n & 0x200) != 0 && (unixException.errno() == 17 || unixException.errno() == 66)) {
                    throw new DirectoryNotEmptyException(null);
                }
                unixException.rethrowAsIOException(unixPath);
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    @Override
    public void deleteFile(Path path) throws IOException {
        this.implDelete(path, true, 0);
    }

    @Override
    public void deleteDirectory(Path path) throws IOException {
        this.implDelete(path, true, 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Path path, SecureDirectoryStream secureDirectoryStream, Path path2) throws IOException {
        UnixPath unixPath = this.getName(path);
        UnixPath unixPath2 = this.getName(path2);
        if (secureDirectoryStream == null) {
            throw new NullPointerException();
        }
        if (!(secureDirectoryStream instanceof UnixSecureDirectoryStream)) {
            throw new ProviderMismatchException();
        }
        UnixSecureDirectoryStream unixSecureDirectoryStream = (UnixSecureDirectoryStream)secureDirectoryStream;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.ds.directory().resolve(unixPath).checkWrite();
            unixSecureDirectoryStream.ds.directory().resolve(unixPath2).checkWrite();
        }
        this.ds.readLock().lock();
        try {
            unixSecureDirectoryStream.ds.readLock().lock();
            try {
                if (!this.ds.isOpen() || !unixSecureDirectoryStream.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                try {
                    UnixNativeDispatcher.renameat(this.dfd, unixPath.asByteArray(), unixSecureDirectoryStream.dfd, unixPath2.asByteArray());
                }
                catch (UnixException unixException) {
                    if (unixException.errno() == 18) {
                        throw new AtomicMoveNotSupportedException(unixPath.toString(), unixPath2.toString(), unixException.errorString());
                    }
                    unixException.rethrowAsIOException(unixPath, unixPath2);
                }
            }
            finally {
                unixSecureDirectoryStream.ds.readLock().unlock();
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    private <V extends FileAttributeView> V getFileAttributeViewImpl(UnixPath unixPath, Class<V> clazz, boolean bl) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        Class<V> clazz2 = clazz;
        if (clazz2 == BasicFileAttributeView.class) {
            return (V)new BasicFileAttributeViewImpl(unixPath, bl);
        }
        if (clazz2 == PosixFileAttributeView.class || clazz2 == FileOwnerAttributeView.class) {
            return (V)new PosixFileAttributeViewImpl(unixPath, bl);
        }
        return (V)((FileAttributeView)null);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> clazz) {
        return this.getFileAttributeViewImpl(null, clazz, false);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        UnixPath unixPath = this.getName(path);
        boolean bl = unixPath.getFileSystem().followLinks(linkOptionArray);
        return this.getFileAttributeViewImpl(unixPath, clazz, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PosixFileAttributeViewImpl
    extends BasicFileAttributeViewImpl
    implements PosixFileAttributeView {
        private static final String PERMISSIONS_NAME = "permissions";
        private static final String OWNER_NAME = "owner";
        private static final String GROUP_NAME = "group";

        PosixFileAttributeViewImpl(UnixPath unixPath, boolean bl) {
            super(unixPath, bl);
        }

        private void checkWriteAndUserAccess() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                ((BasicFileAttributeViewImpl)this).checkWriteAccess();
                securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        @Override
        public String name() {
            return "posix";
        }

        @Override
        public Object getAttribute(String string) throws IOException {
            if (string.equals(PERMISSIONS_NAME)) {
                return this.readAttributes().permissions();
            }
            if (string.equals(OWNER_NAME)) {
                return this.readAttributes().owner();
            }
            if (string.equals(GROUP_NAME)) {
                return this.readAttributes().group();
            }
            return super.getAttribute(string);
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            if (string.equals(PERMISSIONS_NAME)) {
                this.setPermissions((Set)object);
                return;
            }
            if (string.equals(OWNER_NAME)) {
                this.setOwner((UserPrincipal)object);
                return;
            }
            if (string.equals(GROUP_NAME)) {
                this.setGroup((GroupPrincipal)object);
                return;
            }
            super.setAttribute(string, object);
        }

        final void addPosixAttributesToBuilder(PosixFileAttributes posixFileAttributes, AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder) {
            if (attributesBuilder.match(PERMISSIONS_NAME)) {
                attributesBuilder.add(PERMISSIONS_NAME, posixFileAttributes.permissions());
            }
            if (attributesBuilder.match(OWNER_NAME)) {
                attributesBuilder.add(OWNER_NAME, posixFileAttributes.owner());
            }
            if (attributesBuilder.match(GROUP_NAME)) {
                attributesBuilder.add(GROUP_NAME, posixFileAttributes.group());
            }
        }

        @Override
        public Map<String, ?> readAttributes(String string, String[] stringArray) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder = AbstractBasicFileAttributeView.AttributesBuilder.create(string, stringArray);
            PosixFileAttributes posixFileAttributes = this.readAttributes();
            this.addBasicAttributesToBuilder(posixFileAttributes, attributesBuilder);
            this.addPosixAttributesToBuilder(posixFileAttributes, attributesBuilder);
            return attributesBuilder.unmodifiableMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PosixFileAttributes readAttributes() throws IOException {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (this.file == null) {
                    UnixSecureDirectoryStream.this.ds.directory().checkRead();
                } else {
                    UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkRead();
                }
                securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
            }
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                try {
                    UnixFileAttributes unixFileAttributes;
                    UnixFileAttributes unixFileAttributes2 = unixFileAttributes = this.file == null ? UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd) : UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd, this.file, this.followLinks);
                    return unixFileAttributes2;
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                    PosixFileAttributes posixFileAttributes = null;
                    UnixSecureDirectoryStream.this.ds.readLock().unlock();
                    return posixFileAttributes;
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPermissions(Set<PosixFilePermission> set) throws IOException {
            this.checkWriteAndUserAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int n = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    UnixNativeDispatcher.fchmod(n, UnixFileModeAttribute.toUnixMode(set));
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                }
                finally {
                    if (this.file != null && n >= 0) {
                        UnixNativeDispatcher.close(n);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setOwners(int n, int n2) throws IOException {
            this.checkWriteAndUserAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int n3 = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    UnixNativeDispatcher.fchown(n3, n, n2);
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                }
                finally {
                    if (this.file != null && n3 >= 0) {
                        UnixNativeDispatcher.close(n3);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return this.readAttributes().owner();
        }

        @Override
        public void setOwner(UserPrincipal userPrincipal) throws IOException {
            if (!(userPrincipal instanceof UnixUserPrincipals.User)) {
                throw new ProviderMismatchException();
            }
            if (userPrincipal instanceof UnixUserPrincipals.Group) {
                throw new IOException("'owner' parameter can't be a group");
            }
            int n = ((UnixUserPrincipals.User)userPrincipal).uid();
            this.setOwners(n, -1);
        }

        @Override
        public void setGroup(GroupPrincipal groupPrincipal) throws IOException {
            if (!(groupPrincipal instanceof UnixUserPrincipals.Group)) {
                throw new ProviderMismatchException();
            }
            int n = ((UnixUserPrincipals.Group)groupPrincipal).gid();
            this.setOwners(-1, n);
        }
    }

    private class BasicFileAttributeViewImpl
    extends AbstractBasicFileAttributeView {
        final UnixPath file;
        final boolean followLinks;
        volatile boolean forwarding;

        BasicFileAttributeViewImpl(UnixPath unixPath, boolean bl) {
            this.file = unixPath;
            this.followLinks = bl;
        }

        int open() throws IOException {
            int n = 0;
            if (!this.followLinks) {
                n |= 0x100;
            }
            try {
                return UnixNativeDispatcher.openat(UnixSecureDirectoryStream.this.dfd, this.file.asByteArray(), n, 0);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
                return -1;
            }
        }

        private void checkWriteAccess() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkWrite();
            }
        }

        public String name() {
            return "basic";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BasicFileAttributes readAttributes() throws IOException {
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    if (this.file == null) {
                        UnixSecureDirectoryStream.this.ds.directory().checkRead();
                    } else {
                        UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkRead();
                    }
                }
                try {
                    UnixFileAttributes unixFileAttributes = this.file == null ? UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd) : UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd, this.file, this.followLinks);
                    BasicFileAttributes basicFileAttributes = unixFileAttributes.asBasicFileAttributes();
                    return basicFileAttributes;
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                    BasicFileAttributes basicFileAttributes = null;
                    UnixSecureDirectoryStream.this.ds.readLock().unlock();
                    return basicFileAttributes;
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTimes(Long l, Long l2, Long l3, TimeUnit timeUnit) throws IOException {
            if (l == null && l2 == null) {
                return;
            }
            this.checkWriteAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int n = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    long l4;
                    long l5;
                    UnixFileAttributes unixFileAttributes = null;
                    if (l == null || l2 == null) {
                        try {
                            unixFileAttributes = UnixFileAttributes.get(n);
                        }
                        catch (UnixException unixException) {
                            unixException.rethrowAsIOException(this.file);
                        }
                    }
                    if (l == null) {
                        l5 = unixFileAttributes.lastModifiedTime();
                    } else if (l >= 0L) {
                        l5 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
                    } else {
                        if (l != -1L) {
                            throw new IllegalArgumentException();
                        }
                        l5 = System.currentTimeMillis();
                    }
                    if (l2 == null) {
                        l4 = unixFileAttributes.lastAccessTime();
                    } else if (l2 >= 0L) {
                        l4 = TimeUnit.MILLISECONDS.convert(l2, timeUnit);
                    } else {
                        if (l2 != -1L) {
                            throw new IllegalArgumentException();
                        }
                        l4 = System.currentTimeMillis();
                    }
                    try {
                        UnixNativeDispatcher.futimes(n, l4, l5);
                    }
                    catch (UnixException unixException) {
                        unixException.rethrowAsIOException(this.file);
                    }
                }
                finally {
                    if (this.file != null) {
                        UnixNativeDispatcher.close(n);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }
    }
}

