/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnixFileModeAttribute {
    static final int ALL_PERMISSIONS = 511;
    static final int ALL_READWRITE = 438;
    static final int TEMPFILE_PERMISSIONS = 448;
    private Set<PosixFilePermission> perms = Collections.emptySet();

    UnixFileModeAttribute() {
    }

    static int toUnixMode(Set<PosixFilePermission> set) {
        int n = 0;
        for (PosixFilePermission posixFilePermission : set) {
            if (posixFilePermission == null) {
                throw new NullPointerException();
            }
            switch (posixFilePermission) {
                case OWNER_READ: {
                    n |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    n |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    n |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    n |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    n |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    n |= 8;
                    break;
                }
                case OTHERS_READ: {
                    n |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    n |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    n |= 1;
                }
            }
        }
        return n;
    }

    static int toUnixMode(int n, FileAttribute<?> ... fileAttributeArray) {
        int n2 = n;
        for (FileAttribute<?> fileAttribute : fileAttributeArray) {
            String string = fileAttribute.name();
            if (!string.equals("posix:permissions") && !string.equals("unix:permissions")) {
                throw new UnsupportedOperationException("'" + fileAttribute.name() + "' not supported as initial attribute");
            }
            n2 = UnixFileModeAttribute.toUnixMode((Set)fileAttribute.value());
        }
        return n2;
    }
}

