/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixSecureDirectoryStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnixDirectoryStream
implements DirectoryStream<Path> {
    private final UnixPath dir;
    private final long dp;
    private final DirectoryStream.Filter<? super Path> filter;
    private final ReentrantReadWriteLock streamLock = new ReentrantReadWriteLock(true);
    private volatile boolean isClosed;
    private Iterator<Path> iterator;

    UnixDirectoryStream(UnixPath unixPath, long l, DirectoryStream.Filter<? super Path> filter) {
        this.dir = unixPath;
        this.dp = l;
        this.filter = filter;
    }

    protected final UnixPath directory() {
        return this.dir;
    }

    protected final Lock readLock() {
        return this.streamLock.readLock();
    }

    protected final Lock writeLock() {
        return this.streamLock.writeLock();
    }

    protected final boolean isOpen() {
        return !this.isClosed;
    }

    protected final boolean closeImpl() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                UnixNativeDispatcher.closedir(this.dp);
            }
            catch (UnixException unixException) {
                throw new IOException(unixException.errorString());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.writeLock().lock();
        try {
            this.closeImpl();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Iterator<Path> iterator(DirectoryStream<Path> directoryStream) {
        if (this.isClosed) {
            throw new IllegalStateException("Directory stream is closed");
        }
        UnixDirectoryStream unixDirectoryStream = this;
        synchronized (unixDirectoryStream) {
            if (this.iterator != null) {
                throw new IllegalStateException("Iterator already obtained");
            }
            this.iterator = new UnixDirectoryIterator(directoryStream);
            return this.iterator;
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.iterator(this);
    }

    private static void throwAsConcurrentModificationException(Throwable throwable) {
        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
        concurrentModificationException.initCause(throwable);
        throw concurrentModificationException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnixDirectoryIterator
    implements Iterator<Path> {
        private final DirectoryStream<Path> stream;
        private boolean atEof = false;
        private Path nextEntry;
        private Path prevEntry;

        UnixDirectoryIterator(DirectoryStream<Path> directoryStream) {
            this.stream = directoryStream;
        }

        private boolean isSelfOrParent(byte[] byArray) {
            return byArray[0] == 46 && (byArray.length == 1 || byArray.length == 2 && byArray[1] == 46);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Path readNextEntry() {
            UnixPath unixPath;
            assert (Thread.holdsLock(this));
            while (true) {
                byte[] byArray = null;
                UnixDirectoryStream.this.readLock().lock();
                try {
                    if (UnixDirectoryStream.this.isClosed) {
                        UnixDirectoryStream.throwAsConcurrentModificationException(new ClosedDirectoryStreamException());
                    }
                    try {
                        byArray = UnixNativeDispatcher.readdir(UnixDirectoryStream.this.dp);
                    }
                    catch (UnixException unixException) {
                        try {
                            unixException.rethrowAsIOException(UnixDirectoryStream.this.dir);
                        }
                        catch (IOException iOException) {
                            UnixDirectoryStream.throwAsConcurrentModificationException(iOException);
                        }
                    }
                }
                finally {
                    UnixDirectoryStream.this.readLock().unlock();
                }
                if (byArray == null) {
                    return null;
                }
                if (this.isSelfOrParent(byArray)) continue;
                unixPath = UnixDirectoryStream.this.dir.resolve(byArray);
                if (UnixDirectoryStream.this.filter.accept(unixPath)) break;
            }
            return unixPath;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.nextEntry == null && !this.atEof) {
                this.nextEntry = this.readNextEntry();
                if (this.nextEntry == null) {
                    this.atEof = true;
                }
            }
            return this.nextEntry != null;
        }

        @Override
        public synchronized Path next() {
            if (this.nextEntry == null) {
                if (!this.atEof) {
                    this.nextEntry = this.readNextEntry();
                }
                if (this.nextEntry == null) {
                    this.atEof = true;
                    throw new NoSuchElementException();
                }
            }
            this.prevEntry = this.nextEntry;
            this.nextEntry = null;
            return this.prevEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Path path;
            if (UnixDirectoryStream.this.isClosed) {
                throw new ClosedDirectoryStreamException();
            }
            UnixDirectoryIterator unixDirectoryIterator = this;
            synchronized (unixDirectoryIterator) {
                if (this.prevEntry == null) {
                    throw new IllegalStateException("No previous entry to remove");
                }
                path = this.prevEntry;
                this.prevEntry = null;
            }
            try {
                if (this.stream instanceof UnixSecureDirectoryStream) {
                    ((UnixSecureDirectoryStream)this.stream).implDelete(path.getName(), false, 0);
                } else {
                    path.delete(true);
                }
            }
            catch (IOException iOException) {
                UnixDirectoryStream.throwAsConcurrentModificationException(iOException);
            }
            catch (SecurityException securityException) {
                UnixDirectoryStream.throwAsConcurrentModificationException(securityException);
            }
        }
    }
}

