/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffers;

class NativeBuffer {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private final long address;
    private final int size;
    private final Cleaner cleaner;
    private Object owner;

    NativeBuffer(int n) {
        this.address = unsafe.allocateMemory(n);
        this.size = n;
        this.cleaner = Cleaner.create(this, new Deallocator(this.address));
    }

    void release() {
        NativeBuffers.releaseNativeBuffer(this);
    }

    long address() {
        return this.address;
    }

    int size() {
        return this.size;
    }

    Cleaner cleaner() {
        return this.cleaner;
    }

    void setOwner(Object object) {
        this.owner = object;
    }

    Object owner() {
        return this.owner;
    }

    private static class Deallocator
    implements Runnable {
        private final long address;

        Deallocator(long l) {
            this.address = l;
        }

        public void run() {
            unsafe.freeMemory(this.address);
        }
    }
}

