/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AcceptPendingException;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NotYetBoundException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.nio.ch.AbstractFuture;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousServerSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.Port;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.UnixAsynchronousSocketChannelImpl;
import sun.nio.ch.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnixAsynchronousServerSocketChannelImpl
extends AsynchronousServerSocketChannelImpl
implements Port.PollableChannel {
    private static final NativeDispatcher nd = new SocketDispatcher();
    private final Port port;
    private final int fdVal;
    private final AtomicBoolean accepting = new AtomicBoolean();
    private final Object updateLock = new Object();
    private PendingFuture<AsynchronousSocketChannel, Object> pendingAccept;
    private AccessControlContext acc;

    private void enableAccept() {
        this.accepting.set(false);
    }

    UnixAsynchronousServerSocketChannelImpl(Port port) throws IOException {
        super(port);
        try {
            IOUtil.configureBlocking(this.fd, false);
        }
        catch (IOException iOException) {
            nd.close(this.fd);
            throw iOException;
        }
        this.port = port;
        this.fdVal = IOUtil.fdVal(this.fd);
        port.register(this.fdVal, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingFuture<AsynchronousSocketChannel, Object> grabPendingAccept() {
        Object object = this.updateLock;
        synchronized (object) {
            PendingFuture<AsynchronousSocketChannel, Object> pendingFuture = this.pendingAccept;
            this.pendingAccept = null;
            return pendingFuture;
        }
    }

    @Override
    void implClose() throws IOException {
        this.port.unregister(this.fdVal);
        nd.close(this.fd);
        PendingFuture<AsynchronousSocketChannel, Object> pendingFuture = this.grabPendingAccept();
        if (pendingFuture != null) {
            AsynchronousCloseException asynchronousCloseException = new AsynchronousCloseException();
            asynchronousCloseException.setStackTrace(new StackTraceElement[0]);
            pendingFuture.setFailure(asynchronousCloseException);
            Invoker.invokeIndirectly(pendingFuture.handler(), pendingFuture);
        }
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(int n) {
        PendingFuture<AsynchronousSocketChannel, Object> pendingFuture = this.grabPendingAccept();
        if (pendingFuture == null) {
            return;
        }
        FileDescriptor fileDescriptor = new FileDescriptor();
        InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[1];
        boolean bl = false;
        try {
            this.begin();
            int n2 = this.accept0(this.fd, fileDescriptor, inetSocketAddressArray);
            if (n2 == -2) {
                Object object = this.updateLock;
                synchronized (object) {
                    this.pendingAccept = pendingFuture;
                }
                this.port.startPoll(this.fdVal, 1);
                return;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            AsynchronousCloseException asynchronousCloseException;
            if (throwable instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            this.enableAccept();
            pendingFuture.setFailure(asynchronousCloseException);
        }
        finally {
            this.end();
        }
        AsynchronousChannel asynchronousChannel = null;
        if (bl) {
            try {
                asynchronousChannel = this.finishAccept(fileDescriptor, inetSocketAddressArray[0], this.acc);
                this.enableAccept();
                pendingFuture.setResult((AsynchronousSocketChannel)asynchronousChannel);
            }
            catch (Throwable throwable) {
                IOException iOException;
                this.enableAccept();
                if (!(throwable instanceof IOException) && !(throwable instanceof SecurityException)) {
                    iOException = new IOException(throwable);
                }
                pendingFuture.setFailure(iOException);
            }
        }
        if (asynchronousChannel != null && pendingFuture.isCancelled()) {
            try {
                asynchronousChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Invoker.invoke(pendingFuture.handler(), pendingFuture);
    }

    private AsynchronousSocketChannel finishAccept(FileDescriptor fileDescriptor, final InetSocketAddress inetSocketAddress, AccessControlContext accessControlContext) throws IOException, SecurityException {
        UnixAsynchronousSocketChannelImpl unixAsynchronousSocketChannelImpl = null;
        try {
            unixAsynchronousSocketChannelImpl = new UnixAsynchronousSocketChannelImpl(this.port, fileDescriptor, inetSocketAddress);
        }
        catch (IOException iOException) {
            nd.close(fileDescriptor);
            throw iOException;
        }
        try {
            if (accessControlContext != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        SecurityManager securityManager = System.getSecurityManager();
                        if (securityManager != null) {
                            securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                        }
                        return null;
                    }
                }, accessControlContext);
            } else {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
            }
        }
        catch (SecurityException securityException) {
            try {
                unixAsynchronousSocketChannelImpl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw securityException;
        }
        return unixAsynchronousSocketChannelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> Future<AsynchronousSocketChannel> accept(A a, CompletionHandler<AsynchronousSocketChannel, ? super A> completionHandler) {
        InetSocketAddress[] inetSocketAddressArray;
        FileDescriptor fileDescriptor;
        AbstractFuture abstractFuture;
        block16: {
            if (!this.isOpen()) {
                CompletedFuture completedFuture = CompletedFuture.withFailure(this, new ClosedChannelException(), a);
                Invoker.invokeIndirectly(completionHandler, completedFuture);
                return completedFuture;
            }
            if (this.localAddress == null) {
                throw new NotYetBoundException();
            }
            if (this.isAcceptKilled()) {
                throw new RuntimeException("Accept not allowed due cancellation");
            }
            if (!this.accepting.compareAndSet(false, true)) {
                throw new AcceptPendingException();
            }
            abstractFuture = null;
            fileDescriptor = new FileDescriptor();
            inetSocketAddressArray = new InetSocketAddress[1];
            try {
                this.begin();
                int n = this.accept0(this.fd, fileDescriptor, inetSocketAddressArray);
                if (n != -2) break block16;
                abstractFuture = new PendingFuture<AsynchronousSocketChannel, A>(this, completionHandler, a);
                Object object = this;
                synchronized (object) {
                    this.acc = System.getSecurityManager() == null ? null : AccessController.getContext();
                    this.pendingAccept = (PendingFuture)abstractFuture;
                }
                this.port.startPoll(this.fdVal, 1);
                object = abstractFuture;
                return object;
            }
            catch (Throwable throwable) {
                AsynchronousCloseException asynchronousCloseException;
                if (throwable instanceof ClosedChannelException) {
                    asynchronousCloseException = new AsynchronousCloseException();
                }
                abstractFuture = CompletedFuture.withFailure(this, asynchronousCloseException, a);
            }
            finally {
                this.end();
            }
        }
        if (abstractFuture == null) {
            try {
                AsynchronousSocketChannel asynchronousSocketChannel = this.finishAccept(fileDescriptor, inetSocketAddressArray[0], null);
                abstractFuture = CompletedFuture.withResult(this, asynchronousSocketChannel, a);
            }
            catch (Throwable throwable) {
                abstractFuture = CompletedFuture.withFailure(this, throwable, a);
            }
        }
        this.enableAccept();
        Invoker.invokeIndirectly(completionHandler, abstractFuture);
        return abstractFuture;
    }

    private static native void initIDs();

    private native int accept0(FileDescriptor var1, FileDescriptor var2, InetSocketAddress[] var3) throws IOException;

    static {
        Util.load();
        UnixAsynchronousServerSocketChannelImpl.initIDs();
    }
}

