/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sun.nio.ch.AbstractFuture;
import sun.nio.ch.AsynchronousFileChannelImpl;
import sun.nio.ch.Cancellable;
import sun.nio.ch.Groupable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PendingFuture<V, A>
extends AbstractFuture<V, A> {
    private static final CancellationException CANCELLED = new CancellationException();
    private final CompletionHandler<V, ? super A> handler;
    private volatile boolean haveResult;
    private volatile V result;
    private volatile Throwable exc;
    private CountDownLatch latch;
    private Future<?> timeoutTask;
    private volatile Object context;

    PendingFuture(AsynchronousChannel asynchronousChannel, CompletionHandler<V, ? super A> completionHandler, A a, Object object) {
        super(asynchronousChannel, a);
        this.handler = completionHandler;
        this.context = object;
    }

    PendingFuture(AsynchronousChannel asynchronousChannel, CompletionHandler<V, ? super A> completionHandler, A a) {
        super(asynchronousChannel, a);
        this.handler = completionHandler;
    }

    CompletionHandler<V, ? super A> handler() {
        return this.handler;
    }

    void setContext(Object object) {
        this.context = object;
    }

    Object getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeoutTask(Future<?> future) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                future.cancel(false);
            } else {
                this.timeoutTask = future;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareForWait() {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return false;
            }
            if (this.latch == null) {
                this.latch = new CountDownLatch(1);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setResult(V v) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return false;
            }
            this.result = v;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setFailure(Throwable throwable) {
        if (!(throwable instanceof IOException) && !(throwable instanceof SecurityException)) {
            throwable = new IOException(throwable);
        }
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return false;
            }
            this.exc = throwable;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
            return true;
        }
    }

    @Override
    public V get() throws ExecutionException, InterruptedException {
        boolean bl;
        if (!this.haveResult && (bl = this.prepareForWait())) {
            this.latch.await();
        }
        if (this.exc != null) {
            if (this.exc == CANCELLED) {
                throw new CancellationException();
            }
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        boolean bl;
        if (!this.haveResult && (bl = this.prepareForWait()) && !this.latch.await(l, timeUnit)) {
            throw new TimeoutException();
        }
        if (this.exc != null) {
            if (this.exc == CANCELLED) {
                throw new CancellationException();
            }
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    @Override
    Throwable exception() {
        return this.exc != CANCELLED ? this.exc : null;
    }

    @Override
    V value() {
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.exc == CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.haveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return false;
            }
            if (this.handler != null) {
                this.prepareForWait();
                Runnable runnable = new Runnable(){

                    public void run() {
                        while (!PendingFuture.this.haveResult) {
                            try {
                                PendingFuture.this.latch.await();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        PendingFuture.this.handler.cancelled(PendingFuture.this.attachment());
                    }
                };
                AsynchronousChannel asynchronousChannel = this.channel();
                if (asynchronousChannel instanceof Groupable) {
                    ((Groupable)((Object)asynchronousChannel)).group().executeOnPooledThread(runnable);
                } else if (asynchronousChannel instanceof AsynchronousFileChannelImpl) {
                    ((AsynchronousFileChannelImpl)asynchronousChannel).executor().execute(runnable);
                } else {
                    throw new AssertionError((Object)"Should not get here");
                }
            }
            if (this.channel() instanceof Cancellable) {
                ((Cancellable)((Object)this.channel())).onCancel(this);
            }
            this.exc = CANCELLED;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
        }
        if (bl) {
            try {
                this.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
        return true;
    }
}

