/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

public final class NetHooks {
    private static final Provider provider = AccessController.doPrivileged(new GetPropertyAction("os.name")).equals("SunOS") ? NetHooks.loadProvider("sun.net.spi.SdpProvider") : null;

    private static Provider loadProvider(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Provider>(){

            @Override
            public Provider run() {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string, true, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AssertionError((Object)classNotFoundException);
                }
                try {
                    return (Provider)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new AssertionError((Object)instantiationException);
                }
            }
        });
    }

    public static void beforeTcpBind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        if (provider != null) {
            provider.implBeforeTcpBind(fileDescriptor, inetAddress, n);
        }
    }

    public static void beforeTcpConnect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        if (provider != null) {
            provider.implBeforeTcpConnect(fileDescriptor, inetAddress, n);
        }
    }

    public static abstract class Provider {
        protected Provider() {
        }

        public abstract void implBeforeTcpBind(FileDescriptor var1, InetAddress var2, int var3) throws IOException;

        public abstract void implBeforeTcpConnect(FileDescriptor var1, InetAddress var2, int var3) throws IOException;
    }
}

