/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import sun.awt.shell.ShellFolderColumnInfo;
import sun.awt.shell.ShellFolderManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShellFolder
extends File {
    private static final String COLUMN_NAME = "FileChooser.fileNameHeaderText";
    private static final String COLUMN_SIZE = "FileChooser.fileSizeHeaderText";
    private static final String COLUMN_DATE = "FileChooser.fileDateHeaderText";
    protected ShellFolder parent;
    private static ShellFolderManager shellFolderManager;
    private static Invoker invoker;
    private static final Comparator DEFAULT_COMPARATOR;
    private static final Comparator<File> FILE_COMPARATOR;

    ShellFolder(ShellFolder shellFolder, String string) {
        super(string != null ? string : "ShellFolder");
        this.parent = shellFolder;
    }

    public boolean isFileSystem() {
        return !this.getPath().startsWith("ShellFolder");
    }

    protected abstract Object writeReplace() throws ObjectStreamException;

    @Override
    public String getParent() {
        if (this.parent == null && this.isFileSystem()) {
            return super.getParent();
        }
        if (this.parent != null) {
            return this.parent.getPath();
        }
        return null;
    }

    @Override
    public File getParentFile() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isFileSystem()) {
            return super.getParentFile();
        }
        return null;
    }

    @Override
    public File[] listFiles() {
        return this.listFiles(true);
    }

    public File[] listFiles(boolean bl) {
        File[] fileArray = super.listFiles();
        if (!bl) {
            Vector<File> vector = new Vector<File>();
            int n = fileArray == null ? 0 : fileArray.length;
            for (int i = 0; i < n; ++i) {
                if (fileArray[i].isHidden()) continue;
                vector.addElement(fileArray[i]);
            }
            fileArray = vector.toArray(new File[vector.size()]);
        }
        return fileArray;
    }

    public abstract boolean isLink();

    public abstract ShellFolder getLinkLocation() throws FileNotFoundException;

    public abstract String getDisplayName();

    public abstract String getFolderType();

    public abstract String getExecutableType();

    @Override
    public int compareTo(File file) {
        if (file == null || !(file instanceof ShellFolder) || file instanceof ShellFolder && ((ShellFolder)file).isFileSystem()) {
            if (this.isFileSystem()) {
                return super.compareTo(file);
            }
            return -1;
        }
        if (this.isFileSystem()) {
            return 1;
        }
        return this.getName().compareTo(file.getName());
    }

    public Image getIcon(boolean bl) {
        return null;
    }

    public static ShellFolder getShellFolder(File file) throws FileNotFoundException {
        if (file instanceof ShellFolder) {
            return (ShellFolder)file;
        }
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        return shellFolderManager.createShellFolder(file);
    }

    public static Object get(String string) {
        return shellFolderManager.get(string);
    }

    public static boolean isComputerNode(File file) {
        return shellFolderManager.isComputerNode(file);
    }

    public static boolean isFileSystemRoot(File file) {
        return shellFolderManager.isFileSystemRoot(file);
    }

    public static File getNormalizedFile(File file) throws IOException {
        File file2 = file.getCanonicalFile();
        if (file.equals(file2)) {
            return file2;
        }
        return new File(file.toURI().normalize());
    }

    public static void sort(List<? extends File> list) {
        if (list == null || list.size() <= 1) {
            return;
        }
        File file = null;
        for (File file2 : list) {
            File file3 = file2.getParentFile();
            if (file3 == null || !(file2 instanceof ShellFolder)) {
                file = null;
                break;
            }
            if (file == null) {
                file = file3;
                continue;
            }
            if (file == file3 || file.equals(file3)) continue;
            file = null;
            break;
        }
        if (file instanceof ShellFolder) {
            ((ShellFolder)file).sortChildren(list);
        } else {
            Collections.sort(list, FILE_COMPARATOR);
        }
    }

    public void sortChildren(List<? extends File> list) {
        Collections.sort(list, FILE_COMPARATOR);
    }

    @Override
    public boolean isAbsolute() {
        return !this.isFileSystem() || super.isAbsolute();
    }

    @Override
    public File getAbsoluteFile() {
        return this.isFileSystem() ? super.getAbsoluteFile() : this;
    }

    @Override
    public boolean canRead() {
        return this.isFileSystem() ? super.canRead() : true;
    }

    @Override
    public boolean canWrite() {
        return this.isFileSystem() ? super.canWrite() : false;
    }

    @Override
    public boolean exists() {
        return !this.isFileSystem() || ShellFolder.isFileSystemRoot(this) || super.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.isFileSystem() ? super.isDirectory() : true;
    }

    @Override
    public boolean isFile() {
        return this.isFileSystem() ? super.isFile() : !this.isDirectory();
    }

    @Override
    public long lastModified() {
        return this.isFileSystem() ? super.lastModified() : 0L;
    }

    @Override
    public long length() {
        return this.isFileSystem() ? super.length() : 0L;
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this.isFileSystem() ? super.createNewFile() : false;
    }

    @Override
    public boolean delete() {
        return this.isFileSystem() ? super.delete() : false;
    }

    @Override
    public void deleteOnExit() {
        if (this.isFileSystem()) {
            super.deleteOnExit();
        }
    }

    @Override
    public boolean mkdir() {
        return this.isFileSystem() ? super.mkdir() : false;
    }

    @Override
    public boolean mkdirs() {
        return this.isFileSystem() ? super.mkdirs() : false;
    }

    @Override
    public boolean renameTo(File file) {
        return this.isFileSystem() ? super.renameTo(file) : false;
    }

    @Override
    public boolean setLastModified(long l) {
        return this.isFileSystem() ? super.setLastModified(l) : false;
    }

    @Override
    public boolean setReadOnly() {
        return this.isFileSystem() ? super.setReadOnly() : false;
    }

    @Override
    public String toString() {
        return this.isFileSystem() ? super.toString() : this.getDisplayName();
    }

    public static ShellFolderColumnInfo[] getFolderColumns(File file) {
        ShellFolderColumnInfo[] shellFolderColumnInfoArray = null;
        if (file instanceof ShellFolder) {
            shellFolderColumnInfoArray = ((ShellFolder)file).getFolderColumns();
        }
        if (shellFolderColumnInfoArray == null) {
            shellFolderColumnInfoArray = new ShellFolderColumnInfo[]{new ShellFolderColumnInfo(COLUMN_NAME, 150, 10, true, null, FILE_COMPARATOR), new ShellFolderColumnInfo(COLUMN_SIZE, 75, 4, true, null, DEFAULT_COMPARATOR, true), new ShellFolderColumnInfo(COLUMN_DATE, 130, 10, true, null, DEFAULT_COMPARATOR, true)};
        }
        return shellFolderColumnInfoArray;
    }

    public ShellFolderColumnInfo[] getFolderColumns() {
        return null;
    }

    public static Object getFolderColumnValue(File file, int n) {
        Object object;
        if (file instanceof ShellFolder && (object = ((ShellFolder)file).getFolderColumnValue(n)) != null) {
            return object;
        }
        if (file == null || !file.exists()) {
            return null;
        }
        switch (n) {
            case 0: {
                return file;
            }
            case 1: {
                return file.isDirectory() ? null : Long.valueOf(file.length());
            }
            case 2: {
                if (ShellFolder.isFileSystemRoot(file)) {
                    return null;
                }
                long l = file.lastModified();
                return l == 0L ? null : new Date(l);
            }
        }
        return null;
    }

    public Object getFolderColumnValue(int n) {
        return null;
    }

    public static Invoker getInvoker() {
        if (invoker == null) {
            invoker = shellFolderManager.createInvoker();
        }
        return invoker;
    }

    static {
        Class<ShellFolderManager> clazz = (Class<ShellFolderManager>)Toolkit.getDefaultToolkit().getDesktopProperty("Shell.shellFolderManager");
        if (clazz == null) {
            clazz = ShellFolderManager.class;
        }
        try {
            shellFolderManager = (ShellFolderManager)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new Error("Could not instantiate Shell Folder Manager: " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Could not access Shell Folder Manager: " + clazz.getName());
        }
        DEFAULT_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                int n = object == null && object2 == null ? 0 : (object != null && object2 == null ? 1 : (object == null && object2 != null ? -1 : (object instanceof Comparable ? ((Comparable)object).compareTo(object2) : 0)));
                return n;
            }
        };
        FILE_COMPARATOR = new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                String string;
                ShellFolder shellFolder = null;
                ShellFolder shellFolder2 = null;
                if (file instanceof ShellFolder && (shellFolder = (ShellFolder)file).isFileSystem()) {
                    shellFolder = null;
                }
                if (file2 instanceof ShellFolder && (shellFolder2 = (ShellFolder)file2).isFileSystem()) {
                    shellFolder2 = null;
                }
                if (shellFolder != null && shellFolder2 != null) {
                    return shellFolder.compareTo(shellFolder2);
                }
                if (shellFolder != null) {
                    return -1;
                }
                if (shellFolder2 != null) {
                    return 1;
                }
                String string2 = file.getName();
                int n = string2.compareToIgnoreCase(string = file2.getName());
                if (n != 0) {
                    return n;
                }
                return string2.compareTo(string);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Invoker {
        public <T> T invoke(Callable<T> var1);
    }
}

