/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.peer.CanvasPeer;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;

class XCanvasPeer
extends XComponentPeer
implements CanvasPeer {
    private boolean eraseBackgroundDisabled;

    XCanvasPeer() {
    }

    XCanvasPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    XCanvasPeer(Component component) {
        super(component);
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        if (SunToolkit.getSunAwtNoerasebackground()) {
            this.disableBackgroundErase();
        }
    }

    public GraphicsConfiguration getAppropriateGraphicsConfiguration(GraphicsConfiguration graphicsConfiguration) {
        if (this.graphicsConfig == null || graphicsConfiguration == null) {
            return graphicsConfiguration;
        }
        int n = ((X11GraphicsDevice)graphicsConfiguration.getDevice()).getScreen();
        int n2 = this.graphicsConfig.getVisual();
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[n];
        for (int i = 0; i < x11GraphicsDevice.getNumConfigs(n); ++i) {
            if (n2 != x11GraphicsDevice.getConfigVisualId(i, n)) continue;
            this.graphicsConfig = (X11GraphicsConfig)x11GraphicsDevice.getConfigurations()[i];
            break;
        }
        if (this.graphicsConfig == null) {
            this.graphicsConfig = (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[n].getDefaultConfiguration();
        }
        return this.graphicsConfig;
    }

    protected boolean shouldFocusOnClick() {
        return true;
    }

    public void disableBackgroundErase() {
        this.eraseBackgroundDisabled = true;
    }

    protected boolean doEraseBackground() {
        return !this.eraseBackgroundDisabled;
    }

    public void setBackground(Color color) {
        boolean bl = false;
        if (this.getPeerBackground() == null || !this.getPeerBackground().equals(color)) {
            bl = true;
        }
        super.setBackground(color);
        if (bl) {
            this.target.repaint();
        }
    }
}

