/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Vector;

public class LayoutQueue {
    Vector<Runnable> tasks = new Vector();
    Thread worker;
    static LayoutQueue defaultQueue;

    public static LayoutQueue getDefaultQueue() {
        if (defaultQueue == null) {
            defaultQueue = new LayoutQueue();
        }
        return defaultQueue;
    }

    public static void setDefaultQueue(LayoutQueue layoutQueue) {
        defaultQueue = layoutQueue;
    }

    public synchronized void addTask(Runnable runnable) {
        if (this.worker == null) {
            this.worker = new LayoutThread();
            this.worker.start();
        }
        this.tasks.addElement(runnable);
        this.notifyAll();
    }

    protected synchronized Runnable waitForWork() {
        while (this.tasks.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        Runnable runnable = this.tasks.firstElement();
        this.tasks.removeElementAt(0);
        return runnable;
    }

    class LayoutThread
    extends Thread {
        LayoutThread() {
            super("text-layout");
            this.setPriority(1);
        }

        public void run() {
            Runnable runnable;
            do {
                if ((runnable = LayoutQueue.this.waitForWork()) == null) continue;
                runnable.run();
            } while (runnable != null);
        }
    }
}

