/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.image.VolatileImage;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.Painter;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.nimbus.ImageCache;
import javax.swing.plaf.nimbus.ImageScalingHelper;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegionPainter
implements Painter<JComponent> {
    private PaintContext ctx;
    private float f;
    private float leftWidth;
    private float topHeight;
    private float centerWidth;
    private float centerHeight;
    private float rightWidth;
    private float bottomHeight;
    private float leftScale;
    private float topScale;
    private float centerHScale;
    private float centerVScale;
    private float rightScale;
    private float bottomScale;

    protected AbstractRegionPainter() {
    }

    @Override
    public final void paint(Graphics2D graphics2D, JComponent jComponent, int n, int n2) {
        PaintContext.CacheMode cacheMode;
        if (n <= 0 || n2 <= 0) {
            return;
        }
        Object[] objectArray = this.getExtendedCacheKeys(jComponent);
        this.ctx = this.getPaintContext();
        PaintContext.CacheMode cacheMode2 = cacheMode = this.ctx == null ? PaintContext.CacheMode.NO_CACHING : this.ctx.cacheMode;
        if (cacheMode == PaintContext.CacheMode.NO_CACHING || !ImageCache.getInstance().isImageCachable(n, n2) || graphics2D instanceof PrinterGraphics) {
            this.paint0(graphics2D, jComponent, n, n2, objectArray);
        } else if (cacheMode == PaintContext.CacheMode.FIXED_SIZES) {
            this.paintWithFixedSizeCaching(graphics2D, jComponent, n, n2, objectArray);
        } else {
            this.paintWith9SquareCaching(graphics2D, this.ctx, jComponent, n, n2, objectArray);
        }
    }

    protected Object[] getExtendedCacheKeys(JComponent jComponent) {
        return null;
    }

    protected abstract PaintContext getPaintContext();

    protected void configureGraphics(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected abstract void doPaint(Graphics2D var1, JComponent var2, int var3, int var4, Object[] var5);

    protected final float decodeX(float f) {
        if (this.ctx.canvasSize == null) {
            return f;
        }
        if (f >= 0.0f && f <= 1.0f) {
            return f * this.leftWidth;
        }
        if (f > 1.0f && f < 2.0f) {
            return (f - 1.0f) * this.centerWidth + this.leftWidth;
        }
        if (f >= 2.0f && f <= 3.0f) {
            return (f - 2.0f) * this.rightWidth + this.leftWidth + this.centerWidth;
        }
        throw new AssertionError((Object)"Invalid x");
    }

    protected final float decodeY(float f) {
        if (this.ctx.canvasSize == null) {
            return f;
        }
        if (f >= 0.0f && f <= 1.0f) {
            return f * this.topHeight;
        }
        if (f > 1.0f && f < 2.0f) {
            return (f - 1.0f) * this.centerHeight + this.topHeight;
        }
        if (f >= 2.0f && f <= 3.0f) {
            return (f - 2.0f) * this.bottomHeight + this.topHeight + this.centerHeight;
        }
        throw new AssertionError((Object)"Invalid y");
    }

    protected final float decodeAnchorX(float f, float f2) {
        if (this.ctx.canvasSize == null) {
            return f + f2;
        }
        if (f >= 0.0f && f <= 1.0f) {
            return this.decodeX(f) + f2 * this.leftScale;
        }
        if (f > 1.0f && f < 2.0f) {
            return this.decodeX(f) + f2 * this.centerHScale;
        }
        if (f >= 2.0f && f <= 3.0f) {
            return this.decodeX(f) + f2 * this.rightScale;
        }
        throw new AssertionError((Object)"Invalid x");
    }

    protected final float decodeAnchorY(float f, float f2) {
        if (this.ctx.canvasSize == null) {
            return f + f2;
        }
        if (f >= 0.0f && f <= 1.0f) {
            return this.decodeY(f) + f2 * this.topScale;
        }
        if (f > 1.0f && f < 2.0f) {
            return this.decodeY(f) + f2 * this.centerVScale;
        }
        if (f >= 2.0f && f <= 3.0f) {
            return this.decodeY(f) + f2 * this.bottomScale;
        }
        throw new AssertionError((Object)"Invalid y");
    }

    protected final Color decodeColor(String string, float f, float f2, float f3, int n) {
        if (UIManager.getLookAndFeel() instanceof NimbusLookAndFeel) {
            NimbusLookAndFeel nimbusLookAndFeel = (NimbusLookAndFeel)UIManager.getLookAndFeel();
            return nimbusLookAndFeel.getDerivedColor(string, f, f2, f3, n, true);
        }
        return Color.getHSBColor(f, f2, f3);
    }

    protected final Color decodeColor(Color color, Color color2, float f) {
        return new Color(NimbusLookAndFeel.deriveARGB(color, color2, f));
    }

    protected final LinearGradientPaint decodeGradient(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        if (f == f3 && f2 == f4) {
            f4 += 1.0E-5f;
        }
        return new LinearGradientPaint(f, f2, f3, f4, fArray, colorArray);
    }

    protected final RadialGradientPaint decodeRadialGradient(float f, float f2, float f3, float[] fArray, Color[] colorArray) {
        if (f3 == 0.0f) {
            f3 = 1.0E-5f;
        }
        return new RadialGradientPaint(f, f2, f3, fArray, colorArray);
    }

    protected final Color getComponentColor(JComponent jComponent, String string, Color color, float f, float f2, int n) {
        Object object;
        Color color2 = null;
        if (jComponent != null) {
            if ("background".equals(string)) {
                color2 = jComponent.getBackground();
            } else if ("foreground".equals(string)) {
                color2 = jComponent.getForeground();
            } else if (jComponent instanceof JList && "selectionForeground".equals(string)) {
                color2 = ((JList)jComponent).getSelectionForeground();
            } else if (jComponent instanceof JList && "selectionBackground".equals(string)) {
                color2 = ((JList)jComponent).getSelectionBackground();
            } else if (jComponent instanceof JTable && "selectionForeground".equals(string)) {
                color2 = ((JTable)jComponent).getSelectionForeground();
            } else if (jComponent instanceof JTable && "selectionBackground".equals(string)) {
                color2 = ((JTable)jComponent).getSelectionBackground();
            } else {
                Object object2;
                object = "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
                try {
                    object2 = jComponent.getClass().getMethod((String)object, new Class[0]);
                    color2 = (Color)((Method)object2).invoke(jComponent, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (color2 == null && (object2 = jComponent.getClientProperty(string)) instanceof Color) {
                    color2 = (Color)object2;
                }
            }
        }
        if (color2 == null || color2 instanceof UIResource) {
            return color;
        }
        if (f != 0.0f || f2 != 0.0f || n != 0) {
            object = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
            object[1] = this.clamp(object[1] + f);
            object[2] = this.clamp(object[2] + f2);
            int n2 = this.clamp(color2.getAlpha() + n);
            return new Color(Color.HSBtoRGB(object[0], object[1], object[2]) & 0xFFFFFF | n2 << 24);
        }
        return color2;
    }

    private void prepare(float f, float f2) {
        if (this.ctx == null || this.ctx.canvasSize == null) {
            this.f = 1.0f;
            this.rightWidth = 0.0f;
            this.centerWidth = 0.0f;
            this.leftWidth = 0.0f;
            this.bottomHeight = 0.0f;
            this.centerHeight = 0.0f;
            this.topHeight = 0.0f;
            this.rightScale = 0.0f;
            this.centerHScale = 0.0f;
            this.leftScale = 0.0f;
            this.bottomScale = 0.0f;
            this.centerVScale = 0.0f;
            this.topScale = 0.0f;
            return;
        }
        Number number = (Number)UIManager.get("scale");
        float f3 = this.f = number == null ? 1.0f : number.floatValue();
        if (this.ctx.inverted) {
            this.centerWidth = (this.ctx.b - this.ctx.a) * this.f;
            float f4 = f - this.centerWidth;
            this.leftWidth = f4 * this.ctx.aPercent;
            this.rightWidth = f4 * this.ctx.bPercent;
            this.centerHeight = (this.ctx.d - this.ctx.c) * this.f;
            f4 = f2 - this.centerHeight;
            this.topHeight = f4 * this.ctx.cPercent;
            this.bottomHeight = f4 * this.ctx.dPercent;
        } else {
            this.leftWidth = this.ctx.a * this.f;
            this.rightWidth = (float)(this.ctx.canvasSize.getWidth() - (double)this.ctx.b) * this.f;
            this.centerWidth = f - this.leftWidth - this.rightWidth;
            this.topHeight = this.ctx.c * this.f;
            this.bottomHeight = (float)(this.ctx.canvasSize.getHeight() - (double)this.ctx.d) * this.f;
            this.centerHeight = f2 - this.topHeight - this.bottomHeight;
        }
        this.leftScale = this.ctx.a == 0.0f ? 0.0f : this.leftWidth / this.ctx.a;
        this.centerHScale = this.ctx.b - this.ctx.a == 0.0f ? 0.0f : this.centerWidth / (this.ctx.b - this.ctx.a);
        this.rightScale = (float)((PaintContext)this.ctx).canvasSize.width - this.ctx.b == 0.0f ? 0.0f : this.rightWidth / ((float)((PaintContext)this.ctx).canvasSize.width - this.ctx.b);
        this.topScale = this.ctx.c == 0.0f ? 0.0f : this.topHeight / this.ctx.c;
        this.centerVScale = this.ctx.d - this.ctx.c == 0.0f ? 0.0f : this.centerHeight / (this.ctx.d - this.ctx.c);
        this.bottomScale = (float)((PaintContext)this.ctx).canvasSize.height - this.ctx.d == 0.0f ? 0.0f : this.bottomHeight / ((float)((PaintContext)this.ctx).canvasSize.height - this.ctx.d);
    }

    private void paintWith9SquareCaching(Graphics2D graphics2D, PaintContext paintContext, JComponent jComponent, int n, int n2, Object[] objectArray) {
        Dimension dimension = paintContext.canvasSize;
        Insets insets = paintContext.stretchingInsets;
        if ((double)n <= (double)dimension.width * paintContext.maxHorizontalScaleFactor && (double)n2 <= (double)dimension.height * paintContext.maxVerticalScaleFactor) {
            VolatileImage volatileImage = this.getImage(graphics2D.getDeviceConfiguration(), jComponent, dimension.width, dimension.height, objectArray);
            if (volatileImage != null) {
                Insets insets2;
                if (paintContext.inverted) {
                    int n3 = (n - (dimension.width - (insets.left + insets.right))) / 2;
                    int n4 = (n2 - (dimension.height - (insets.top + insets.bottom))) / 2;
                    insets2 = new Insets(n4, n3, n4, n3);
                } else {
                    insets2 = insets;
                }
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ImageScalingHelper.paint(graphics2D, 0, 0, n, n2, volatileImage, insets, insets2, ImageScalingHelper.PaintType.PAINT9_STRETCH, 512);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object != null ? object : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else {
                this.paint0(graphics2D, jComponent, n, n2, objectArray);
            }
        } else {
            this.paint0(graphics2D, jComponent, n, n2, objectArray);
        }
    }

    private void paintWithFixedSizeCaching(Graphics2D graphics2D, JComponent jComponent, int n, int n2, Object[] objectArray) {
        VolatileImage volatileImage = this.getImage(graphics2D.getDeviceConfiguration(), jComponent, n, n2, objectArray);
        if (volatileImage != null) {
            graphics2D.drawImage(volatileImage, 0, 0, null);
        } else {
            this.paint0(graphics2D, jComponent, n, n2, objectArray);
        }
    }

    private VolatileImage getImage(GraphicsConfiguration graphicsConfiguration, JComponent jComponent, int n, int n2, Object[] objectArray) {
        ImageCache imageCache = ImageCache.getInstance();
        VolatileImage volatileImage = (VolatileImage)imageCache.getImage(graphicsConfiguration, n, n2, this, objectArray);
        int n3 = 0;
        do {
            int n4 = 2;
            if (volatileImage != null) {
                n4 = volatileImage.validate(graphicsConfiguration);
            }
            if (n4 != 2 && n4 != 1) continue;
            if (volatileImage == null || volatileImage.getWidth() != n || volatileImage.getHeight() != n2 || n4 == 2) {
                if (volatileImage != null) {
                    volatileImage.flush();
                    volatileImage = null;
                }
                volatileImage = graphicsConfiguration.createCompatibleVolatileImage(n, n2, 3);
                imageCache.setImage(volatileImage, graphicsConfiguration, n, n2, this, objectArray);
            }
            Graphics2D graphics2D = volatileImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            this.configureGraphics(graphics2D);
            this.paint0(graphics2D, jComponent, n, n2, objectArray);
            graphics2D.dispose();
        } while (volatileImage.contentsLost() && n3++ < 3);
        if (n3 == 3) {
            return null;
        }
        return volatileImage;
    }

    private void paint0(Graphics2D graphics2D, JComponent jComponent, int n, int n2, Object[] objectArray) {
        this.prepare(n, n2);
        graphics2D = (Graphics2D)graphics2D.create();
        this.configureGraphics(graphics2D);
        this.doPaint(graphics2D, jComponent, n, n2, objectArray);
        graphics2D.dispose();
    }

    private float clamp(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private int clamp(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    protected static class PaintContext {
        private static Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
        private Insets stretchingInsets;
        private Dimension canvasSize;
        private boolean inverted;
        private CacheMode cacheMode;
        private double maxHorizontalScaleFactor;
        private double maxVerticalScaleFactor;
        private float a;
        private float b;
        private float c;
        private float d;
        private float aPercent;
        private float bPercent;
        private float cPercent;
        private float dPercent;

        public PaintContext(Insets insets, Dimension dimension, boolean bl) {
            this(insets, dimension, bl, null, 1.0, 1.0);
        }

        public PaintContext(Insets insets, Dimension dimension, boolean bl, CacheMode cacheMode, double d, double d2) {
            if (d < 1.0 || d < 1.0) {
                throw new IllegalArgumentException("Both maxH and maxV must be >= 1");
            }
            this.stretchingInsets = insets == null ? EMPTY_INSETS : insets;
            this.canvasSize = dimension;
            this.inverted = bl;
            this.cacheMode = cacheMode == null ? CacheMode.NO_CACHING : cacheMode;
            this.maxHorizontalScaleFactor = d;
            this.maxVerticalScaleFactor = d2;
            if (dimension != null) {
                this.a = insets.left;
                this.b = dimension.width - insets.right;
                this.c = insets.top;
                this.d = dimension.height - insets.bottom;
                this.canvasSize = dimension;
                this.inverted = bl;
                if (bl) {
                    float f = (float)dimension.width - (this.b - this.a);
                    this.aPercent = f > 0.0f ? this.a / f : 0.0f;
                    this.bPercent = f > 0.0f ? this.b / f : 0.0f;
                    f = (float)dimension.height - (this.d - this.c);
                    this.cPercent = f > 0.0f ? this.c / f : 0.0f;
                    this.dPercent = f > 0.0f ? this.d / f : 0.0f;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum CacheMode {
            NO_CACHING,
            FIXED_SIZES,
            NINE_SQUARE_SCALE;

        }
    }
}

