/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.beans.ConstructorProperties;
import java.io.DeleteOnExitHook;
import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOError;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
implements Serializable,
Comparable<File> {
    private static FileSystem fs = FileSystem.getFileSystem();
    private String path;
    private transient int prefixLength;
    public static final char separatorChar = fs.getSeparator();
    public static final String separator = "" + separatorChar;
    public static final char pathSeparatorChar = fs.getPathSeparator();
    public static final String pathSeparator = "" + pathSeparatorChar;
    private static final long serialVersionUID = 301077366599181567L;
    private volatile transient Path filePath;

    int getPrefixLength() {
        return this.prefixLength;
    }

    private File(String string, int n) {
        this.path = string;
        this.prefixLength = n;
    }

    private File(String string, File file) {
        assert (file.path != null);
        assert (!file.path.equals(""));
        this.path = fs.resolve(file.path, string);
        this.prefixLength = file.prefixLength;
    }

    @ConstructorProperties(value={"path"})
    public File(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.path = string != null ? (string.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string2)) : fs.resolve(fs.normalize(string), fs.normalize(string2))) : fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(File file, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = file != null ? (file.path.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string)) : fs.resolve(file.path, fs.normalize(string))) : fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String string2 = uRI.getPath();
        if (string2.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        string2 = fs.fromURIPath(string2);
        if (separatorChar != '/') {
            string2 = string2.replace('/', separatorChar);
        }
        this.path = fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public String getName() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n < this.prefixLength) {
            return this.path.substring(this.prefixLength);
        }
        return this.path.substring(n + 1);
    }

    public String getParent() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n < this.prefixLength) {
            if (this.prefixLength > 0 && this.path.length() > this.prefixLength) {
                return this.path.substring(0, this.prefixLength);
            }
            return null;
        }
        return this.path.substring(0, n);
    }

    public File getParentFile() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new File(string, this.prefixLength);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return fs.isAbsolute(this);
    }

    public String getAbsolutePath() {
        return fs.resolve(this);
    }

    public File getAbsoluteFile() {
        String string = this.getAbsolutePath();
        return new File(string, fs.prefixLength(string));
    }

    public String getCanonicalPath() throws IOException {
        return fs.canonicalize(fs.resolve(this));
    }

    public File getCanonicalFile() throws IOException {
        String string = this.getCanonicalPath();
        return new File(string, fs.prefixLength(string));
    }

    private static String slashify(String string, boolean bl) {
        String string2 = string;
        if (separatorChar != '/') {
            string2 = string2.replace(separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl) {
            string2 = string2 + "/";
        }
        return string2;
    }

    @Deprecated
    public URL toURL() throws MalformedURLException {
        return new URL("file", "", File.slashify(this.getAbsolutePath(), this.isDirectory()));
    }

    public URI toURI() {
        try {
            File file = this.getAbsoluteFile();
            String string = File.slashify(file.getPath(), file.isDirectory());
            if (string.startsWith("//")) {
                string = "//" + string;
            }
            return new URI("file", null, string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Error(uRISyntaxException);
        }
    }

    public boolean canRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.checkAccess(this, 4);
    }

    public boolean canWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.checkAccess(this, 2);
    }

    public boolean exists() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 1) != 0;
    }

    public boolean isDirectory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 4) != 0;
    }

    public boolean isFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 2) != 0;
    }

    public boolean isHidden() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 8) != 0;
    }

    public long lastModified() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.getLastModifiedTime(this);
    }

    public long length() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.getLength(this);
    }

    public boolean createNewFile() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.createFileExclusively(this.path);
    }

    public boolean delete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        return fs.delete(this);
    }

    public void deleteOnExit() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        DeleteOnExitHook.add(this.path);
    }

    public String[] list() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.list(this);
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null || filenameFilter == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!filenameFilter.accept(this, stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public File[] listFiles() {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(stringArray[i], this);
        }
        return fileArray;
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            if (filenameFilter != null && !filenameFilter.accept(this, string)) continue;
            arrayList.add(new File(string, this));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public File[] listFiles(FileFilter fileFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            File file = new File(string, this);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public boolean mkdir() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.createDirectory(this);
    }

    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        File file = null;
        try {
            file = this.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        File file2 = file.getParentFile();
        return file2 != null && (file2.mkdirs() || file2.exists()) && file.mkdir();
    }

    public boolean renameTo(File file) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
            securityManager.checkWrite(file.path);
        }
        return fs.rename(this, file);
    }

    public boolean setLastModified(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setLastModifiedTime(this, l);
    }

    public boolean setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setReadOnly(this);
    }

    public boolean setWritable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setPermission(this, 2, bl, bl2);
    }

    public boolean setWritable(boolean bl) {
        return this.setWritable(bl, true);
    }

    public boolean setReadable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setPermission(this, 4, bl, bl2);
    }

    public boolean setReadable(boolean bl) {
        return this.setReadable(bl, true);
    }

    public boolean setExecutable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setPermission(this, 1, bl, bl2);
    }

    public boolean setExecutable(boolean bl) {
        return this.setExecutable(bl, true);
    }

    public boolean canExecute() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(this.path);
        }
        return fs.checkAccess(this, 1);
    }

    public static File[] listRoots() {
        return fs.listRoots();
    }

    public long getTotalSpace() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        return fs.getSpace(this, 0);
    }

    public long getFreeSpace() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        return fs.getSpace(this, 1);
    }

    public long getUsableSpace() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        return fs.getSpace(this, 2);
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2;
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        File file3 = file != null ? file : TemporaryDirectory.valueAsFile;
        SecurityManager securityManager = System.getSecurityManager();
        do {
            file2 = TemporaryDirectory.generateFile(string, string2, file3);
            if (securityManager == null) continue;
            try {
                securityManager.checkWrite(file2.getPath());
            }
            catch (SecurityException securityException) {
                if (file == null) {
                    throw new SecurityException("Unable to create temporary file");
                }
                throw securityException;
            }
        } while (!fs.createFileExclusively(file2.getPath()));
        return file2;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return File.createTempFile(string, string2, null);
    }

    public static File createTempFile(String string, String string2, boolean bl, FileAttribute<?> ... fileAttributeArray) throws IOException {
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        String string3 = string2 = string2 == null ? ".tmp" : string2;
        if (TemporaryDirectory.isPosix) {
            if (fileAttributeArray.length == 0) {
                fileAttributeArray = new FileAttribute[]{TemporaryDirectory.defaultPosixFilePermissions};
            } else {
                boolean bl2 = false;
                for (int i = 0; i < fileAttributeArray.length; ++i) {
                    if (!fileAttributeArray[i].name().equals("posix:permissions")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[fileAttributeArray.length + 1];
                    System.arraycopy(fileAttributeArray, 0, fileAttributeArray2, 0, fileAttributeArray.length);
                    fileAttributeArray = fileAttributeArray2;
                    fileAttributeArray[fileAttributeArray.length - 1] = TemporaryDirectory.defaultPosixFilePermissions;
                }
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        while (true) {
            File file = TemporaryDirectory.generateFile(string, string2, TemporaryDirectory.valueAsFile);
            if (securityManager != null && bl) {
                securityManager.checkDelete(file.getPath());
            }
            try {
                file.toPath().createFile(fileAttributeArray);
                if (bl) {
                    DeleteOnExitHook.add(file.getPath());
                }
                return file;
            }
            catch (InvalidPathException invalidPathException) {
                if (securityManager != null) {
                    throw new IllegalArgumentException("Invalid prefix or suffix");
                }
                throw invalidPathException;
            }
            catch (SecurityException securityException) {
                if (securityManager != null) {
                    throw new SecurityException("Unable to create temporary file");
                }
                throw securityException;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    @Override
    public int compareTo(File file) {
        return fs.compare(this, file);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof File) {
            return this.compareTo((File)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return fs.hashCode(this);
    }

    public String toString() {
        return this.getPath();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeChar(separatorChar);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        char c = objectInputStream.readChar();
        if (c != separatorChar) {
            this.path = this.path.replace(c, separatorChar);
        }
        this.path = fs.normalize(this.path);
        this.prefixLength = fs.prefixLength(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path toPath() {
        if (this.filePath == null) {
            File file = this;
            synchronized (file) {
                if (this.filePath == null) {
                    this.filePath = this.path.length() == 0 ? Paths.get(".") : Paths.get(this.path);
                }
            }
        }
        return this.filePath;
    }

    static /* synthetic */ FileSystem access$000() {
        return fs;
    }

    private static class TemporaryDirectory {
        static final String valueAsString = File.access$000().normalize(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
        static final File valueAsFile = new File(valueAsString, File.access$000().prefixLength(valueAsString));
        private static final SecureRandom random = new SecureRandom();
        static final FileAttribute<Set<PosixFilePermission>> defaultPosixFilePermissions = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
        static final boolean isPosix = TemporaryDirectory.isPosix();

        private TemporaryDirectory() {
        }

        static File generateFile(String string, String string2, File file) {
            long l = random.nextLong();
            l = l == Long.MIN_VALUE ? 0L : Math.abs(l);
            return new File(file, string + Long.toString(l) + string2);
        }

        static boolean isPosix() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        return FileSystems.getDefault().getPath(valueAsString).getFileStore().supportsFileAttributeView("posix");
                    }
                    catch (IOException iOException) {
                        throw new IOError(iOException);
                    }
                }
            });
        }
    }
}

