/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Engine;
import com.sun.xml.internal.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.internal.ws.api.pipe.Tube;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Fiber
implements Runnable {
    private Tube[] conts = new Tube[16];
    private int contsSize;
    private Tube next;
    private Packet packet;
    private Throwable throwable;
    public final Engine owner;
    private volatile int suspendedCount = 0;
    private volatile boolean completed;
    private boolean synchronous;
    private boolean interrupted;
    private final int id;
    private List<FiberContextSwitchInterceptor> interceptors;
    private InterceptorHandler interceptorHandler;
    private boolean needsToReenter;
    @Nullable
    private ClassLoader contextClassLoader;
    @Nullable
    private CompletionCallback completionCallback;
    private boolean started;
    private static final ThreadLocal<Fiber> CURRENT_FIBER = new ThreadLocal();
    private static final AtomicInteger iotaGen = new AtomicInteger();
    private static final Logger LOGGER = Logger.getLogger(Fiber.class.getName());
    private static final ReentrantLock serializedExecutionLock = new ReentrantLock();
    public static volatile boolean serializeExecution = Boolean.getBoolean(Fiber.class.getName() + ".serialize");

    Fiber(Engine engine) {
        this.owner = engine;
        if (Fiber.isTraceEnabled()) {
            this.id = iotaGen.incrementAndGet();
            LOGGER.fine(this.getName() + " created");
        } else {
            this.id = -1;
        }
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void start(@NotNull Tube tube, @NotNull Packet packet, @Nullable CompletionCallback completionCallback) {
        this.next = tube;
        this.packet = packet;
        this.completionCallback = completionCallback;
        this.started = true;
        this.owner.addRunnable(this);
    }

    public synchronized void resume(@NotNull Packet packet) {
        if (Fiber.isTraceEnabled()) {
            LOGGER.fine(this.getName() + " resumed");
        }
        this.packet = packet;
        if (--this.suspendedCount == 0) {
            if (this.synchronous) {
                this.notifyAll();
            } else {
                this.owner.addRunnable(this);
            }
        }
    }

    private synchronized void suspend() {
        if (Fiber.isTraceEnabled()) {
            LOGGER.fine(this.getName() + " suspended");
        }
        ++this.suspendedCount;
    }

    public void addInterceptor(@NotNull FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<FiberContextSwitchInterceptor>();
            this.interceptorHandler = new InterceptorHandler();
        }
        this.interceptors.add(fiberContextSwitchInterceptor);
        this.needsToReenter = true;
    }

    public boolean removeInterceptor(@NotNull FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        if (this.interceptors != null && this.interceptors.remove(fiberContextSwitchInterceptor)) {
            this.needsToReenter = true;
            return true;
        }
        return false;
    }

    @Nullable
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public ClassLoader setContextClassLoader(@Nullable ClassLoader classLoader) {
        ClassLoader classLoader2 = this.contextClassLoader;
        this.contextClassLoader = classLoader;
        return classLoader2;
    }

    @Deprecated
    public void run() {
        assert (!this.synchronous);
        this.next = this.doRun(this.next);
        this.completionCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized Packet runSync(@NotNull Tube tube, @NotNull Packet packet) {
        Tube[] tubeArray = this.conts;
        int n = this.contsSize;
        boolean bl = this.synchronous;
        if (n > 0) {
            this.conts = new Tube[16];
            this.contsSize = 0;
        }
        try {
            this.synchronous = true;
            this.packet = packet;
            this.doRun(tube);
            if (this.throwable != null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                if (this.throwable instanceof Error) {
                    throw (Error)this.throwable;
                }
                throw new AssertionError((Object)this.throwable);
            }
            Packet packet2 = this.packet;
            return packet2;
        }
        finally {
            this.conts = tubeArray;
            this.contsSize = n;
            this.synchronous = bl;
            if (this.interrupted) {
                Thread.currentThread().interrupt();
                this.interrupted = false;
            }
            if (!this.started) {
                this.completionCheck();
            }
        }
    }

    private synchronized void completionCheck() {
        if (this.contsSize == 0) {
            if (Fiber.isTraceEnabled()) {
                LOGGER.fine(this.getName() + " completed");
            }
            this.completed = true;
            this.notifyAll();
            if (this.completionCallback != null) {
                if (this.throwable != null) {
                    this.completionCallback.onCompletion(this.throwable);
                } else {
                    this.completionCallback.onCompletion(this.packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tube doRun(Tube tube) {
        Thread thread = Thread.currentThread();
        if (Fiber.isTraceEnabled()) {
            LOGGER.fine(this.getName() + " running by " + thread.getName());
        }
        if (serializeExecution) {
            serializedExecutionLock.lock();
            try {
                Tube tube2 = this._doRun(tube);
                return tube2;
            }
            finally {
                serializedExecutionLock.unlock();
            }
        }
        return this._doRun(tube);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tube _doRun(Tube tube) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.contextClassLoader);
        try {
            do {
                this.needsToReenter = false;
                tube = this.interceptorHandler == null ? this.__doRun(tube) : this.interceptorHandler.invoke(tube);
            } while (this.needsToReenter);
            Tube tube2 = tube;
            return tube2;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    /*
     * Exception decompiling
     */
    private Tube __doRun(Tube var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void pushCont(Tube tube) {
        this.conts[this.contsSize++] = tube;
        int n = this.conts.length;
        if (this.contsSize == n) {
            Tube[] tubeArray = new Tube[n * 2];
            System.arraycopy(this.conts, 0, tubeArray, 0, n);
            this.conts = tubeArray;
        }
    }

    private Tube popCont() {
        return this.conts[--this.contsSize];
    }

    private boolean isBlocking() {
        if (this.synchronous) {
            while (this.suspendedCount == 1) {
                try {
                    if (Fiber.isTraceEnabled()) {
                        LOGGER.fine(this.getName() + " is blocking thread " + Thread.currentThread().getName());
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.interrupted = true;
                }
            }
            return false;
        }
        return this.suspendedCount == 1;
    }

    private String getName() {
        return "engine-" + this.owner.id + "fiber-" + this.id;
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public Packet getPacket() {
        return this.packet;
    }

    public boolean isAlive() {
        return !this.completed;
    }

    public static boolean isSynchronous() {
        return Fiber.current().synchronous;
    }

    @NotNull
    public static Fiber current() {
        Fiber fiber = CURRENT_FIBER.get();
        if (fiber == null) {
            throw new IllegalStateException("Can be only used from fibers");
        }
        return fiber;
    }

    private static boolean isTraceEnabled() {
        return LOGGER.isLoggable(Level.FINE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InterceptorHandler
    implements FiberContextSwitchInterceptor.Work<Tube, Tube> {
        private int idx;

        private InterceptorHandler() {
        }

        Tube invoke(Tube tube) {
            this.idx = 0;
            return this.execute(tube);
        }

        @Override
        public Tube execute(Tube tube) {
            if (this.idx == Fiber.this.interceptors.size()) {
                return Fiber.this.__doRun(tube);
            }
            FiberContextSwitchInterceptor fiberContextSwitchInterceptor = (FiberContextSwitchInterceptor)Fiber.this.interceptors.get(this.idx++);
            return fiberContextSwitchInterceptor.execute(Fiber.this, tube, this);
        }
    }

    public static interface CompletionCallback {
        public void onCompletion(@NotNull Packet var1);

        public void onCompletion(@NotNull Throwable var1);
    }
}

