/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.property;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.model.core.PropertyKind;
import com.sun.xml.internal.bind.v2.model.core.TypeRef;
import com.sun.xml.internal.bind.v2.model.runtime.RuntimeElementPropertyInfo;
import com.sun.xml.internal.bind.v2.model.runtime.RuntimeTypeInfo;
import com.sun.xml.internal.bind.v2.model.runtime.RuntimeTypeRef;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.internal.bind.v2.runtime.Name;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.property.PropertyImpl;
import com.sun.xml.internal.bind.v2.runtime.property.TagAndType;
import com.sun.xml.internal.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.ChildLoader;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.DefaultValueLoaderDecorator;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.XsiNilLoader;
import com.sun.xml.internal.bind.v2.util.QNameMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleElementNodeProperty<BeanT, ValueT>
extends PropertyImpl<BeanT> {
    private final Accessor<BeanT, ValueT> acc;
    private final boolean nillable;
    private final QName[] acceptedElements;
    private final Map<Class, TagAndType> typeNames = new HashMap<Class, TagAndType>();
    private RuntimeElementPropertyInfo prop;
    private final Name nullTagName;

    public SingleElementNodeProperty(JAXBContextImpl jAXBContextImpl, RuntimeElementPropertyInfo runtimeElementPropertyInfo) {
        super(jAXBContextImpl, runtimeElementPropertyInfo);
        this.acc = runtimeElementPropertyInfo.getAccessor().optimize(jAXBContextImpl);
        this.prop = runtimeElementPropertyInfo;
        QName qName = null;
        boolean bl = false;
        this.acceptedElements = new QName[runtimeElementPropertyInfo.getTypes().size()];
        for (int i = 0; i < this.acceptedElements.length; ++i) {
            this.acceptedElements[i] = runtimeElementPropertyInfo.getTypes().get(i).getTagName();
        }
        for (RuntimeTypeRef runtimeTypeRef : runtimeElementPropertyInfo.getTypes()) {
            JaxBeanInfo jaxBeanInfo = jAXBContextImpl.getOrCreate(runtimeTypeRef.getTarget());
            if (qName == null) {
                qName = runtimeTypeRef.getTagName();
            }
            this.typeNames.put(jaxBeanInfo.jaxbType, new TagAndType(jAXBContextImpl.nameBuilder.createElementName(runtimeTypeRef.getTagName()), jaxBeanInfo));
            bl |= runtimeTypeRef.isNillable();
        }
        this.nullTagName = jAXBContextImpl.nameBuilder.createElementName(qName);
        this.nillable = bl;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.prop = null;
    }

    @Override
    public void reset(BeanT BeanT) throws AccessorException {
        this.acc.set(BeanT, null);
    }

    @Override
    public String getIdValue(BeanT BeanT) {
        return null;
    }

    @Override
    public void serializeBody(BeanT BeanT, XMLSerializer xMLSerializer, Object object) throws SAXException, AccessorException, IOException, XMLStreamException {
        ValueT ValueT = this.acc.get(BeanT);
        if (ValueT != null) {
            Class<?> clazz = ValueT.getClass();
            TagAndType tagAndType = this.typeNames.get(clazz);
            if (tagAndType == null) {
                for (Map.Entry<Class, TagAndType> entry : this.typeNames.entrySet()) {
                    if (!entry.getKey().isAssignableFrom(clazz)) continue;
                    tagAndType = entry.getValue();
                    break;
                }
            }
            if (tagAndType == null) {
                xMLSerializer.startElement(this.typeNames.values().iterator().next().tagName, null);
                xMLSerializer.childAsXsiType(ValueT, this.fieldName, xMLSerializer.grammar.getBeanInfo(Object.class));
            } else {
                xMLSerializer.startElement(tagAndType.tagName, null);
                xMLSerializer.childAsXsiType(ValueT, this.fieldName, tagAndType.beanInfo);
            }
            xMLSerializer.endElement();
        } else if (this.nillable) {
            xMLSerializer.startElement(this.nullTagName, null);
            xMLSerializer.writeXsiNilTrue();
            xMLSerializer.endElement();
        }
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain unmarshallerChain, QNameMap<ChildLoader> qNameMap) {
        JAXBContextImpl jAXBContextImpl = unmarshallerChain.context;
        for (TypeRef typeRef : this.prop.getTypes()) {
            JaxBeanInfo jaxBeanInfo = jAXBContextImpl.getOrCreate((RuntimeTypeInfo)((Object)typeRef.getTarget()));
            Loader loader = jaxBeanInfo.getLoader(jAXBContextImpl, true);
            if (typeRef.getDefaultValue() != null) {
                loader = new DefaultValueLoaderDecorator(loader, typeRef.getDefaultValue());
            }
            if (this.nillable || unmarshallerChain.context.allNillable) {
                loader = new XsiNilLoader.Single(loader, this.acc);
            }
            qNameMap.put(typeRef.getTagName(), new ChildLoader(loader, this.acc));
        }
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    @Override
    public Accessor getElementPropertyAccessor(String string, String string2) {
        for (QName qName : this.acceptedElements) {
            if (!qName.getNamespaceURI().equals(string) || !qName.getLocalPart().equals(string2)) continue;
            return this.acc;
        }
        return null;
    }
}

