/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509IssuerSerialResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(X509IssuerSerialResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        }
        X509Data x509Data = null;
        try {
            x509Data = new X509Data(element, string);
        }
        catch (XMLSignatureException xMLSignatureException) {
            log.log(Level.FINE, "I can't");
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "I can't");
            return null;
        }
        if (x509Data == null) {
            log.log(Level.FINE, "I can't");
            return null;
        }
        if (!x509Data.containsIssuerSerial()) {
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509IssuerSerial"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.log(Level.INFO, "", keyResolverException);
                throw keyResolverException;
            }
            int n = x509Data.lengthIssuerSerial();
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509IssuerSerial xMLX509IssuerSerial = new XMLX509IssuerSerial(element.getOwnerDocument(), x509Certificate);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Found Certificate Issuer: " + xMLX509IssuerSerial.getIssuerName());
                    log.log(Level.FINE, "Found Certificate Serial: " + xMLX509IssuerSerial.getSerialNumber().toString());
                }
                for (int i = 0; i < n; ++i) {
                    XMLX509IssuerSerial xMLX509IssuerSerial2 = x509Data.itemIssuerSerial(i);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Found Element Issuer:     " + xMLX509IssuerSerial2.getIssuerName());
                        log.log(Level.FINE, "Found Element Serial:     " + xMLX509IssuerSerial2.getSerialNumber().toString());
                    }
                    if (xMLX509IssuerSerial.equals(xMLX509IssuerSerial2)) {
                        log.log(Level.FINE, "match !!! ");
                        return x509Certificate;
                    }
                    log.log(Level.FINE, "no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

