/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ConvertingMethod;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MBeanSupport;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.Util;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.MXBeanMappingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXBeanSupport
extends MBeanSupport<ConvertingMethod> {
    private final Object lock = new Object();
    private MXBeanLookup.Plain mxbeanLookup;
    private ObjectName objectName;

    public <T> MXBeanSupport(T t, Class<T> clazz, MXBeanMappingFactory mXBeanMappingFactory) throws NotCompliantMBeanException {
        super(t, clazz, mXBeanMappingFactory);
    }

    @Override
    MBeanIntrospector<ConvertingMethod> getMBeanIntrospector(MXBeanMappingFactory mXBeanMappingFactory) {
        return MXBeanIntrospector.getInstance(mXBeanMappingFactory);
    }

    @Override
    Object getCookie() {
        return this.mxbeanLookup;
    }

    static <T> Class<? super T> findMXBeanInterface(Class<T> clazz) {
        Object object;
        if (clazz == null) {
            throw new IllegalArgumentException("Null resource class");
        }
        Set<Class<?>> set = MXBeanSupport.transitiveInterfaces(clazz);
        Set<Class<?>> set2 = Util.newSet();
        for (Class<Object> clazz2 : set) {
            if (!JMX.isMXBeanInterface(clazz2)) continue;
            set2.add(clazz2);
        }
        block1: while (set2.size() > 1) {
            for (Class<Object> clazz2 : set2) {
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    Class clazz3 = (Class)iterator.next();
                    if (clazz2 == clazz3 || !clazz3.isAssignableFrom(clazz2)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            object = "Class " + clazz.getName() + " implements more than " + "one MXBean interface: " + set2;
            throw new IllegalArgumentException((String)object);
        }
        if (set2.iterator().hasNext()) {
            return (Class)Util.cast(set2.iterator().next());
        }
        object = "Class " + clazz.getName() + " is not a JMX compliant MXBean";
        throw new IllegalArgumentException((String)object);
    }

    private static Set<Class<?>> transitiveInterfaces(Class<?> clazz) {
        Set<Class<?>> set = Util.newSet();
        MXBeanSupport.transitiveInterfaces(clazz, set);
        return set;
    }

    private static void transitiveInterfaces(Class<?> clazz, Set<Class<?>> set) {
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            set.add(clazz);
        }
        MXBeanSupport.transitiveInterfaces(clazz.getSuperclass(), set);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            MXBeanSupport.transitiveInterfaces(clazz2, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(MBeanServer mBeanServer, ObjectName objectName) throws InstanceAlreadyExistsException {
        if (objectName == null) {
            throw new IllegalArgumentException("Null object name");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mxbeanLookup = MXBeanLookup.Plain.lookupFor(mBeanServer);
            this.mxbeanLookup.addReference(objectName, this.getWrappedObject());
            this.objectName = objectName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mxbeanLookup != null && this.mxbeanLookup.removeReference(this.objectName, this.getWrappedObject())) {
                this.objectName = null;
            }
        }
    }
}

