/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;

final class BlockCipherParamsCore {
    private int block_size = 0;
    private byte[] iv = null;

    BlockCipherParamsCore(int n) {
        this.block_size = n;
    }

    void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        byte[] byArray = ((IvParameterSpec)algorithmParameterSpec).getIV();
        if (byArray.length != this.block_size) {
            throw new InvalidParameterSpecException("IV not " + this.block_size + " bytes long");
        }
        this.iv = (byte[])byArray.clone();
    }

    void init(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        if (derInputStream.available() != 0) {
            throw new IOException("IV parsing error: extra data");
        }
        if (byArray2.length != this.block_size) {
            throw new IOException("IV not " + this.block_size + " bytes long");
        }
        this.iv = byArray2;
    }

    void init(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.init(byArray);
    }

    AlgorithmParameterSpec getParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (IvParameterSpec.class.isAssignableFrom(clazz)) {
            return new IvParameterSpec(this.iv);
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    byte[] getEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOctetString(this.iv);
        return derOutputStream.toByteArray();
    }

    byte[] getEncoded(String string) throws IOException {
        return this.getEncoded();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = string + "    iv:" + string + "[";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string2 = string2 + hexDumpEncoder.encodeBuffer(this.iv);
        string2 = string2 + "]" + string;
        return string2;
    }
}

