/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.util.HostnameChecker;
import sun.security.validator.KeyStores;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;

final class X509TrustManagerImpl
extends X509ExtendedTrustManager
implements X509TrustManager {
    private static final boolean checkRevocation = Debug.getBooleanProperty("com.sun.net.ssl.checkRevocation", false);
    private final String validatorType;
    private final Collection<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters pkixParams;
    private volatile Validator clientValidator;
    private volatile Validator serverValidator;
    private static final Debug debug = Debug.getInstance("ssl");

    X509TrustManagerImpl(String string, KeyStore keyStore) throws KeyStoreException {
        this.validatorType = string;
        this.pkixParams = null;
        this.trustedCerts = keyStore == null ? Collections.emptySet() : KeyStores.getTrustedCerts((KeyStore)keyStore);
        this.showTrustedCerts();
    }

    X509TrustManagerImpl(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        this.validatorType = string;
        this.pkixParams = pKIXBuilderParameters;
        Validator validator = this.getValidator("tls server");
        this.trustedCerts = validator.getTrustedCertificates();
        this.serverValidator = validator;
        this.showTrustedCerts();
    }

    private void showTrustedCerts() {
        if (debug != null && Debug.isOn("trustmanager")) {
            for (X509Certificate x509Certificate : this.trustedCerts) {
                System.out.println("adding as trusted cert:");
                System.out.println("  Subject: " + x509Certificate.getSubjectX500Principal());
                System.out.println("  Issuer:  " + x509Certificate.getIssuerX500Principal());
                System.out.println("  Algorithm: " + x509Certificate.getPublicKey().getAlgorithm() + "; Serial number: 0x" + x509Certificate.getSerialNumber().toString(16));
                System.out.println("  Valid from " + x509Certificate.getNotBefore() + " until " + x509Certificate.getNotAfter());
                System.out.println();
            }
        }
    }

    private Validator getValidator(String string) {
        Validator validator;
        if (this.pkixParams == null) {
            validator = Validator.getInstance(this.validatorType, string, this.trustedCerts);
            if (validator instanceof PKIXValidator) {
                PKIXValidator pKIXValidator = (PKIXValidator)validator;
                pKIXValidator.getParameters().setRevocationEnabled(checkRevocation);
            }
        } else {
            validator = Validator.getInstance(this.validatorType, string, this.pkixParams);
        }
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] validate(Validator validator, X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        Object object = JsseJce.beginFipsProvider();
        try {
            X509Certificate[] x509CertificateArray2 = validator.validate(x509CertificateArray, null, string);
            return x509CertificateArray2;
        }
        finally {
            JsseJce.endFipsProvider(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        if (x509CertificateArray == null) throw new IllegalArgumentException("null or zero-length certificate chain");
        if (x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (string == null) throw new IllegalArgumentException("null or zero-length authentication type");
        if (string.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Validator validator = this.clientValidator;
        if (validator == null) {
            x509CertificateArray2 = this;
            // MONITORENTER : this
            validator = this.clientValidator;
            if (validator == null) {
                this.clientValidator = validator = super.getValidator("tls client");
            }
            // MONITOREXIT : x509CertificateArray2
        }
        x509CertificateArray2 = X509TrustManagerImpl.validate(validator, x509CertificateArray, null);
        if (debug == null) return;
        if (!Debug.isOn("trustmanager")) return;
        System.out.println("Found trusted certificate:");
        System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        if (x509CertificateArray == null) throw new IllegalArgumentException("null or zero-length certificate chain");
        if (x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (string == null) throw new IllegalArgumentException("null or zero-length authentication type");
        if (string.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Validator validator = this.serverValidator;
        if (validator == null) {
            x509CertificateArray2 = this;
            // MONITORENTER : this
            validator = this.serverValidator;
            if (validator == null) {
                this.serverValidator = validator = super.getValidator("tls server");
            }
            // MONITOREXIT : x509CertificateArray2
        }
        x509CertificateArray2 = X509TrustManagerImpl.validate(validator, x509CertificateArray, string);
        if (debug == null) return;
        if (!Debug.isOn("trustmanager")) return;
        System.out.println("Found trusted certificate:");
        System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCerts.size()];
        this.trustedCerts.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, String string2, String string3) throws CertificateException {
        this.checkClientTrusted(x509CertificateArray, string);
        this.checkIdentity(string2, x509CertificateArray[0], string3);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, String string2, String string3) throws CertificateException {
        this.checkServerTrusted(x509CertificateArray, string);
        this.checkIdentity(string2, x509CertificateArray[0], string3);
    }

    private void checkIdentity(String string, X509Certificate x509Certificate, String string2) throws CertificateException {
        if (string2 != null && string2.length() != 0) {
            if (string != null && string.startsWith("[") && string.endsWith("]")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string2.equalsIgnoreCase("HTTPS")) {
                HostnameChecker.getInstance((byte)1).match(string, x509Certificate);
            } else if (string2.equalsIgnoreCase("LDAP")) {
                HostnameChecker.getInstance((byte)2).match(string, x509Certificate);
            } else {
                throw new CertificateException("Unknown identification algorithm: " + string2);
            }
        }
    }
}

