/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.tree;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.tree.BadOopTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.BooleanTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.CharTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.DoubleTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.FieldTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.FloatTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.LongTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.RevPtrsTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;

public class OopTreeNodeAdapter
extends FieldTreeNodeAdapter {
    private Oop oop;

    public OopTreeNodeAdapter(Oop oop, FieldIdentifier id) {
        this(oop, id, false);
    }

    public OopTreeNodeAdapter(Oop oop, FieldIdentifier id, boolean treeTableMode) {
        super(id, treeTableMode);
        this.oop = oop;
    }

    public Oop getOop() {
        return this.oop;
    }

    public int getChildCount() {
        if (this.oop == null) {
            return 0;
        }
        Counter c = new Counter();
        this.oop.iterate(c, true);
        return c.getNumFields() + (VM.getVM().getRevPtrs() == null ? 0 : 1);
    }

    public SimpleTreeNode getChild(int index) {
        if (this.oop == null) {
            return null;
        }
        if (VM.getVM().getRevPtrs() != null) {
            if (index == 0) {
                return new RevPtrsTreeNodeAdapter(this.oop, this.getTreeTableMode());
            }
            --index;
        }
        Fetcher f = new Fetcher(index);
        this.oop.iterate(f, true);
        return f.getChild();
    }

    public boolean isLeaf() {
        return this.oop == null;
    }

    public int getIndexOfChild(SimpleTreeNode child) {
        if (child instanceof RevPtrsTreeNodeAdapter) {
            return 0;
        }
        FieldIdentifier id = ((FieldTreeNodeAdapter)child).getID();
        Finder f = new Finder(id);
        this.oop.iterate(f, true);
        return f.getIndex() + (VM.getVM().getRevPtrs() == null ? 0 : 1);
    }

    public String getValue() {
        if (this.oop != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Oop.printOopValueOn(this.oop, new PrintStream(bos));
            return bos.toString();
        }
        return "null";
    }

    static class Finder
    extends DefaultOopVisitor {
        private FieldIdentifier id;
        private int curField;
        private int index;

        public Finder(FieldIdentifier id) {
            this.id = id;
        }

        public int getIndex() {
            return this.index;
        }

        public void prologue() {
            this.curField = 0;
            this.index = -1;
        }

        public void doOop(OopField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doByte(ByteField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doChar(CharField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doBoolean(BooleanField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doShort(ShortField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doInt(IntField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doLong(LongField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doFloat(FloatField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doDouble(DoubleField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        public void doCInt(CIntField field, boolean isVMField) {
            if (field.getID().equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }
    }

    class Fetcher
    extends DefaultOopVisitor {
        private int index;
        private int curField;
        private SimpleTreeNode child;

        public Fetcher(int index) {
            this.index = index;
        }

        public SimpleTreeNode getChild() {
            return this.child;
        }

        public void prologue() {
            this.curField = 0;
        }

        public void doOop(OopField field, boolean isVMField) {
            if (this.curField == this.index) {
                try {
                    this.child = new OopTreeNodeAdapter(field.getValue(this.getObj()), field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
                }
                catch (AddressException e) {
                    this.child = new BadOopTreeNodeAdapter(field.getValueAsOopHandle(this.getObj()), field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
                }
            }
            ++this.curField;
        }

        public void doByte(ByteField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new LongTreeNodeAdapter(field.getValue(this.getObj()) & 0xFF, field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        public void doChar(CharField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new CharTreeNodeAdapter(field.getValue(this.getObj()), field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        public void doBoolean(BooleanField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new BooleanTreeNodeAdapter(field.getValue(this.getObj()), field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        public void doShort(ShortField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new LongTreeNodeAdapter(field.getValue(this.getObj()) & 0xFFFF, field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        public void doInt(IntField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new LongTreeNodeAdapter(field.getValue(this.getObj()) & 0xFFFFFFFF, field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        public void doLong(LongField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new LongTreeNodeAdapter(field.getValue(this.getObj()), field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        public void doFloat(FloatField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new FloatTreeNodeAdapter(field.getValue(this.getObj()), field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        public void doDouble(DoubleField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new DoubleTreeNodeAdapter(field.getValue(this.getObj()), field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        public void doCInt(CIntField field, boolean isVMField) {
            if (this.curField == this.index) {
                this.child = new LongTreeNodeAdapter(field.getValue(this.getObj()), field.getID(), OopTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }
    }

    static class Counter
    extends DefaultOopVisitor {
        private int numFields;

        Counter() {
        }

        public int getNumFields() {
            return this.numFields;
        }

        public void prologue() {
            this.numFields = 0;
        }

        public void doOop(OopField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doByte(ByteField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doChar(CharField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doBoolean(BooleanField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doShort(ShortField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doInt(IntField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doLong(LongField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doFloat(FloatField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doDouble(DoubleField field, boolean isVMField) {
            ++this.numFields;
        }

        public void doCInt(CIntField field, boolean isVMField) {
            ++this.numFields;
        }
    }
}

