/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PKIXMasterCertPathValidator {
    private static final Debug debug = Debug.getInstance("certpath");
    private List<PKIXCertPathChecker> certPathCheckers;

    PKIXMasterCertPathValidator(List<PKIXCertPathChecker> list) {
        this.certPathCheckers = list;
    }

    void validate(CertPath certPath, List<X509Certificate> list) throws CertPathValidatorException {
        int n = list.size();
        if (debug != null) {
            debug.println("--------------------------------------------------------------");
            debug.println("Executing PKIX certification path validation algorithm.");
        }
        for (int i = 0; i < n; ++i) {
            X509Certificate x509Certificate;
            Set<String> set;
            if (debug != null) {
                debug.println("Checking cert" + (i + 1) + " ...");
            }
            if ((set = (x509Certificate = list.get(i)).getCriticalExtensionOIDs()) == null) {
                set = Collections.emptySet();
            }
            if (debug != null && !set.isEmpty()) {
                debug.println("Set of critical extensions:");
                for (String string : set) {
                    debug.println(string);
                }
            }
            Object object = null;
            for (int j = 0; j < this.certPathCheckers.size(); ++j) {
                block20: {
                    PKIXCertPathChecker pKIXCertPathChecker = this.certPathCheckers.get(j);
                    if (debug != null) {
                        debug.println("-Using checker" + (j + 1) + " ... [" + pKIXCertPathChecker.getClass().getName() + "]");
                    }
                    if (i == 0) {
                        pKIXCertPathChecker.init(false);
                    }
                    try {
                        pKIXCertPathChecker.check(x509Certificate, set);
                        if (PKIXMasterCertPathValidator.isRevocationCheck(pKIXCertPathChecker, j, this.certPathCheckers)) {
                            if (debug != null) {
                                debug.println("-checker" + (j + 1) + " validation succeeded");
                            }
                            ++j;
                            continue;
                        }
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        if (object != null && pKIXCertPathChecker instanceof CrlRevocationChecker) {
                            if (certPathValidatorException.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                                throw certPathValidatorException;
                            }
                            throw object;
                        }
                        CertPathValidatorException certPathValidatorException2 = new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n - (i + 1), certPathValidatorException.getReason());
                        if (certPathValidatorException.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                            throw certPathValidatorException2;
                        }
                        if (!PKIXMasterCertPathValidator.isRevocationCheck(pKIXCertPathChecker, j, this.certPathCheckers)) {
                            throw certPathValidatorException2;
                        }
                        object = certPathValidatorException2;
                        if (debug == null) break block20;
                        debug.println(certPathValidatorException.getMessage());
                        debug.println("preparing to failover (from OCSP to CRLs)");
                    }
                }
                if (debug == null) continue;
                debug.println("-checker" + (j + 1) + " validation succeeded");
            }
            if (debug != null) {
                debug.println("checking for unresolvedCritExts");
            }
            if (!set.isEmpty()) {
                throw new CertPathValidatorException("unrecognized critical extension(s)", null, certPath, n - (i + 1), PKIXReason.UNRECOGNIZED_CRIT_EXT);
            }
            if (debug == null) continue;
            debug.println("\ncert" + (i + 1) + " validation succeeded.\n");
        }
        if (debug != null) {
            debug.println("Cert path validation succeeded. (PKIX validation algorithm)");
            debug.println("--------------------------------------------------------------");
        }
    }

    private static boolean isRevocationCheck(PKIXCertPathChecker pKIXCertPathChecker, int n, List<PKIXCertPathChecker> list) {
        PKIXCertPathChecker pKIXCertPathChecker2;
        return pKIXCertPathChecker instanceof OCSPChecker && n + 1 < list.size() && (pKIXCertPathChecker2 = list.get(n + 1)) instanceof CrlRevocationChecker;
    }
}

