/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileOwnerAttributeViewImpl
implements FileOwnerAttributeView {
    private static final String OWNER_NAME = "owner";
    private final FileAttributeView view;
    private final boolean isPosixView;

    FileOwnerAttributeViewImpl(PosixFileAttributeView posixFileAttributeView) {
        this.view = posixFileAttributeView;
        this.isPosixView = true;
    }

    FileOwnerAttributeViewImpl(AclFileAttributeView aclFileAttributeView) {
        this.view = aclFileAttributeView;
        this.isPosixView = false;
    }

    @Override
    public String name() {
        return OWNER_NAME;
    }

    @Override
    public Object getAttribute(String string) throws IOException {
        if (string.equals(OWNER_NAME)) {
            return this.getOwner();
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) throws IOException {
        if (string.equals(OWNER_NAME)) {
            this.setOwner((UserPrincipal)object);
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ?> readAttributes(String string, String[] stringArray) throws IOException {
        HashMap<String, UserPrincipal> hashMap = new HashMap<String, UserPrincipal>();
        if (string.equals("*") || string.equals(OWNER_NAME)) {
            hashMap.put(OWNER_NAME, this.getOwner());
        } else {
            for (String string2 : stringArray) {
                if (!string2.equals("*") && !string2.equals(OWNER_NAME)) continue;
                hashMap.put(OWNER_NAME, this.getOwner());
                break;
            }
        }
        return hashMap;
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        if (this.isPosixView) {
            return ((PosixFileAttributeView)this.view).readAttributes().owner();
        }
        return ((AclFileAttributeView)this.view).getOwner();
    }

    @Override
    public void setOwner(UserPrincipal userPrincipal) throws IOException {
        if (this.isPosixView) {
            ((PosixFileAttributeView)this.view).setOwner(userPrincipal);
        } else {
            ((AclFileAttributeView)this.view).setOwner(userPrincipal);
        }
    }
}

