/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousDatagramChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.DatagramChannel;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.MembershipKey;
import java.nio.channels.MulticastChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.Cancellable;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Groupable;
import sun.nio.ch.Invoker;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleAsynchronousDatagramChannelImpl
extends AsynchronousDatagramChannel
implements Groupable,
Cancellable {
    private final DatagramChannel dc;
    private final AsynchronousChannelGroupImpl group;
    private final Object attachKey;
    private boolean closed;
    private final Object readLock = new Object();
    private boolean isBlocking = true;
    private int blockingReaderCount;
    private boolean transitionToNonBlocking;
    private boolean blockingReadKilledByCancel;
    private Selector firstReader;
    private Set<Selector> otherReaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleAsynchronousDatagramChannelImpl(ProtocolFamily protocolFamily, AsynchronousChannelGroupImpl asynchronousChannelGroupImpl) throws IOException {
        super(asynchronousChannelGroupImpl.provider());
        this.dc = protocolFamily == null ? DatagramChannel.open() : DatagramChannel.open(protocolFamily);
        this.group = asynchronousChannelGroupImpl;
        boolean bl = false;
        try {
            if (!(this.dc instanceof DatagramChannelImpl)) {
                throw new UnsupportedOperationException();
            }
            this.attachKey = asynchronousChannelGroupImpl.attachForeignChannel(this, ((DatagramChannelImpl)this.dc).getFD());
            bl = true;
        }
        finally {
            if (!bl) {
                this.dc.close();
            }
        }
    }

    private void ensureBlockingReadNotKilled() {
        assert (Thread.holdsLock(this.readLock));
        if (this.blockingReadKilledByCancel) {
            throw new RuntimeException("Reading not allowed due to cancellation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginNoTimeoutRead() {
        Object object = this.readLock;
        synchronized (object) {
            this.ensureBlockingReadNotKilled();
            if (this.isBlocking) {
                ++this.blockingReaderCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endNoTimeoutRead() {
        Object object = this.readLock;
        synchronized (object) {
            if (this.isBlocking && --this.blockingReaderCount == 0 && this.transitionToNonBlocking) {
                this.readLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long prepareForTimedRead(PendingFuture<?, ?> pendingFuture, long l) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            this.ensureBlockingReadNotKilled();
            if (this.isBlocking) {
                this.transitionToNonBlocking = true;
                while (this.blockingReaderCount > 0 && l > 0L && !pendingFuture.isCancelled()) {
                    long l2 = System.currentTimeMillis();
                    try {
                        this.readLock.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l -= System.currentTimeMillis() - l2;
                }
                if (this.blockingReaderCount == 0) {
                    this.ensureBlockingReadNotKilled();
                    this.dc.configureBlocking(false);
                    this.isBlocking = false;
                }
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Selector getSelector() throws IOException {
        Selector selector = Util.getTemporarySelector(this.dc);
        Object object = this.readLock;
        synchronized (object) {
            if (this.firstReader == null) {
                this.firstReader = selector;
            } else {
                if (this.otherReaders == null) {
                    this.otherReaders = new HashSet<Selector>();
                }
                this.otherReaders.add(selector);
            }
        }
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSelector(Selector selector) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.firstReader == selector) {
                this.firstReader = null;
            } else {
                this.otherReaders.remove(selector);
            }
        }
        Util.releaseTemporarySelector(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupSelectors() {
        Object object = this.readLock;
        synchronized (object) {
            if (this.firstReader != null) {
                this.firstReader.wakeup();
            }
            if (this.otherReaders != null) {
                for (Selector selector : this.otherReaders) {
                    selector.wakeup();
                }
            }
        }
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.group;
    }

    @Override
    public boolean isOpen() {
        return this.dc.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancel(PendingFuture<?, ?> pendingFuture) {
        Object object = this.readLock;
        synchronized (object) {
            if (this.blockingReaderCount > 0) {
                this.blockingReadKilledByCancel = true;
                this.readLock.notifyAll();
                return;
            }
        }
        this.wakeupSelectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        DatagramChannel datagramChannel = this.dc;
        synchronized (datagramChannel) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.group.detachForeignChannel(this.attachKey);
        this.dc.close();
        this.wakeupSelectors();
    }

    @Override
    public AsynchronousDatagramChannel connect(SocketAddress socketAddress) throws IOException {
        this.dc.connect(socketAddress);
        return this;
    }

    @Override
    public AsynchronousDatagramChannel disconnect() throws IOException {
        this.dc.disconnect();
        return this;
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        MembershipKey membershipKey = this.dc.join(inetAddress, networkInterface);
        return new WrappedMembershipKey(this, membershipKey);
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) throws IOException {
        MembershipKey membershipKey = this.dc.join(inetAddress, networkInterface, inetAddress2);
        return new WrappedMembershipKey(this, membershipKey);
    }

    @Override
    public <A> Future<Integer> send(ByteBuffer byteBuffer, SocketAddress socketAddress, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        CompletedFuture<Object, A> completedFuture;
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        try {
            int n = this.dc.send(byteBuffer, socketAddress);
            completedFuture = CompletedFuture.withResult(this, n, a);
        }
        catch (IOException iOException) {
            completedFuture = CompletedFuture.withFailure(this, iOException, a);
        }
        Invoker.invoke(completionHandler, completedFuture);
        return completedFuture;
    }

    @Override
    public <A> Future<Integer> write(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        CompletedFuture<Object, A> completedFuture;
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        try {
            int n = this.dc.write(byteBuffer);
            completedFuture = CompletedFuture.withResult(this, n, a);
        }
        catch (IOException iOException) {
            completedFuture = CompletedFuture.withFailure(this, iOException, a);
        }
        Invoker.invoke(completionHandler, completedFuture);
        return completedFuture;
    }

    private SocketAddress doRestrictedReceive(final ByteBuffer byteBuffer, AccessControlContext accessControlContext) throws IOException {
        if (accessControlContext == null) {
            return this.dc.receive(byteBuffer);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SocketAddress>(){

                @Override
                public SocketAddress run() throws IOException {
                    return SimpleAsynchronousDatagramChannelImpl.this.dc.receive(byteBuffer);
                }
            }, accessControlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof SecurityException) {
                throw (SecurityException)exception;
            }
            throw (IOException)exception;
        }
    }

    @Override
    public <A> Future<SocketAddress> receive(final ByteBuffer byteBuffer, final long l, final TimeUnit timeUnit, A a, final CompletionHandler<SocketAddress, ? super A> completionHandler) {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        if (!this.isOpen()) {
            CompletedFuture completedFuture = CompletedFuture.withFailure(this, new ClosedChannelException(), a);
            Invoker.invoke(completionHandler, completedFuture);
            return completedFuture;
        }
        final AccessControlContext accessControlContext = System.getSecurityManager() == null ? null : AccessController.getContext();
        final PendingFuture<SocketAddress, ? super A> pendingFuture = new PendingFuture<SocketAddress, A>(this, completionHandler, a);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SocketAddress socketAddress;
                    block19: {
                        long l3;
                        socketAddress = null;
                        if (l == 0L) {
                            SimpleAsynchronousDatagramChannelImpl.this.beginNoTimeoutRead();
                            try {
                                socketAddress = SimpleAsynchronousDatagramChannelImpl.this.doRestrictedReceive(byteBuffer, accessControlContext);
                            }
                            finally {
                                SimpleAsynchronousDatagramChannelImpl.this.endNoTimeoutRead();
                            }
                            l3 = 0L;
                        } else {
                            l3 = SimpleAsynchronousDatagramChannelImpl.this.prepareForTimedRead(pendingFuture, timeUnit.toMillis(l));
                            if (l3 <= 0L) {
                                throw new InterruptedByTimeoutException();
                            }
                            socketAddress = SimpleAsynchronousDatagramChannelImpl.this.doRestrictedReceive(byteBuffer, accessControlContext);
                        }
                        if (socketAddress == null) {
                            Selector selector = SimpleAsynchronousDatagramChannelImpl.this.getSelector();
                            SelectionKey selectionKey = null;
                            try {
                                long l2;
                                selectionKey = SimpleAsynchronousDatagramChannelImpl.this.dc.register(selector, 1);
                                do {
                                    if (!SimpleAsynchronousDatagramChannelImpl.this.dc.isOpen()) {
                                        throw new AsynchronousCloseException();
                                    }
                                    if (pendingFuture.isCancelled()) {
                                        break block19;
                                    }
                                    l2 = System.currentTimeMillis();
                                    int n = selector.select(l3);
                                    if (n > 0 && (socketAddress = SimpleAsynchronousDatagramChannelImpl.this.doRestrictedReceive(byteBuffer, accessControlContext)) != null) {
                                        break block19;
                                    }
                                    selector.selectedKeys().remove(selectionKey);
                                } while (l == 0L || (l3 -= System.currentTimeMillis() - l2) > 0L);
                                throw new InterruptedByTimeoutException();
                            }
                            finally {
                                if (selectionKey != null) {
                                    selectionKey.cancel();
                                }
                                SimpleAsynchronousDatagramChannelImpl.this.releaseSelector(selector);
                            }
                        }
                    }
                    pendingFuture.setResult(socketAddress);
                }
                catch (Throwable throwable) {
                    AsynchronousCloseException asynchronousCloseException;
                    if (throwable instanceof ClosedChannelException) {
                        asynchronousCloseException = new AsynchronousCloseException();
                    }
                    pendingFuture.setFailure(asynchronousCloseException);
                }
                Invoker.invokeUnchecked(completionHandler, pendingFuture);
            }
        };
        try {
            this.group.executeOnPooledThread(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new ShutdownChannelGroupException();
        }
        return pendingFuture;
    }

    @Override
    public <A> Future<Integer> read(final ByteBuffer byteBuffer, final long l, final TimeUnit timeUnit, A a, final CompletionHandler<Integer, ? super A> completionHandler) {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        if (!this.dc.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (!this.isOpen()) {
            CompletedFuture completedFuture = CompletedFuture.withFailure(this, new ClosedChannelException(), a);
            Invoker.invoke(completionHandler, completedFuture);
            return completedFuture;
        }
        final PendingFuture<Integer, ? super A> pendingFuture = new PendingFuture<Integer, A>(this, completionHandler, a);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int n;
                    block19: {
                        long l3;
                        n = 0;
                        if (l == 0L) {
                            SimpleAsynchronousDatagramChannelImpl.this.beginNoTimeoutRead();
                            try {
                                n = SimpleAsynchronousDatagramChannelImpl.this.dc.read(byteBuffer);
                            }
                            finally {
                                SimpleAsynchronousDatagramChannelImpl.this.endNoTimeoutRead();
                            }
                            l3 = 0L;
                        } else {
                            l3 = SimpleAsynchronousDatagramChannelImpl.this.prepareForTimedRead(pendingFuture, timeUnit.toMillis(l));
                            if (l3 <= 0L) {
                                throw new InterruptedByTimeoutException();
                            }
                            n = SimpleAsynchronousDatagramChannelImpl.this.dc.read(byteBuffer);
                        }
                        if (n == 0) {
                            Selector selector = SimpleAsynchronousDatagramChannelImpl.this.getSelector();
                            SelectionKey selectionKey = null;
                            try {
                                long l2;
                                selectionKey = SimpleAsynchronousDatagramChannelImpl.this.dc.register(selector, 1);
                                do {
                                    if (!SimpleAsynchronousDatagramChannelImpl.this.dc.isOpen()) {
                                        throw new AsynchronousCloseException();
                                    }
                                    if (pendingFuture.isCancelled()) {
                                        break block19;
                                    }
                                    l2 = System.currentTimeMillis();
                                    int n2 = selector.select(l3);
                                    if (n2 > 0 && (n = SimpleAsynchronousDatagramChannelImpl.this.dc.read(byteBuffer)) != 0) {
                                        break block19;
                                    }
                                    selector.selectedKeys().remove(selectionKey);
                                } while (l == 0L || (l3 -= System.currentTimeMillis() - l2) > 0L);
                                throw new InterruptedByTimeoutException();
                            }
                            finally {
                                if (selectionKey != null) {
                                    selectionKey.cancel();
                                }
                                SimpleAsynchronousDatagramChannelImpl.this.releaseSelector(selector);
                            }
                        }
                    }
                    pendingFuture.setResult(n);
                }
                catch (Throwable throwable) {
                    AsynchronousCloseException asynchronousCloseException;
                    if (throwable instanceof ClosedChannelException) {
                        asynchronousCloseException = new AsynchronousCloseException();
                    }
                    pendingFuture.setFailure(asynchronousCloseException);
                }
                Invoker.invokeUnchecked(completionHandler, pendingFuture);
            }
        };
        try {
            this.group.executeOnPooledThread(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new ShutdownChannelGroupException();
        }
        return pendingFuture;
    }

    @Override
    public AsynchronousDatagramChannel bind(SocketAddress socketAddress) throws IOException {
        this.dc.bind(socketAddress);
        return this;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.dc.getLocalAddress();
    }

    @Override
    public <T> AsynchronousDatagramChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        this.dc.setOption((SocketOption)socketOption, (Object)t);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return this.dc.getOption(socketOption);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.dc.supportedOptions();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.dc.getRemoteAddress();
    }

    private static class WrappedMembershipKey
    extends MembershipKey {
        private final MulticastChannel channel;
        private final MembershipKey key;

        WrappedMembershipKey(MulticastChannel multicastChannel, MembershipKey membershipKey) {
            this.channel = multicastChannel;
            this.key = membershipKey;
        }

        public boolean isValid() {
            return this.key.isValid();
        }

        public void drop() {
            this.key.drop();
        }

        public MulticastChannel channel() {
            return this.channel;
        }

        public InetAddress group() {
            return this.key.group();
        }

        public NetworkInterface networkInterface() {
            return this.key.networkInterface();
        }

        public InetAddress sourceAddress() {
            return this.key.sourceAddress();
        }

        public MembershipKey block(InetAddress inetAddress) throws IOException {
            this.key.block(inetAddress);
            return this;
        }

        public MembershipKey unblock(InetAddress inetAddress) {
            this.key.unblock(inetAddress);
            return this;
        }

        public String toString() {
            return this.key.toString();
        }
    }
}

