/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import sun.nio.ch.AsynchronousFileChannelImpl;
import sun.nio.ch.FileChannelImpl;

public class FileLockImpl
extends FileLock {
    private volatile boolean valid = true;

    FileLockImpl(FileChannel fileChannel, long l, long l2, boolean bl) {
        super(fileChannel, l, l2, bl);
    }

    FileLockImpl(AsynchronousFileChannel asynchronousFileChannel, long l, long l2, boolean bl) {
        super(asynchronousFileChannel, l, l2, bl);
    }

    public boolean isValid() {
        return this.valid;
    }

    void invalidate() {
        assert (Thread.holdsLock(this));
        this.valid = false;
    }

    public synchronized void release() throws IOException {
        Channel channel = this.acquiredBy();
        if (!channel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.valid) {
            if (channel instanceof FileChannelImpl) {
                ((FileChannelImpl)channel).release(this);
            } else if (channel instanceof AsynchronousFileChannelImpl) {
                ((AsynchronousFileChannelImpl)channel).release(this);
            } else {
                throw new AssertionError();
            }
            this.valid = false;
        }
    }
}

