/*
 * Decompiled with CFR 0.152.
 */
package javax.management.event;

import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.event.EventConsumer;

public class EventSubscriber
implements EventConsumer {
    private NotificationListener myMBeanServerListener = new NotificationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notification, Object object) {
            if (!(notification instanceof MBeanServerNotification) || !"JMX.mbean.registered".equals(notification.getType())) {
                return;
            }
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            try {
                if (!EventSubscriber.this.mbeanServer.isInstanceOf(objectName, NotificationBroadcaster.class.getName())) {
                    return;
                }
            }
            catch (Exception exception) {
                logger.fine("myMBeanServerListener.handleNotification", "isInstanceOf", exception);
                return;
            }
            ArrayList arrayList = new ArrayList();
            Object object2 = EventSubscriber.this.exactSubscriptionMap;
            synchronized (object2) {
                Object object3 = (List)EventSubscriber.this.exactSubscriptionMap.get(objectName);
                if (object3 != null) {
                    arrayList.addAll(object3);
                }
            }
            object2 = EventSubscriber.this.patternSubscriptionMap;
            synchronized (object2) {
                for (ObjectName objectName2 : EventSubscriber.this.patternSubscriptionMap.keySet()) {
                    if (!objectName2.apply(objectName)) continue;
                    arrayList.addAll((Collection)EventSubscriber.this.patternSubscriptionMap.get(objectName2));
                }
            }
            for (Object object3 : arrayList) {
                try {
                    EventSubscriber.this.mbeanServer.addNotificationListener(objectName, ((MyListenerInfo)object3).listener, ((MyListenerInfo)object3).filter, ((MyListenerInfo)object3).handback);
                }
                catch (Exception exception) {
                    logger.fine("myMBeanServerListener.handleNotification", "addNotificationListener", exception);
                }
            }
        }
    };
    private final MBeanServer mbeanServer;
    private final Map<ObjectName, List<MyListenerInfo>> exactSubscriptionMap = new HashMap<ObjectName, List<MyListenerInfo>>();
    private final Map<ObjectName, List<MyListenerInfo>> patternSubscriptionMap = new HashMap<ObjectName, List<MyListenerInfo>>();
    private static final ClassLogger logger;
    private static final QueryExp notificationBroadcasterExp;
    private static final Map<MBeanServerConnection, WeakReference<EventSubscriber>> subscriberMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventSubscriber getEventSubscriber(MBeanServer mBeanServer) {
        if (mBeanServer == null) {
            throw new NullPointerException("Null MBeanServer");
        }
        EventSubscriber eventSubscriber = null;
        Map<MBeanServerConnection, WeakReference<EventSubscriber>> map = subscriberMap;
        synchronized (map) {
            WeakReference<EventSubscriber> weakReference = subscriberMap.get(mBeanServer);
            EventSubscriber eventSubscriber2 = eventSubscriber = weakReference == null ? null : (EventSubscriber)weakReference.get();
            if (eventSubscriber == null) {
                eventSubscriber = new EventSubscriber(mBeanServer);
                subscriberMap.put(mBeanServer, new WeakReference<EventSubscriber>(eventSubscriber));
            }
        }
        return eventSubscriber;
    }

    private EventSubscriber(final MBeanServer mBeanServer) {
        logger.trace("EventSubscriber", "create a new one");
        this.mbeanServer = mBeanServer;
        Exception exception = null;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, EventSubscriber.this.myMBeanServerListener, null, null);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            exception = privilegedActionException.getException();
        }
        if (exception != null && !(exception instanceof InstanceNotFoundException)) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("Can't add listener to MBean server delegate: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IOException {
        Set<ObjectName> set;
        Map<ObjectName, List<MyListenerInfo>> map;
        if (logger.traceOn()) {
            logger.trace("subscribe", "" + objectName);
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null MBean name");
        }
        if (notificationListener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        MyListenerInfo myListenerInfo = new MyListenerInfo(notificationListener, notificationFilter, object);
        if (objectName.isPattern()) {
            map = this.patternSubscriptionMap;
            set = this.mbeanServer.queryNames(objectName, notificationBroadcasterExp);
        } else {
            map = this.exactSubscriptionMap;
            set = Collections.singleton(objectName);
        }
        Map<ObjectName, List<MyListenerInfo>> map2 = map;
        synchronized (map2) {
            List<MyListenerInfo> list = map.get(objectName);
            if (list == null) {
                list = new ArrayList<MyListenerInfo>();
                map.put(objectName, list);
            }
            list.add(myListenerInfo);
        }
        for (ObjectName objectName2 : set) {
            try {
                this.mbeanServer.addNotificationListener(objectName2, notificationListener, notificationFilter, object);
            }
            catch (Exception exception) {
                logger.fine("subscribe", "addNotificationListener", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException, IOException {
        Set<ObjectName> set;
        Map<ObjectName, List<MyListenerInfo>> map;
        if (logger.traceOn()) {
            logger.trace("unsubscribe", "" + objectName);
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null MBean name");
        }
        if (notificationListener == null) {
            throw new ListenerNotFoundException();
        }
        if (objectName.isPattern()) {
            map = this.patternSubscriptionMap;
            set = this.mbeanServer.queryNames(objectName, notificationBroadcasterExp);
        } else {
            map = this.exactSubscriptionMap;
            set = Collections.singleton(objectName);
        }
        ArrayList<MyListenerInfo> arrayList = new ArrayList<MyListenerInfo>();
        Map<ObjectName, List<MyListenerInfo>> map2 = map;
        synchronized (map2) {
            List<MyListenerInfo> object = map.get(objectName);
            if (object == null) {
                throw new ListenerNotFoundException();
            }
            for (MyListenerInfo myListenerInfo : object) {
                if (myListenerInfo.listener != notificationListener) continue;
                arrayList.add(myListenerInfo);
            }
            if (arrayList.isEmpty()) {
                throw new ListenerNotFoundException();
            }
            for (MyListenerInfo myListenerInfo : arrayList) {
                object.remove(myListenerInfo);
            }
            if (object.isEmpty()) {
                map.remove(objectName);
            }
        }
        for (ObjectName objectName2 : set) {
            for (MyListenerInfo myListenerInfo : arrayList) {
                try {
                    this.mbeanServer.removeNotificationListener(objectName2, myListenerInfo.listener, myListenerInfo.filter, myListenerInfo.handback);
                }
                catch (Exception exception) {
                    logger.fine("unsubscribe", "removeNotificationListener", exception);
                }
            }
        }
    }

    static {
        QueryExp queryExp;
        logger = new ClassLogger("javax.management.event", "EventSubscriber");
        try {
            Method method = Query.class.getMethod("isInstanceOf", String.class);
            queryExp = (QueryExp)method.invoke(Query.class, NotificationBroadcaster.class.getName());
        }
        catch (Exception exception) {
            queryExp = new BroadcasterQueryExp();
        }
        notificationBroadcasterExp = queryExp;
        subscriberMap = new WeakHashMap<MBeanServerConnection, WeakReference<EventSubscriber>>();
    }

    private static class BroadcasterQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = 1234L;

        private BroadcasterQueryExp() {
        }

        public boolean apply(ObjectName objectName) {
            try {
                return BroadcasterQueryExp.getMBeanServer().isInstanceOf(objectName, NotificationBroadcaster.class.getName());
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class MyListenerInfo {
        public final NotificationListener listener;
        public final NotificationFilter filter;
        public final Object handback;

        public MyListenerInfo(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            if (notificationListener == null) {
                throw new IllegalArgumentException("Null listener");
            }
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
        }
    }
}

