/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.example.debug.tty.AmbiguousMethodException;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.LineNotFoundException;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BreakpointSpec
extends EventRequestSpec {
    String methodId;
    List<String> methodArgs;
    int lineNumber;

    BreakpointSpec(ReferenceTypeSpec referenceTypeSpec, int n) {
        super(referenceTypeSpec);
        this.methodId = null;
        this.methodArgs = null;
        this.lineNumber = n;
    }

    BreakpointSpec(ReferenceTypeSpec referenceTypeSpec, String string, List<String> list) throws MalformedMemberNameException {
        super(referenceTypeSpec);
        this.methodId = string;
        this.methodArgs = list;
        this.lineNumber = 0;
        if (!this.isValidMethodName(string)) {
            throw new MalformedMemberNameException(string);
        }
    }

    @Override
    EventRequest resolveEventRequest(ReferenceType referenceType) throws AmbiguousMethodException, AbsentInformationException, InvalidTypeException, NoSuchMethodException, LineNotFoundException {
        Location location = this.location(referenceType);
        if (location == null) {
            throw new InvalidTypeException();
        }
        EventRequestManager eventRequestManager = referenceType.virtualMachine().eventRequestManager();
        BreakpointRequest breakpointRequest = eventRequestManager.createBreakpointRequest(location);
        breakpointRequest.setSuspendPolicy(this.suspendPolicy);
        breakpointRequest.enable();
        return breakpointRequest;
    }

    String methodName() {
        return this.methodId;
    }

    int lineNumber() {
        return this.lineNumber;
    }

    List<String> methodArgs() {
        return this.methodArgs;
    }

    boolean isMethodBreakpoint() {
        return this.methodId != null;
    }

    public int hashCode() {
        return this.refSpec.hashCode() + this.lineNumber + (this.methodId != null ? this.methodId.hashCode() : 0) + (this.methodArgs != null ? this.methodArgs.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object instanceof BreakpointSpec) {
            BreakpointSpec breakpointSpec = (BreakpointSpec)object;
            return (this.methodId != null ? this.methodId.equals(breakpointSpec.methodId) : this.methodId == breakpointSpec.methodId) && (this.methodArgs != null ? this.methodArgs.equals(breakpointSpec.methodArgs) : this.methodArgs == breakpointSpec.methodArgs) && this.refSpec.equals(breakpointSpec.refSpec) && this.lineNumber == breakpointSpec.lineNumber;
        }
        return false;
    }

    @Override
    String errorMessageFor(Exception exception) {
        if (exception instanceof AmbiguousMethodException) {
            return MessageOutput.format("Method is overloaded; specify arguments", this.methodName());
        }
        if (exception instanceof NoSuchMethodException) {
            return MessageOutput.format("No method in", new Object[]{this.methodName(), this.refSpec.toString()});
        }
        if (exception instanceof AbsentInformationException) {
            return MessageOutput.format("No linenumber information for", this.refSpec.toString());
        }
        if (exception instanceof LineNotFoundException) {
            return MessageOutput.format("No code at line", new Object[]{new Long(this.lineNumber()), this.refSpec.toString()});
        }
        if (exception instanceof InvalidTypeException) {
            return MessageOutput.format("Breakpoints can be located only in classes.", this.refSpec.toString());
        }
        return super.errorMessageFor(exception);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.refSpec.toString());
        if (this.isMethodBreakpoint()) {
            stringBuffer.append('.');
            stringBuffer.append(this.methodId);
            if (this.methodArgs != null) {
                boolean bl = true;
                stringBuffer.append('(');
                for (String string : this.methodArgs) {
                    if (!bl) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(string);
                    bl = false;
                }
                stringBuffer.append(")");
            }
        } else {
            stringBuffer.append(':');
            stringBuffer.append(this.lineNumber);
        }
        return MessageOutput.format("breakpoint", stringBuffer.toString());
    }

    private Location location(ReferenceType referenceType) throws AmbiguousMethodException, AbsentInformationException, NoSuchMethodException, LineNotFoundException {
        Location location = null;
        if (this.isMethodBreakpoint()) {
            Method method = this.findMatchingMethod(referenceType);
            location = method.location();
        } else {
            List<Location> list = referenceType.locationsOfLine(this.lineNumber());
            if (list.size() == 0) {
                throw new LineNotFoundException();
            }
            location = list.get(0);
            if (location.method() == null) {
                throw new LineNotFoundException();
            }
        }
        return location;
    }

    private boolean isValidMethodName(String string) {
        return this.isJavaIdentifier(string) || string.equals("<init>") || string.equals("<clinit>");
    }

    private boolean compareArgTypes(Method method, List<String> list) {
        List<String> list2 = method.argumentTypeNames();
        if (list2.size() != list.size()) {
            return false;
        }
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = list2.get(i);
            if (string2.equals(string = list.get(i))) continue;
            if (i != n - 1 || !method.isVarArgs() || !string.endsWith("...")) {
                return false;
            }
            int n2 = string2.length();
            if (n2 + 1 != string.length()) {
                return false;
            }
            return string2.regionMatches(0, string, 0, n2 - 2);
        }
        return true;
    }

    private String normalizeArgTypeName(String string) {
        char c;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        string = string.trim();
        int n2 = string.length();
        boolean bl = string.endsWith("...");
        if (bl) {
            n2 -= 3;
        }
        while (n < n2 && !Character.isWhitespace(c = string.charAt(n)) && c != '[') {
            stringBuffer.append(c);
            ++n;
        }
        while (n < n2) {
            c = string.charAt(n);
            if (c == '[' || c == ']') {
                stringBuffer2.append(c);
            } else if (!Character.isWhitespace(c)) {
                throw new IllegalArgumentException(MessageOutput.format("Invalid argument type name"));
            }
            ++n;
        }
        string = stringBuffer.toString();
        if (string.indexOf(46) == -1 || string.startsWith("*.")) {
            try {
                ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
                if (referenceType != null) {
                    string = referenceType.name();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        string = string + stringBuffer2.toString();
        if (bl) {
            string = string + "...";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method findMatchingMethod(ReferenceType referenceType) throws AmbiguousMethodException, NoSuchMethodException {
        void var4_8;
        ArrayList<String> arrayList = null;
        if (this.methodArgs() != null) {
            arrayList = new ArrayList<String>(this.methodArgs().size());
            for (String string : this.methodArgs()) {
                String string2 = this.normalizeArgTypeName(string);
                arrayList.add(string2);
            }
        }
        Object object = null;
        Object var4_6 = null;
        int n = 0;
        for (Method method : referenceType.methods()) {
            if (!method.name().equals(this.methodName())) continue;
            if (++n == 1) {
                object = method;
            }
            if (arrayList == null || !this.compareArgTypes(method, arrayList)) continue;
            Method method2 = method;
            break;
        }
        Iterator<Object> iterator = null;
        if (var4_8 != null) {
            return var4_8;
        }
        if (arrayList != null) throw new NoSuchMethodException(this.methodName());
        if (n <= 0) throw new NoSuchMethodException(this.methodName());
        if (n != 1) throw new AmbiguousMethodException();
        return object;
    }
}

