/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.LineNotFoundException;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import java.util.List;

public class LineBreakpointSpec
extends BreakpointSpec {
    int lineNumber;

    LineBreakpointSpec(EventRequestSpecList eventRequestSpecList, ReferenceTypeSpec referenceTypeSpec, int n) {
        super(eventRequestSpecList, referenceTypeSpec);
        this.lineNumber = n;
    }

    void resolve(ReferenceType referenceType) throws InvalidTypeException, LineNotFoundException {
        if (!(referenceType instanceof ClassType)) {
            throw new InvalidTypeException();
        }
        Location location = this.location((ClassType)referenceType);
        this.setRequest(referenceType.virtualMachine().eventRequestManager().createBreakpointRequest(location));
    }

    private Location location(ClassType classType) throws LineNotFoundException {
        Location location = null;
        try {
            List<Location> list = classType.locationsOfLine(this.lineNumber());
            if (list.size() == 0) {
                throw new LineNotFoundException();
            }
            location = list.get(0);
            if (location.method() == null) {
                throw new LineNotFoundException();
            }
        }
        catch (AbsentInformationException absentInformationException) {
            throw new LineNotFoundException();
        }
        return location;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        return this.refSpec.hashCode() + this.lineNumber;
    }

    public boolean equals(Object object) {
        if (object instanceof LineBreakpointSpec) {
            LineBreakpointSpec lineBreakpointSpec = (LineBreakpointSpec)object;
            return this.refSpec.equals(lineBreakpointSpec.refSpec) && this.lineNumber == lineBreakpointSpec.lineNumber;
        }
        return false;
    }

    public String errorMessageFor(Exception exception) {
        if (exception instanceof LineNotFoundException) {
            return "No code at line " + this.lineNumber() + " in " + this.refSpec;
        }
        if (exception instanceof InvalidTypeException) {
            return "Breakpoints can be located only in classes. " + this.refSpec + " is an interface or array";
        }
        return super.errorMessageFor(exception);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("breakpoint ");
        stringBuffer.append(this.refSpec.toString());
        stringBuffer.append(':');
        stringBuffer.append(this.lineNumber);
        stringBuffer.append(" (");
        stringBuffer.append(this.getStatusString());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

