/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Utilities;

public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    static JTextComponent componentWithSelection;
    private static final long serialVersionUID = 4325555698756477346L;
    public static final int ALWAYS_UPDATE = 2;
    public static final int NEVER_UPDATE = 1;
    public static final int UPDATE_WHEN_ON_EDT = 0;
    int policy;
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    DocumentListener documentListener;
    PropertyChangeListener propertyChangeListener;
    JTextComponent textComponent;
    private boolean selectionVisible;
    private int blinkRate;
    private int dot;
    private int mark;
    private Point magicCaretPosition;
    boolean visible;
    boolean active;
    private Object highlightEntry;
    private Timer blinkTimer;
    private BlinkTimerListener blinkListener;
    NavigationFilter.FilterBypass bypass;

    private /* synthetic */ void finit$() {
        this.policy = 0;
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectionVisible = true;
        this.blinkRate = 500;
        this.dot = 0;
        this.mark = 0;
        this.magicCaretPosition = null;
        this.visible = false;
        this.active = true;
    }

    public DefaultCaret() {
        this.finit$();
    }

    private NavigationFilter.FilterBypass getBypass() {
        if (this.bypass == null) {
            this.bypass = new Bypass(this);
            return this.bypass;
        }
        return this.bypass;
    }

    public void setUpdatePolicy(int n) {
        if (n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException("policy must be ALWAYS_UPDATE, NEVER__UPDATE, or UPDATE_WHEN_ON_EDT");
        }
        this.policy = n;
    }

    public int getUpdatePolicy() {
        return this.policy;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (this.textComponent.isEnabled()) {
                this.moveCaret(mouseEvent);
            } else {
                this.positionCaret(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.textComponent.isEnabled()) {
            return;
        }
        int n = mouseEvent.getClickCount();
        if (mouseEvent.getButton() == 1 && n >= 2) {
            int n2 = this.getComponent().viewToModel(mouseEvent.getPoint());
            JTextComponent jTextComponent = this.getComponent();
            try {
                if (n == 3) {
                    this.setDot(Utilities.getRowStart(jTextComponent, n2));
                    this.moveDot(Utilities.getRowEnd(jTextComponent, n2));
                } else {
                    int n3 = Utilities.getWordStart(jTextComponent, n2);
                    if (n2 == n3) {
                        this.setDot(n3);
                        this.moveDot(Utilities.getWordEnd(jTextComponent, n3));
                    } else {
                        int n4 = Utilities.getNextWord(jTextComponent, n2);
                        int n5 = Utilities.getPreviousWord(jTextComponent, n2);
                        int n6 = Utilities.getWordEnd(jTextComponent, n5);
                        if (n2 >= n6 && n2 <= n4) {
                            this.setDot(n6);
                            this.moveDot(n4);
                        } else {
                            this.setDot(n5);
                            this.moveDot(n6);
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.isShiftDown() && this.getDot() != -1) {
                this.moveCaret(mouseEvent);
            } else {
                this.positionCaret(mouseEvent);
            }
            if (this.textComponent != null && this.textComponent.isEnabled() && this.textComponent.isRequestFocusEnabled()) {
                this.textComponent.requestFocus();
            }
        } else if (mouseEvent.getButton() == 2 && !mouseEvent.isShiftDown()) {
            this.positionCaret(mouseEvent);
            this.textComponent.paste();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.textComponent.isEditable()) {
            this.setVisible(true);
            this.updateTimerStatus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.textComponent.isEditable() && !focusEvent.isTemporary()) {
            this.setVisible(false);
            if (this.blinkTimer != null && this.blinkTimer.isRunning()) {
                this.blinkTimer.stop();
            }
        }
    }

    private void updateTimerStatus() {
        if (this.textComponent.isEnabled() && this.textComponent.isEditable()) {
            if (this.blinkTimer == null) {
                this.initBlinkTimer();
            }
            if (!this.blinkTimer.isRunning()) {
                this.blinkTimer.start();
            }
        } else if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        int n = this.getComponent().viewToModel(mouseEvent.getPoint());
        this.moveDot(n);
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        int n = this.getComponent().viewToModel(mouseEvent.getPoint());
        this.setDot(n);
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.textComponent.removeFocusListener(this);
        this.textComponent.removeMouseListener(this);
        this.textComponent.removeMouseMotionListener(this);
        this.textComponent.getDocument().removeDocumentListener(this.documentListener);
        this.documentListener = null;
        this.textComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.textComponent = null;
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
        this.blinkTimer = null;
    }

    public void install(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.textComponent.addFocusListener(this);
        this.textComponent.addMouseListener(this);
        this.textComponent.addMouseMotionListener(this);
        this.propertyChangeListener = new PropertyChangeHandler(this);
        this.textComponent.addPropertyChangeListener(this.propertyChangeListener);
        this.documentListener = new DocumentHandler(this);
        Document document = this.textComponent.getDocument();
        if (document != null) {
            document.addDocumentListener(this.documentListener);
        }
        this.active = this.textComponent.isEditable() && this.textComponent.isEnabled();
        this.repaint();
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public int getMark() {
        return this.mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (this.selectionVisible) {
            try {
                if (this.highlightEntry != null) {
                    highlighter.changeHighlight(this.highlightEntry, 0, 0);
                }
                if (componentWithSelection != this.textComponent) return;
                componentWithSelection = null;
                return;
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError();
            }
        } else {
            if (this.highlightEntry == null) return;
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    private void handleHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        int n = Math.min(this.dot, this.mark);
        int n2 = Math.max(this.dot, this.mark);
        if (this.selectionVisible) {
            try {
                if (this.highlightEntry == null) {
                    this.highlightEntry = highlighter.addHighlight(n, n2, this.getSelectionPainter());
                } else {
                    highlighter.changeHighlight(this.highlightEntry, n, n2);
                }
                if (componentWithSelection != null && componentWithSelection != this.textComponent) {
                    Caret caret = componentWithSelection.getCaret();
                    caret.setDot(caret.getDot());
                }
                componentWithSelection = this.textComponent;
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError();
            }
        } else if (this.highlightEntry != null) {
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    public void setSelectionVisible(boolean bl) {
        if (this.selectionVisible == bl) {
            return;
        }
        this.selectionVisible = bl;
        this.handleHighlight();
        this.repaint();
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    protected final void repaint() {
        this.getComponent().repaint(this.x, this.y, this.width, this.height);
    }

    public void paint(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        this.dot = Math.min(this.dot, this.textComponent.getDocument().getLength());
        this.dot = Math.max(this.dot, 0);
        Rectangle rectangle = null;
        try {
            rectangle = this.textComponent.modelToView(this.dot);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (rectangle == null) {
            return;
        }
        if (this.x != rectangle.x || this.y != rectangle.y) {
            this.repaint();
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = 1;
            this.height = rectangle.height;
        }
        if (this.visible && this.active) {
            graphics.setColor(this.textComponent.getCaretColor());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(DefaultCaret.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(DefaultCaret.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(DefaultCaret.class$("javax.swing.event.ChangeListener"));
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(this.changeEvent);
        }
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public int getBlinkRate() {
        return this.blinkRate;
    }

    public void setBlinkRate(int n) {
        if (this.blinkTimer != null) {
            this.blinkTimer.setDelay(n);
        }
        this.blinkRate = n;
    }

    public int getDot() {
        return this.dot;
    }

    public void moveDot(int n) {
        NavigationFilter navigationFilter = this.textComponent.getNavigationFilter();
        if (navigationFilter != null) {
            navigationFilter.moveDot(this.getBypass(), n, Position.Bias.Forward);
        } else {
            this.moveDotImpl(n);
        }
    }

    void moveDotImpl(int n) {
        if (n >= 0) {
            Document document = this.textComponent.getDocument();
            if (document != null) {
                this.dot = Math.min(n, document.getLength());
            }
            this.dot = Math.max(this.dot, 0);
            this.handleHighlight();
            this.appear();
            this.adjustVisibility(this);
        }
    }

    public void setDot(int n) {
        NavigationFilter navigationFilter = this.textComponent.getNavigationFilter();
        if (navigationFilter != null) {
            navigationFilter.setDot(this.getBypass(), n, Position.Bias.Forward);
        } else {
            this.setDotImpl(n);
        }
    }

    void setDotImpl(int n) {
        if (n >= 0) {
            Document document = this.textComponent.getDocument();
            if (document != null) {
                this.dot = Math.min(n, document.getLength());
            }
            this.mark = this.dot = Math.max(this.dot, 0);
            this.clearHighlight();
            this.appear();
            this.adjustVisibility(this);
        }
    }

    void appear() {
        if (this.blinkListener != null) {
            this.blinkListener.ignoreNextEvent = true;
            if (this.visible) {
                this.repaint();
            }
            this.visible = true;
            Rectangle rectangle = null;
            int n = this.getDot();
            try {
                rectangle = this.getComponent().modelToView(n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (rectangle != null) {
                this.damage(rectangle);
            }
        }
        this.repaint();
    }

    public boolean isActive() {
        if (this.blinkTimer != null) {
            return this.blinkTimer.isRunning();
        }
        return false;
    }

    public boolean isVisible() {
        return this.visible && this.active;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.updateTimerStatus();
            Rectangle rectangle = null;
            int n = this.getDot();
            try {
                rectangle = this.getComponent().modelToView(n);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)("Unexpected bad caret location: " + n));
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
            if (rectangle != null) {
                this.damage(rectangle);
            }
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected void damage(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = 1;
        if (this.height <= 0) {
            try {
                this.height = this.textComponent.modelToView((int)this.dot).height;
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError("Caret location not within document range.");
            }
        }
        this.repaint();
    }

    protected void adjustVisibility(Rectangle rectangle) {
        this.getComponent().scrollRectToVisible(rectangle);
    }

    private void initBlinkTimer() {
        this.blinkListener = new BlinkTimerListener(this);
        this.blinkTimer = new Timer(this.getBlinkRate(), this.blinkListener);
        this.blinkTimer.setRepeats(true);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ DefaultCaret this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("document")) {
                Document document;
                Document document2 = (Document)propertyChangeEvent.getOldValue();
                if (document2 != null) {
                    document2.removeDocumentListener(this.this$0.documentListener);
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.addDocumentListener(this.this$0.documentListener);
                }
            } else if (string.equals("editable")) {
                this.this$0.active = (Boolean)propertyChangeEvent.getNewValue() != false && this.this$0.textComponent.isEnabled();
            } else if (string.equals("enabled")) {
                this.this$0.active = (Boolean)propertyChangeEvent.getNewValue() != false && this.this$0.textComponent.isEditable();
            }
        }

        PropertyChangeHandler(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private /* synthetic */ DefaultCaret this$0;

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.this$0.policy == 2 || SwingUtilities.isEventDispatchThread() && this.this$0.policy == 0) {
                int n = this.this$0.getDot();
                this.this$0.setDot(n + documentEvent.getLength());
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.this$0.policy == 2 || SwingUtilities.isEventDispatchThread() && this.this$0.policy == 0) {
                int n = this.this$0.getDot();
                this.this$0.setDot(n - documentEvent.getLength());
            } else if (this.this$0.policy == 1 || !SwingUtilities.isEventDispatchThread() && this.this$0.policy == 0) {
                int n = documentEvent.getDocument().getLength();
                if (this.this$0.getDot() > n) {
                    this.this$0.setDot(n);
                }
            }
        }

        DocumentHandler(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }
    }

    private class BlinkTimerListener
    implements ActionListener {
        private /* synthetic */ DefaultCaret this$0;
        boolean ignoreNextEvent;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.ignoreNextEvent) {
                this.ignoreNextEvent = false;
            } else {
                this.this$0.visible ^= true;
                this.this$0.repaint();
            }
        }

        BlinkTimerListener(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }
    }

    class Bypass
    extends NavigationFilter.FilterBypass {
        private /* synthetic */ DefaultCaret this$0;

        public Caret getCaret() {
            return this.this$0;
        }

        public void moveDot(int n, Position.Bias bias) {
            this.this$0.moveDotImpl(n);
        }

        public void setDot(int n, Position.Bias bias) {
            this.this$0.setDotImpl(n);
        }

        Bypass(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }
    }
}

