/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URI
implements Comparable,
Serializable {
    static final long serialVersionUID = -6052424284110960213L;
    private static final String URI_REGEXP = "^(([^:/?#]+):)?((//([^/?#]*))?([^?#]*)(\\?([^#]*))?)?(#(.*))?";
    private static final String AUTHORITY_REGEXP = "(([^?#]*)@)?([^?#:]*)(:([0-9]*))?";
    private static final String RFC2396_DIGIT = "0123456789";
    private static final String RFC2396_LOWALPHA = "abcdefghijklmnopqrstuvwxyz";
    private static final String RFC2396_UPALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String RFC2396_ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String RFC2396_ALPHANUM = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String RFC3986_UNRESERVED = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~";
    private static final String RFC3986_SUBDELIMS = "!$&'()*+,;=";
    private static final String RFC3986_REG_NAME = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=%";
    private static final String RFC3986_PCHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%";
    private static final String RFC3986_SEGMENT = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%";
    private static final String RFC3986_PATH_SEGMENTS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%/";
    private static final String RFC3986_SSP = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%?/";
    private static final String RFC3986_HOST = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=%[]";
    private static final String RFC3986_USERINFO = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=%:";
    private static final int SCHEME_GROUP = 2;
    private static final int SCHEME_SPEC_PART_GROUP = 3;
    private static final int AUTHORITY_GROUP = 5;
    private static final int PATH_GROUP = 6;
    private static final int QUERY_GROUP = 8;
    private static final int FRAGMENT_GROUP = 10;
    private static final int AUTHORITY_USERINFO_GROUP = 2;
    private static final int AUTHORITY_HOST_GROUP = 3;
    private static final int AUTHORITY_PORT_GROUP = 5;
    private static final Pattern URI_PATTERN;
    private static final Pattern AUTHORITY_PATTERN;
    private static final String HEX = "0123456789ABCDEF";
    private transient String scheme;
    private transient String rawSchemeSpecificPart;
    private transient String schemeSpecificPart;
    private transient String rawAuthority;
    private transient String authority;
    private transient String rawUserInfo;
    private transient String userInfo;
    private transient String rawHost;
    private transient String host;
    private transient int port;
    private transient String rawPath;
    private transient String path;
    private transient String rawQuery;
    private transient String query;
    private transient String rawFragment;
    private transient String fragment;
    private String string;

    private /* synthetic */ void finit$() {
        this.port = -1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.string = (String)objectInputStream.readObject();
        try {
            this.parseURI(this.string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.string == null) {
            this.string = this.toString();
        }
        objectOutputStream.writeObject(this.string);
    }

    private static String getURIGroup(Matcher matcher, int n) {
        String string = matcher.group(n);
        if (string == null || string.length() == 0) {
            String string2 = matcher.group(n - 1);
            if (string2 == null || string2.length() == 0) {
                return null;
            }
            return "";
        }
        return string;
    }

    private void parseURI(String string) throws URISyntaxException {
        Matcher matcher = URI_PATTERN.matcher(string);
        if (matcher.matches()) {
            this.scheme = URI.getURIGroup(matcher, 2);
            this.rawSchemeSpecificPart = matcher.group(3);
            this.schemeSpecificPart = URI.unquote(this.rawSchemeSpecificPart);
            if (!this.isOpaque()) {
                this.rawAuthority = URI.getURIGroup(matcher, 5);
                this.rawPath = matcher.group(6);
                this.rawQuery = URI.getURIGroup(matcher, 8);
            }
        } else {
            throw new URISyntaxException(string, "doesn't match URI regular expression");
        }
        this.rawFragment = URI.getURIGroup(matcher, 10);
        this.parseServerAuthority();
        this.authority = URI.unquote(this.rawAuthority);
        this.userInfo = URI.unquote(this.rawUserInfo);
        this.host = URI.unquote(this.rawHost);
        this.path = URI.unquote(this.rawPath);
        this.query = URI.unquote(this.rawQuery);
        this.fragment = URI.unquote(this.rawFragment);
    }

    private static String unquote(String string) throws URISyntaxException {
        if (string == null) {
            return null;
        }
        byte[] byArray = new byte[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                int n2;
                if (i + 2 >= string.length()) {
                    throw new URISyntaxException(string, "Invalid quoted character");
                }
                int n3 = Character.digit(string.charAt(++i), 16);
                if ((n2 = Character.digit(string.charAt(++i), 16)) < 0 || n3 < 0) {
                    throw new URISyntaxException(string, "Invalid quoted character");
                }
                byArray[n++] = (byte)(n3 * 16) + (byte)n2;
                continue;
            }
            byArray[n++] = (byte)c;
        }
        try {
            return new String(byArray, 0, n, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (Error)new InternalError().initCause(unsupportedEncodingException);
        }
    }

    private static String quote(String string) {
        return URI.quote(string, RFC3986_SSP);
    }

    private static String quoteAuthority(String string) {
        return URI.quote(string, RFC3986_REG_NAME);
    }

    private static String quote(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) == -1 && c <= '\u007f') {
                stringBuffer.append('%');
                stringBuffer.append(HEX.charAt(c / 16));
                stringBuffer.append(HEX.charAt(c & 0xF));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String quoteHost(String string) {
        return URI.quote(string, RFC3986_HOST);
    }

    private static String quotePath(String string) {
        return URI.quote(string, RFC3986_PATH_SEGMENTS);
    }

    private static String quoteUserInfo(String string) {
        return URI.quote(string, RFC3986_USERINFO);
    }

    public URI(String string) throws URISyntaxException {
        this.finit$();
        this.string = string;
        this.parseURI(string);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws URISyntaxException {
        this((string == null ? "" : string + ":") + (string2 == null && string3 == null && n == -1 ? "" : "//") + (string2 == null ? "" : URI.quoteUserInfo(string2) + "@") + (string3 == null ? "" : URI.quoteHost(string3)) + (n == -1 ? "" : ":" + String.valueOf(n)) + (string4 == null ? "" : URI.quotePath(string4)) + (string5 == null ? "" : "?" + URI.quote(string5)) + (string6 == null ? "" : "#" + URI.quote(string6)));
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        this((string == null ? "" : string + ":") + (string2 == null ? "" : "//" + URI.quoteAuthority(string2)) + (string3 == null ? "" : URI.quotePath(string3)) + (string4 == null ? "" : "?" + URI.quote(string4)) + (string5 == null ? "" : "#" + URI.quote(string5)));
    }

    public URI(String string, String string2, String string3, String string4) throws URISyntaxException {
        this(string, null, string2, -1, string3, null, string4);
    }

    public URI(String string, String string2, String string3) throws URISyntaxException {
        this((string == null ? "" : string + ":") + (string2 == null ? "" : URI.quote(string2)) + (string3 == null ? "" : "#" + URI.quote(string3)));
    }

    public static URI create(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(uRISyntaxException);
        }
    }

    public URI parseServerAuthority() throws URISyntaxException {
        if (this.rawAuthority != null) {
            Matcher matcher = AUTHORITY_PATTERN.matcher(this.rawAuthority);
            if (matcher.matches()) {
                this.rawUserInfo = URI.getURIGroup(matcher, 2);
                this.rawHost = URI.getURIGroup(matcher, 3);
                String string = URI.getURIGroup(matcher, 5);
                if (string != null) {
                    try {
                        this.port = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        URISyntaxException uRISyntaxException = new URISyntaxException(this.string, "doesn't match URI regular expression");
                        uRISyntaxException.initCause(numberFormatException);
                        throw uRISyntaxException;
                    }
                }
            } else {
                throw new URISyntaxException(this.string, "doesn't match URI regular expression");
            }
        }
        return this;
    }

    public URI normalize() {
        if (this.isOpaque() || this.path.indexOf("/./") == -1 && this.path.indexOf("/../") == -1) {
            return this;
        }
        try {
            return new URI(this.scheme, this.authority, this.normalizePath(this.path), this.query, this.fragment);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Error)new InternalError("Normalized URI variant could not be constructed").initCause(uRISyntaxException);
        }
    }

    private String normalizePath(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.indexOf("../", n) == n) {
                n += 3;
                continue;
            }
            if (stringBuffer.indexOf("./", n) == n) {
                n += 2;
                continue;
            }
            if (stringBuffer.indexOf("/./", n) == n) {
                n += 2;
                continue;
            }
            if (stringBuffer.indexOf("/.", n) == n && stringBuffer.charAt(n + 2) != '.') {
                stringBuffer.setCharAt(++n, '/');
                continue;
            }
            if (stringBuffer.indexOf("/../", n) == n) {
                n += 3;
                this.removeLastSegment(stringBuffer2);
                continue;
            }
            if (stringBuffer.indexOf("/..", n) == n) {
                stringBuffer.setCharAt(n += 2, '/');
                this.removeLastSegment(stringBuffer2);
                continue;
            }
            if (n == stringBuffer.length() - 1 && stringBuffer.indexOf(".", n) == n) {
                stringBuffer.delete(0, 1);
                continue;
            }
            if (n == stringBuffer.length() - 2 && stringBuffer.indexOf("..", n) == n) {
                stringBuffer.delete(0, 2);
                continue;
            }
            int n2 = stringBuffer.indexOf("/", n);
            while (n2 == n) {
                stringBuffer2.append("/");
                n2 = stringBuffer.indexOf("/", ++n);
            }
            if (n2 == -1) {
                n2 = stringBuffer.length();
            }
            stringBuffer2.append(stringBuffer.substring(n, n2));
            n = n2;
        }
        return stringBuffer2.toString();
    }

    private void removeLastSegment(StringBuffer stringBuffer) {
        int n = stringBuffer.lastIndexOf("/");
        if (n == -1) {
            stringBuffer.setLength(0);
        } else {
            stringBuffer.setLength(n);
        }
    }

    public URI resolve(URI uRI) {
        if (uRI.isAbsolute()) {
            return uRI;
        }
        if (uRI.isOpaque()) {
            return uRI;
        }
        String string = uRI.getScheme();
        String string2 = uRI.getSchemeSpecificPart();
        String string3 = uRI.getAuthority();
        String string4 = uRI.getPath();
        String string5 = uRI.getQuery();
        String string6 = uRI.getFragment();
        try {
            if (string6 != null && string4 != null && string4.equals("") && string == null && string3 == null && string5 == null) {
                return new URI(this.scheme, this.schemeSpecificPart, string6);
            }
            if (string3 == null) {
                string3 = this.authority;
                if (string4 == null) {
                    string4 = "";
                }
                if (!string4.startsWith("/")) {
                    StringBuffer stringBuffer = new StringBuffer(this.path);
                    int n = this.path.lastIndexOf(47);
                    if (n >= 0) {
                        stringBuffer.delete(n + 1, stringBuffer.length());
                    }
                    stringBuffer.append(string4);
                    string4 = this.normalizePath(stringBuffer.toString());
                }
            }
            return new URI(this.scheme, string3, string4, string5, string6);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Error)new InternalError("Resolved URI variant could not be constructed").initCause(uRISyntaxException);
        }
    }

    public URI resolve(String string) throws IllegalArgumentException {
        return this.resolve(URI.create(string));
    }

    public URI relativize(URI uRI) {
        if (this.isOpaque() || uRI.isOpaque()) {
            return uRI;
        }
        if (this.scheme == null && uRI.getScheme() != null) {
            return uRI;
        }
        if (this.scheme != null && !this.scheme.equals(uRI.getScheme())) {
            return uRI;
        }
        if (this.rawAuthority == null && uRI.getRawAuthority() != null) {
            return uRI;
        }
        if (this.rawAuthority != null && !this.rawAuthority.equals(uRI.getRawAuthority())) {
            return uRI;
        }
        if (!uRI.getRawPath().startsWith(this.rawPath)) {
            return uRI;
        }
        try {
            return new URI(null, null, uRI.getRawPath().substring(this.rawPath.length()), uRI.getRawQuery(), uRI.getRawFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Error)new InternalError("Relativized URI variant could not be constructed").initCause(uRISyntaxException);
        }
    }

    public URL toURL() throws IllegalArgumentException, MalformedURLException {
        if (this.isAbsolute()) {
            return new URL(this.toString());
        }
        throw new IllegalArgumentException("not absolute");
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.scheme != null && !this.schemeSpecificPart.startsWith("/");
    }

    public String getRawSchemeSpecificPart() {
        return this.rawSchemeSpecificPart;
    }

    public String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public String getRawAuthority() {
        return this.rawAuthority;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getRawUserInfo() {
        return this.rawUserInfo;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getRawQuery() {
        return this.rawQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRawFragment() {
        return this.rawFragment;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean equals(Object object) {
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        if (this.scheme == null ? uRI.getScheme() != null : !this.scheme.equalsIgnoreCase(uRI.getScheme())) {
            return false;
        }
        if (this.rawFragment == null ? uRI.getRawFragment() != null : !this.rawFragment.equalsIgnoreCase(uRI.getRawFragment())) {
            return false;
        }
        boolean bl = this.isOpaque();
        boolean bl2 = uRI.isOpaque();
        if (bl && bl2) {
            return this.rawSchemeSpecificPart.equals(uRI.getRawSchemeSpecificPart());
        }
        if (!bl && !bl2) {
            boolean bl3;
            boolean bl4 = bl3 = this.rawPath.equalsIgnoreCase(uRI.getRawPath()) && (this.rawQuery == null && uRI.getRawQuery() == null || this.rawQuery.equalsIgnoreCase(uRI.getRawQuery()));
            if (this.rawAuthority == null && uRI.getRawAuthority() == null) {
                return bl3;
            }
            if (this.host == null) {
                return bl3 && this.rawAuthority.equalsIgnoreCase(uRI.getRawAuthority());
            }
            return bl3 && this.host.equalsIgnoreCase(uRI.getHost()) && this.port == uRI.getPort() && (this.rawUserInfo == null ? uRI.getRawUserInfo() == null : this.rawUserInfo.equalsIgnoreCase(uRI.getRawUserInfo()));
        }
        return false;
    }

    public int hashCode() {
        return (this.getScheme() == null ? 0 : 13 * this.getScheme().hashCode()) + 17 * this.getRawSchemeSpecificPart().hashCode() + (this.getRawFragment() == null ? 0 : 21 + this.getRawFragment().hashCode());
    }

    public int compareTo(Object object) throws ClassCastException {
        int n;
        int n2;
        URI uRI = (URI)object;
        if (this.scheme == null && uRI.getScheme() != null) {
            return -1;
        }
        if (this.scheme != null && (n2 = this.scheme.compareToIgnoreCase(uRI.getScheme())) != 0) {
            return n2;
        }
        n2 = this.isOpaque();
        boolean bl = uRI.isOpaque();
        if (n2 != 0 && !bl) {
            return 1;
        }
        if (n2 == 0 && bl) {
            return -1;
        }
        if (n2 != 0) {
            int n3 = this.rawSchemeSpecificPart.compareTo(uRI.getRawSchemeSpecificPart());
            if (n3 == 0) {
                return this.compareFragments(uRI);
            }
            return n3;
        }
        if (this.rawAuthority == null && uRI.getRawAuthority() != null) {
            return -1;
        }
        if (this.rawAuthority != null && (n = this.rawAuthority.compareTo(uRI.getRawAuthority())) != 0) {
            if (this.host == null) {
                return n;
            }
            if (this.rawUserInfo == null && uRI.getRawUserInfo() != null) {
                return -1;
            }
            int n4 = this.rawUserInfo.compareTo(uRI.getRawUserInfo());
            if (n4 != 0) {
                return n4;
            }
            if (this.host == null && uRI.getHost() != null) {
                return -1;
            }
            int n5 = this.host.compareTo(uRI.getHost());
            if (n5 != 0) {
                return n5;
            }
            return new Integer(this.port).compareTo(new Integer(uRI.getPort()));
        }
        if (this.rawPath == null && uRI.getRawPath() != null) {
            return -1;
        }
        if (this.rawPath != null && (n = this.rawPath.compareTo(uRI.getRawPath())) != 0) {
            return n;
        }
        if (this.rawQuery == null && uRI.getRawQuery() != null) {
            return -1;
        }
        if (this.rawQuery != null && (n = this.rawQuery.compareTo(uRI.getRawQuery())) != 0) {
            return n;
        }
        return this.compareFragments(uRI);
    }

    private int compareFragments(URI uRI) {
        if (this.rawFragment == null && uRI.getRawFragment() != null) {
            return -1;
        }
        if (this.rawFragment == null) {
            return 0;
        }
        return this.rawFragment.compareTo(uRI.getRawFragment());
    }

    public String toString() {
        return (this.scheme == null ? "" : this.scheme + ":") + this.rawSchemeSpecificPart + (this.rawFragment == null ? "" : "#" + this.rawFragment);
    }

    public String toASCIIString() {
        String string = this.toString();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                if (bl) {
                    stringBuffer.append(URI.escapeCharacters(stringBuffer2.toString()));
                    bl = false;
                }
                stringBuffer.append(c);
                continue;
            }
            if (!bl) {
                stringBuffer2 = new StringBuffer();
                bl = true;
            }
            stringBuffer2.append(c);
        }
        return stringBuffer.toString();
    }

    private static String escapeCharacters(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = string.getBytes("utf-8");
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append('%');
                stringBuffer.append(HEX.charAt((byArray[i] & 0xFF) / 16));
                stringBuffer.append(HEX.charAt(byArray[i] & 0xF));
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (Error)new InternalError("Escaping error").initCause(unsupportedEncodingException);
        }
    }

    static {
        URI_REGEXP = URI_REGEXP;
        AUTHORITY_REGEXP = AUTHORITY_REGEXP;
        RFC2396_DIGIT = RFC2396_DIGIT;
        RFC2396_LOWALPHA = RFC2396_LOWALPHA;
        RFC2396_UPALPHA = RFC2396_UPALPHA;
        RFC2396_ALPHA = RFC2396_ALPHA;
        RFC2396_ALPHANUM = RFC2396_ALPHANUM;
        RFC3986_UNRESERVED = RFC3986_UNRESERVED;
        RFC3986_SUBDELIMS = RFC3986_SUBDELIMS;
        RFC3986_REG_NAME = RFC3986_REG_NAME;
        RFC3986_PCHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%";
        RFC3986_SEGMENT = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%";
        RFC3986_PATH_SEGMENTS = RFC3986_PATH_SEGMENTS;
        RFC3986_SSP = RFC3986_SSP;
        RFC3986_HOST = RFC3986_HOST;
        RFC3986_USERINFO = RFC3986_USERINFO;
        HEX = HEX;
        URI_PATTERN = Pattern.compile(URI_REGEXP);
        AUTHORITY_PATTERN = Pattern.compile(AUTHORITY_REGEXP);
    }
}

