/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;
    private byte[] buf;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += n2;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n & 0xFF);
    }

    public final synchronized void writeShort(int n) throws IOException {
        this.write((byte)(n >> 8));
        this.write((byte)n);
    }

    public final synchronized void writeChar(int n) throws IOException {
        this.write((byte)(n >> 8));
        this.write((byte)n);
    }

    public final synchronized void writeInt(int n) throws IOException {
        this.write((byte)(n >> 24));
        this.write((byte)(n >> 16));
        this.write((byte)(n >> 8));
        this.write((byte)n);
    }

    public final synchronized void writeLong(long l) throws IOException {
        this.write((byte)(l >> 56));
        this.write((byte)(l >> 48));
        this.write((byte)(l >> 40));
        this.write((byte)(l >> 32));
        this.write((byte)(l >> 24));
        this.write((byte)(l >> 16));
        this.write((byte)(l >> 8));
        this.write((byte)l);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    private int getUTFlength(String string, int n, int n2) throws IOException {
        int n3 = string.length();
        for (int i = n; i < n3 && n2 <= 65535; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                n2 += 2;
                continue;
            }
            n2 += 3;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        return n2;
    }

    public final synchronized void writeUTF(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (this.buf == null) {
            this.buf = new byte[512];
        }
        while (true) {
            if (n2 < n && n3 < this.buf.length - 3) {
                char c;
                if ((c = string.charAt(n2++)) >= '\u0001' && c <= '\u007f') {
                    this.buf[n3++] = (byte)c;
                    continue;
                }
                if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                    this.buf[n3++] = (byte)(c >> 6) & 0x1F | 0xFFFFFFC0;
                    this.buf[n3++] = (byte)c & 0x3F | 0xFFFFFF80;
                    continue;
                }
                this.buf[n3++] = (byte)(c >> 12) & 0xF | 0xFFFFFFE0;
                this.buf[n3++] = (byte)(c >> 6) & 0x3F | 0xFFFFFF80;
                this.buf[n3++] = (byte)c & 0x3F | 0xFFFFFF80;
                continue;
            }
            if (!bl) {
                if (n2 == n) {
                    this.writeShort(n3);
                } else {
                    this.writeShort(this.getUTFlength(string, n2, n3));
                }
                bl = true;
            }
            this.write(this.buf, 0, n3);
            n3 = 0;
            if (n2 >= n) break;
        }
    }
}

