/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;

public final class ImageGraphicAttribute
extends GraphicAttribute {
    private Image image;
    private float originX;
    private float originY;

    public ImageGraphicAttribute(Image image, int n) {
        this(image, n, 0.0f, 0.0f);
    }

    public ImageGraphicAttribute(Image image, int n, float f, float f2) {
        super(n);
        this.image = image;
        this.originX = f;
        this.originY = f2;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        graphics2D.drawImage(this.image, (int)(f - this.originX), (int)(f2 - this.originY), null);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageGraphicAttribute)) {
            return false;
        }
        return this.equals((ImageGraphicAttribute)object);
    }

    public boolean equals(ImageGraphicAttribute imageGraphicAttribute) {
        return this == imageGraphicAttribute || this.getAscent() == imageGraphicAttribute.getAscent() && this.getAdvance() == imageGraphicAttribute.getAdvance() && this.getAlignment() == imageGraphicAttribute.getAlignment() && this.getBounds().equals(imageGraphicAttribute.getBounds()) && this.getDescent() == imageGraphicAttribute.getDescent() && this.hashCode() == imageGraphicAttribute.hashCode() && this.image.equals(imageGraphicAttribute.image) && this.originX == imageGraphicAttribute.originX && this.originY == imageGraphicAttribute.originY;
    }

    public float getAdvance() {
        return Math.max(0.0f, (float)this.image.getWidth(null) - this.originX);
    }

    public float getAscent() {
        return Math.max(0.0f, this.originY);
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Float(-this.originX, -this.originY, this.image.getWidth(null), this.image.getHeight(null));
    }

    public float getDescent() {
        return Math.max(0.0f, (float)this.image.getHeight(null) - this.originY);
    }

    public int hashCode() {
        return this.image.hashCode();
    }
}

