/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.Registry;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import gnu.java.security.util.Util;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.MeteredInputStream;
import gnu.javax.crypto.keyring.PasswordProtectedEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.mac.MacInputStream;
import gnu.javax.crypto.mac.MacOutputStream;
import gnu.javax.crypto.prng.PRNGFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public final class PasswordAuthenticatedEntry
extends MaskableEnvelopeEntry
implements PasswordProtectedEntry,
Registry {
    private static final Logger log = Logger.getLogger(PasswordAuthenticatedEntry.class$("gnu.javax.crypto.keyring.PasswordAuthenticatedEntry").getName());
    public static final int TYPE = 3;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PasswordAuthenticatedEntry(String string, int n, Properties properties) {
        super(3, properties);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("no MAC specified");
        }
        this.properties.put("mac", string);
        this.properties.put("maclen", String.valueOf(n));
        this.setMasked(false);
    }

    private PasswordAuthenticatedEntry() {
        super(3);
        this.setMasked(true);
    }

    public static PasswordAuthenticatedEntry decode(DataInputStream dataInputStream, char[] cArray) throws IOException {
        PasswordAuthenticatedEntry passwordAuthenticatedEntry = new PasswordAuthenticatedEntry();
        passwordAuthenticatedEntry.properties.decode(dataInputStream);
        IMac iMac = passwordAuthenticatedEntry.getMac(cArray);
        int n = dataInputStream.readInt() - iMac.macSize();
        MeteredInputStream meteredInputStream = new MeteredInputStream(dataInputStream, n);
        MacInputStream macInputStream = new MacInputStream(meteredInputStream, iMac);
        DataInputStream dataInputStream2 = new DataInputStream(macInputStream);
        passwordAuthenticatedEntry.setMasked(false);
        passwordAuthenticatedEntry.decodeEnvelope(dataInputStream2);
        byte[] byArray = new byte[iMac.macSize()];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, iMac.digest())) {
            throw new MalformedKeyringException("MAC verification failed");
        }
        return passwordAuthenticatedEntry;
    }

    public static PasswordAuthenticatedEntry decode(DataInputStream dataInputStream) throws IOException {
        PasswordAuthenticatedEntry passwordAuthenticatedEntry = new PasswordAuthenticatedEntry();
        passwordAuthenticatedEntry.defaultDecode(dataInputStream);
        if (!passwordAuthenticatedEntry.properties.containsKey("mac")) {
            throw new MalformedKeyringException("no MAC");
        }
        if (!passwordAuthenticatedEntry.properties.containsKey("maclen")) {
            throw new MalformedKeyringException("no MAC length");
        }
        if (!passwordAuthenticatedEntry.properties.containsKey("salt")) {
            throw new MalformedKeyringException("no salt");
        }
        return passwordAuthenticatedEntry;
    }

    public void verify(char[] cArray) {
        block5: {
            if (!this.isMasked() || this.payload == null) break block5;
            long l = -System.currentTimeMillis();
            IMac iMac = null;
            try {
                iMac = this.getMac(cArray);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.toString(), exception);
            }
            int n = this.payload.length - iMac.macSize();
            iMac.update(this.payload, 0, n);
            byte[] byArray = new byte[iMac.macSize()];
            System.arraycopy(this.payload, this.payload.length - byArray.length, byArray, 0, byArray.length);
            if (!Arrays.equals(byArray, iMac.digest())) {
                throw new IllegalArgumentException("MAC verification failed");
            }
            this.setMasked(false);
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.payload, 0, n);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.decodeEnvelope(dataInputStream);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("malformed keyring fragment");
            }
            l += System.currentTimeMillis();
        }
    }

    public void authenticate(char[] cArray) throws IOException {
        long l = -System.currentTimeMillis();
        long l2 = -System.currentTimeMillis();
        if (this.isMasked()) {
            throw new IllegalStateException("entry is masked");
        }
        byte[] byArray = new byte[8];
        PRNG.getInstance().nextBytes(byArray);
        l2 += System.currentTimeMillis();
        this.properties.put("salt", Util.toString(byArray));
        IMac iMac = this.getMac(cArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        MacOutputStream macOutputStream = new MacOutputStream(byteArrayOutputStream, iMac);
        DataOutputStream dataOutputStream = new DataOutputStream(macOutputStream);
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            l2 = -System.currentTimeMillis();
            entry.encode(dataOutputStream);
            l2 += System.currentTimeMillis();
        }
        byteArrayOutputStream.write(iMac.digest());
        this.payload = byteArrayOutputStream.toByteArray();
        this.setMasked(true);
        l += System.currentTimeMillis();
    }

    public void encode(DataOutputStream dataOutputStream, char[] cArray) throws IOException {
        this.authenticate(cArray);
        this.encode(dataOutputStream);
    }

    protected void encodePayload(DataOutputStream dataOutputStream) throws IOException {
        if (this.payload == null) {
            log.fine("Null payload: " + this);
            throw new IllegalStateException("mac not computed");
        }
    }

    private IMac getMac(char[] cArray) throws MalformedKeyringException {
        int n;
        String string = this.properties.get("salt");
        if (string == null) {
            throw new MalformedKeyringException("no salt");
        }
        byte[] byArray = Util.toBytesFromString(string);
        String string2 = this.properties.get("mac");
        IMac iMac = MacFactory.getInstance(string2);
        if (iMac == null) {
            throw new MalformedKeyringException("no such mac: " + string2);
        }
        String string3 = this.properties.get("maclen");
        if (string3 == null) {
            throw new MalformedKeyringException("no MAC length");
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedKeyringException("bad MAC length");
        }
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.pbe.password", cArray);
        hashMap.put("gnu.crypto.pbe.salt", byArray);
        hashMap.put("gnu.crypto.pbe.iteration.count", PasswordProtectedEntry.ITERATION_COUNT);
        IRandom iRandom = PRNGFactory.getInstance("PBKDF2-HMAC-SHA");
        iRandom.init(hashMap);
        int n2 = iMac.macSize();
        byte[] byArray2 = new byte[n2];
        try {
            iRandom.nextBytes(byArray2, 0, n2);
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(limitReachedException.toString());
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.put("gnu.crypto.mac.key.material", byArray2);
        hashMap2.put("gnu.crypto.mac.truncated.size", n);
        try {
            iMac.init(hashMap2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Error(invalidKeyException.toString());
        }
        return iMac;
    }
}

