/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.UMacGenerator;
import java.security.SecureRandomSpi;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;

public class UMacRandomSpi
extends SecureRandomSpi {
    private static final Logger log = Logger.getLogger(UMacRandomSpi.class$("gnu.javax.crypto.jce.prng.UMacRandomSpi").getName());
    private static final UMacGenerator prng = new UMacGenerator();
    private static final String MSG = "Exception while setting up a umac-kdf SPI: ";
    private static final String RETRY = "Retry...";
    private UMacGenerator adaptee;

    private /* synthetic */ void finit$() {
        this.adaptee = new UMacGenerator();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static void resetLocalPRNG() {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.prng.umac.cipher.name", "aes");
        byte[] byArray = new byte[16];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(byArray);
        hashMap.put("gnu.crypto.cipher.key.material", byArray);
        int n = random.nextInt() & 0xFF;
        hashMap.put("gnu.crypto.prng.umac.index", n);
        prng.setup(hashMap);
    }

    public byte[] engineGenerateSeed(int n) {
        if (n < 1) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    public void engineNextBytes(byte[] byArray) {
        if (!this.adaptee.isInitialised()) {
            this.engineSetSeed(new byte[0]);
        }
        while (true) {
            try {
                this.adaptee.nextBytes(byArray, 0, byArray.length);
            }
            catch (LimitReachedException limitReachedException) {
                UMacRandomSpi.resetLocalPRNG();
                continue;
            }
            break;
        }
    }

    public void engineSetSeed(byte[] byArray) {
        int n = 0;
        n += 16;
        byte[] byArray2 = new byte[++n];
        int n2 = 0;
        int n3 = byArray2.length;
        if (byArray.length > 0) {
            int n4 = Math.min(n, byArray.length);
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            n2 += n4;
            n3 -= n4;
        }
        if (n2 > 0) {
            while (true) {
                try {
                    prng.nextBytes(byArray2, n2, n3);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new InternalError(MSG + String.valueOf(illegalStateException));
                }
                catch (LimitReachedException limitReachedException) {
                    continue;
                }
                break;
            }
        }
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.prng.umac.cipher.name", "aes");
        byte[] byArray3 = new byte[16];
        System.arraycopy(byArray2, 0, byArray3, 0, 16);
        hashMap.put("gnu.crypto.cipher.key.material", byArray3);
        hashMap.put("gnu.crypto.prng.umac.index", byArray2[16] & 0xFF);
        this.adaptee.init(hashMap);
    }

    public UMacRandomSpi() {
        this.finit$();
    }

    static {
        UMacRandomSpi.resetLocalPRNG();
        MSG = MSG;
        RETRY = RETRY;
    }
}

