/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.reflect.GenericSignatureParser;
import gnu.java.lang.reflect.TypeImpl;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Type;

public final class FieldSignatureParser
extends GenericSignatureParser {
    private Type type;

    public FieldSignatureParser(Class clazz, String string) {
        super(clazz, clazz.getClassLoader(), string);
        switch (this.peekChar()) {
            case 'L': 
            case 'T': 
            case '[': {
                this.type = this.readFieldTypeSignature();
                break;
            }
            case 'Z': {
                this.consume('Z');
                this.type = Boolean.TYPE;
                break;
            }
            case 'B': {
                this.consume('B');
                this.type = Byte.TYPE;
                break;
            }
            case 'S': {
                this.consume('S');
                this.type = Short.TYPE;
                break;
            }
            case 'C': {
                this.consume('C');
                this.type = Character.TYPE;
                break;
            }
            case 'I': {
                this.consume('I');
                this.type = Integer.TYPE;
                break;
            }
            case 'F': {
                this.consume('F');
                this.type = Float.TYPE;
                break;
            }
            case 'J': {
                this.consume('J');
                this.type = Long.TYPE;
                break;
            }
            case 'D': {
                this.consume('D');
                this.type = Double.TYPE;
                break;
            }
            default: {
                throw new GenericSignatureFormatError();
            }
        }
        this.end();
    }

    public Type getFieldType() {
        this.type = TypeImpl.resolve(this.type);
        return this.type;
    }
}

