/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.wsil.Link;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIRegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.CategoryModel;
import org.eclipse.wst.ws.internal.explorer.platform.util.URLUtils;

public class FavoritesUDDIRegistryFolderElement
extends FavoritesFolderElement {
    public FavoritesUDDIRegistryFolderElement(String name, Model model, NodeManager nodeManager) {
        super(name, model, nodeManager);
    }

    public void init(FavoritesMainElement favMainElement) {
        Link[] links = favMainElement.loadUDDIRegistries();
        int i = 0;
        while (i < links.length) {
            Link link = links[i];
            FavoritesUDDIRegistryElement favUDDIRegsitryElement = new FavoritesUDDIRegistryElement(link.getAbstracts()[0].getText(), this.getModel(), link);
            this.connect((Element)favUDDIRegsitryElement, "relUDDIRegistryNode", "owner");
            ++i;
        }
    }

    public boolean addFavorite(Hashtable table) {
        String registryName = (String)table.get("UDDIRegistryName");
        String inquiryAPI = (String)table.get("UDDIRegistryInquiryAPI");
        String publishAPI = (String)table.get("UDDIRegistryPublishAPI");
        String registrationURL = (String)table.get("UDDIRegistryRegistrationURL");
        Enumeration userDefinedCategories = (Enumeration)table.get("UDDIRegistryCategoriesEnum");
        if (userDefinedCategories != null) {
            String pluginMetadataDirectory = (String)table.get("pluginMetadataDirectory");
            StringBuffer directoryBuffer = new StringBuffer();
            FavoritesUDDIRegistryFolderElement.formCategoriesDirectory(directoryBuffer, pluginMetadataDirectory, registryName);
            File categoriesDirectoryFile = new File(directoryBuffer.toString());
            categoriesDirectoryFile.mkdirs();
            StringBuffer categoryFileName = new StringBuffer();
            while (userDefinedCategories.hasMoreElements()) {
                File categoryFile;
                CategoryModel categoryModel = (CategoryModel)((Object)userDefinedCategories.nextElement());
                categoryFileName.setLength(0);
                String encodedCategoryKey = URLUtils.encode(categoryModel.getCategoryKey());
                categoryFileName.append(categoriesDirectoryFile.getAbsolutePath()).append(File.separatorChar).append(encodedCategoryKey).append(".txt");
                byte rc = categoryModel.saveData(categoryFileName.toString());
                if (rc == 0 || !(categoryFile = new File(categoryFileName.toString())).exists()) continue;
                categoryFile.delete();
            }
            this.cleanupCategoryDirectories(categoriesDirectoryFile);
        }
        if (registryName == null || inquiryAPI == null || publishAPI == null) {
            return false;
        }
        FavoritesUDDIRegistryElement e = this.getFavorite(registryName);
        if (e != null) {
            this.removeFavorite(e);
        }
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Link link = favMainElement.addUDDIRegistry(registryName, inquiryAPI, publishAPI, registrationURL);
        boolean saved = favMainElement.saveFavorites();
        if (saved) {
            FavoritesUDDIRegistryElement favUDDIRegsitryElement = new FavoritesUDDIRegistryElement(registryName, this.getModel(), link);
            this.connect((Element)favUDDIRegsitryElement, "relUDDIRegistryNode", "owner");
        }
        return saved;
    }

    public static final void formCategoriesDirectory(StringBuffer categoriesDirectory, String pluginMetadataDirectory, String registryName) {
        String encodedRegistryName = URLUtils.encode(registryName);
        categoriesDirectory.append(pluginMetadataDirectory).append("uddi").append(File.separatorChar).append(encodedRegistryName).append(File.separatorChar).append("categories");
    }

    private final void clearRegistryMetadata(String pluginMetadataDirectory, String registryName) {
        StringBuffer categoriesDirectory = new StringBuffer();
        FavoritesUDDIRegistryFolderElement.formCategoriesDirectory(categoriesDirectory, pluginMetadataDirectory, registryName);
        File categoriesDirectoryFile = new File(categoriesDirectory.toString());
        File[] categoryFiles = categoriesDirectoryFile.listFiles();
        if (categoryFiles != null) {
            int i = 0;
            while (i < categoryFiles.length) {
                categoryFiles[i].delete();
                ++i;
            }
        }
        this.cleanupCategoryDirectories(categoriesDirectoryFile);
    }

    private final void cleanupCategoryDirectories(File categoriesDirectoryFile) {
        File uddiDirectoryFile;
        File registryIdDirectoryFile;
        String[] fileList = categoriesDirectoryFile.list();
        if (fileList == null || fileList.length == 0) {
            categoriesDirectoryFile.delete();
        }
        if ((fileList = (registryIdDirectoryFile = categoriesDirectoryFile.getParentFile()).list()) == null || fileList.length == 0) {
            registryIdDirectoryFile.delete();
        }
        if ((fileList = (uddiDirectoryFile = registryIdDirectoryFile.getParentFile()).list()) == null || fileList.length == 0) {
            uddiDirectoryFile.delete();
        }
    }

    public boolean favoriteExists(Hashtable table) {
        String registryName = (String)table.get("UDDIRegistryName");
        if (registryName == null) {
            return false;
        }
        return this.getFavorite(registryName) != null;
    }

    public boolean removeFavoriteByNodeID(int nodeID, String pluginMetadataDirectory) {
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (selectedElement instanceof FavoritesUDDIRegistryElement) {
            this.clearRegistryMetadata(pluginMetadataDirectory, selectedElement.getName());
            boolean rc = this.removeFavorite((FavoritesUDDIRegistryElement)selectedElement);
            rc = rc && favMainElement.saveFavorites();
            return rc;
        }
        return false;
    }

    private boolean removeFavorite(FavoritesUDDIRegistryElement element) {
        Link link = element.getLink();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (favMainElement.removeLink(link)) {
            element.disconnectAll();
            return true;
        }
        return false;
    }

    public boolean removeAllFavorites(String pluginMetadataDirectory) {
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIRegistryElement favUDDIRegistryElement = (FavoritesUDDIRegistryElement)((Object)e.nextElement());
            this.clearRegistryMetadata(pluginMetadataDirectory, favUDDIRegistryElement.getName());
            Link link = favUDDIRegistryElement.getLink();
            favMainElement.removeLink(link);
        }
        this.disconnectRel("relUDDIRegistryNode");
        return favMainElement.saveFavorites();
    }

    public Enumeration getAllFavorites() {
        return this.getElements("relUDDIRegistryNode");
    }

    private FavoritesUDDIRegistryElement getFavorite(String registryName) {
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIRegistryElement regElement = (FavoritesUDDIRegistryElement)((Object)e.nextElement());
            if (!registryName.equals(regElement.getName())) continue;
            return regElement;
        }
        return null;
    }
}

