/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual;

import org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual.VirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class ConnectionNode
extends VirtualNode
implements IConnectionNode {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String IS_OFFLINE = "isOffline";
    private static final String IS_CONNECTED = "isConnected";
    private boolean shouldDisconnect = false;
    private ConnectionInfo connectionInfo;
    private Database database;
    private String userName;
    private String urlString;
    private String databaseVersion;
    private String databaseType;
    private String driverClassName;
    private String loadingPath;

    public ConnectionNode(String name, String displayName, Object parent, ConnectionInfo info) {
        super(name, displayName, parent);
        this.connectionInfo = info;
    }

    public boolean isConnected() {
        return this.connectionInfo.getSharedDatabase() != null;
    }

    public void setConnected(boolean isConnected) {
        if (!this.isConnected() && this.hasChildren()) {
            this.shouldDisconnect = false;
            this.getChildren().removeAll(this.getChildren());
        }
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (value.equals(TRUE) && name.equals(IS_CONNECTED) && this.isConnected() || value.equals(FALSE) && name.equals(IS_CONNECTED) && !this.isConnected()) {
            return true;
        }
        return value.equals(FALSE) && name.equals(IS_OFFLINE) && this.connectionInfo.getSharedConnection() != null && this.connectionInfo.getSharedDatabase() != null;
    }

    public boolean shouldDisconnect() {
        return this.shouldDisconnect;
    }

    public void shouldDisconnect(boolean connection) {
        this.shouldDisconnect = connection;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getGroupID() {
        return "org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.connection";
    }
}

