/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.FlexibleJavaProjectCreationDataModelProvider;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class CreateModuleCommand
extends AbstractDataModelOperation {
    public static final int WEB = 1;
    public static final int EJB = 2;
    public static final int APPCLIENT = 4;
    public static final int EAR = 8;
    public static final String WEB_TEMPLATE = "template.jst.web";
    public static final String EJB_TEMPLATE = "template.jst.ejb";
    public static final String APPCLIENT_TEMPLATE = "template.jst.appclient";
    public static final String EAR_TEMPLATE = "template.jst.ear";
    private String projectName;
    private String moduleName;
    private int moduleType;
    private String j2eeLevel;
    private String serverFactoryId;
    private String serverInstanceId_;
    private IEnvironment env;
    private IProgressMonitor monitor_;
    private org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.monitor_ = monitor;
        this.env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        status = this.checkDataReady();
        if (status.getSeverity() == 4) {
            return status;
        }
        IProject project = ProjectUtilities.getProject((String)this.projectName);
        if (!project.exists()) {
            int type = this.getModuleType();
            switch (type) {
                case 1: {
                    status = this.createWebComponent();
                    break;
                }
                case 2: {
                    status = this.createEJBComponent();
                    break;
                }
                case 4: {
                    status = this.createAppClientComponent();
                    break;
                }
                case 8: {
                    status = this.createEARComponent();
                    break;
                }
                default: {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_COMPONENT_CREATION, (Object[])new String[]{this.moduleName}));
                }
            }
        }
        return status;
    }

    private IStatus checkDataReady() {
        if (this.projectName == null || this.serverFactoryId == null) {
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_COMPONENT_CREATION, (Object[])new String[]{this.projectName, this.moduleName}));
        }
        return Status.OK_STATUS;
    }

    public IStatus createWebComponent() {
        IStatus status = Status.OK_STATUS;
        try {
            HashSet<IProjectFacetVersion> facetsToAdd;
            status = FacetUtils.createNewFacetedProject(this.projectName);
            if (status.getSeverity() == 4) {
                return status;
            }
            IProject createdProject = ProjectUtilities.getProject((String)this.projectName);
            IFacetedProject fproject = ProjectFacetsManager.create((IProject)createdProject);
            HashSet<IProjectFacetVersion> facetsToAddModified = facetsToAdd = this.getFacetsToAdd(WEB_TEMPLATE);
            if (this.j2eeLevel != null && this.j2eeLevel.length() > 0) {
                String webVersion = this.getWebVersionFromJ2EELevel(this.j2eeLevel);
                facetsToAddModified = new HashSet<IProjectFacetVersion>();
                Iterator itr = facetsToAdd.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion pfv = (IProjectFacetVersion)itr.next();
                    IProjectFacet pf = pfv.getProjectFacet();
                    if (pf.getId().equals("jst.web")) {
                        IProjectFacetVersion webfv = pf.getVersion(webVersion);
                        facetsToAddModified.add(webfv);
                        continue;
                    }
                    facetsToAddModified.add(pfv);
                }
            }
            if ((status = FacetUtils.addFacetsToProject(fproject, facetsToAddModified)).getSeverity() == 4) {
                return status;
            }
            Set newFacetVersions = fproject.getProjectFacets();
            HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
            Iterator iter = newFacetVersions.iterator();
            while (iter.hasNext()) {
                IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
                fixedFacets.add(facetVersion.getProjectFacet());
            }
            status = FacetUtils.setFixedFacetsOnProject(fproject, fixedFacets);
            if (status.getSeverity() == 4) {
                return status;
            }
            if (this.facetRuntime != null) {
                status = FacetUtils.setFacetRuntimeOnProject(fproject, this.facetRuntime);
            }
        }
        catch (CoreException ce) {
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{this.projectName}), (Throwable)ce);
        }
        return status;
    }

    public IStatus createEARComponent() {
        IStatus status = Status.OK_STATUS;
        try {
            HashSet<IProjectFacetVersion> facetsToAdd;
            status = FacetUtils.createNewFacetedProject(this.projectName);
            if (status.getSeverity() == 4) {
                return status;
            }
            IProject createdProject = ProjectUtilities.getProject((String)this.projectName);
            IFacetedProject fproject = ProjectFacetsManager.create((IProject)createdProject);
            HashSet<IProjectFacetVersion> facetsToAddModified = facetsToAdd = this.getFacetsToAdd(EAR_TEMPLATE);
            if (this.j2eeLevel != null && this.j2eeLevel.length() > 0) {
                String webVersion = this.getEARVersionFromJ2EELevel(this.j2eeLevel);
                facetsToAddModified = new HashSet<IProjectFacetVersion>();
                Iterator itr = facetsToAdd.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion pfv = (IProjectFacetVersion)itr.next();
                    IProjectFacet pf = pfv.getProjectFacet();
                    if (pf.getId().equals("jst.ear")) {
                        IProjectFacetVersion webfv = pf.getVersion(webVersion);
                        facetsToAddModified.add(webfv);
                        continue;
                    }
                    facetsToAddModified.add(pfv);
                }
            }
            if ((status = FacetUtils.addFacetsToProject(fproject, facetsToAddModified)).getSeverity() == 4) {
                return status;
            }
            Set newFacetVersions = fproject.getProjectFacets();
            HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
            Iterator iter = newFacetVersions.iterator();
            while (iter.hasNext()) {
                IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
                fixedFacets.add(facetVersion.getProjectFacet());
            }
            status = FacetUtils.setFixedFacetsOnProject(fproject, fixedFacets);
            if (status.getSeverity() == 4) {
                return status;
            }
            if (this.facetRuntime != null) {
                status = FacetUtils.setFacetRuntimeOnProject(fproject, this.facetRuntime);
            }
        }
        catch (CoreException ce) {
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{this.projectName}), (Throwable)ce);
        }
        return status;
    }

    public IStatus createEJBComponent() {
        IStatus status = Status.OK_STATUS;
        try {
            HashSet<IProjectFacetVersion> facetsToAdd;
            status = FacetUtils.createNewFacetedProject(this.projectName);
            if (status.getSeverity() == 4) {
                return status;
            }
            IProject createdProject = ProjectUtilities.getProject((String)this.projectName);
            IFacetedProject fproject = ProjectFacetsManager.create((IProject)createdProject);
            HashSet<IProjectFacetVersion> facetsToAddModified = facetsToAdd = this.getFacetsToAdd(EJB_TEMPLATE);
            if (this.j2eeLevel != null && this.j2eeLevel.length() > 0) {
                String webVersion = this.getEJBVersionFromJ2EELevel(this.j2eeLevel);
                facetsToAddModified = new HashSet<IProjectFacetVersion>();
                Iterator itr = facetsToAdd.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion pfv = (IProjectFacetVersion)itr.next();
                    IProjectFacet pf = pfv.getProjectFacet();
                    if (pf.getId().equals("jst.ejb")) {
                        IProjectFacetVersion webfv = pf.getVersion(webVersion);
                        facetsToAddModified.add(webfv);
                        continue;
                    }
                    facetsToAddModified.add(pfv);
                }
            }
            if ((status = FacetUtils.addFacetsToProject(fproject, facetsToAddModified)).getSeverity() == 4) {
                return status;
            }
            Set newFacetVersions = fproject.getProjectFacets();
            HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
            Iterator iter = newFacetVersions.iterator();
            while (iter.hasNext()) {
                IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
                fixedFacets.add(facetVersion.getProjectFacet());
            }
            status = FacetUtils.setFixedFacetsOnProject(fproject, fixedFacets);
            if (status.getSeverity() == 4) {
                return status;
            }
            if (this.facetRuntime != null) {
                status = FacetUtils.setFacetRuntimeOnProject(fproject, this.facetRuntime);
            }
        }
        catch (CoreException ce) {
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_CREATE_EJB_COMPONENT, (Object[])new String[]{this.projectName}), (Throwable)ce);
        }
        return status;
    }

    public IStatus createAppClientComponent() {
        IStatus status = Status.OK_STATUS;
        try {
            HashSet<IProjectFacetVersion> facetsToAdd;
            status = FacetUtils.createNewFacetedProject(this.projectName);
            if (status.getSeverity() == 4) {
                return status;
            }
            IProject createdProject = ProjectUtilities.getProject((String)this.projectName);
            IFacetedProject fproject = ProjectFacetsManager.create((IProject)createdProject);
            HashSet<IProjectFacetVersion> facetsToAddModified = facetsToAdd = this.getFacetsToAdd(APPCLIENT_TEMPLATE);
            if (this.j2eeLevel != null && this.j2eeLevel.length() > 0) {
                String webVersion = this.getAppClientVersionFromJ2EELevel(this.j2eeLevel);
                facetsToAddModified = new HashSet<IProjectFacetVersion>();
                Iterator itr = facetsToAdd.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion pfv = (IProjectFacetVersion)itr.next();
                    IProjectFacet pf = pfv.getProjectFacet();
                    if (pf.getId().equals("jst.appclient")) {
                        IProjectFacetVersion webfv = pf.getVersion(webVersion);
                        facetsToAddModified.add(webfv);
                        continue;
                    }
                    facetsToAddModified.add(pfv);
                }
            }
            if ((status = FacetUtils.addFacetsToProject(fproject, facetsToAddModified)).getSeverity() == 4) {
                return status;
            }
            Set newFacetVersions = fproject.getProjectFacets();
            HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
            Iterator iter = newFacetVersions.iterator();
            while (iter.hasNext()) {
                IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
                fixedFacets.add(facetVersion.getProjectFacet());
            }
            status = FacetUtils.setFixedFacetsOnProject(fproject, fixedFacets);
            if (status.getSeverity() == 4) {
                return status;
            }
            if (this.facetRuntime != null) {
                status = FacetUtils.setFacetRuntimeOnProject(fproject, this.facetRuntime);
            }
        }
        catch (CoreException ce) {
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_CREATE_APPCLIENT_COMPONENT, (Object[])new String[]{this.projectName}), (Throwable)ce);
        }
        return status;
    }

    public IStatus createFlexibleJavaProject() {
        IStatus status = Status.OK_STATUS;
        try {
            IDataModel projectInfo = DataModelFactory.createDataModel((IDataModelProvider)new FlexibleJavaProjectCreationDataModelProvider());
            projectInfo.setProperty("IProjectCreationProperties.PROJECT_NAME", (Object)this.projectName);
            String runtimeTargetId = null;
            if (this.serverInstanceId_ == null) {
                runtimeTargetId = ServerUtils.getServerTargetIdFromFactoryId((String)this.serverFactoryId, (String)ServerUtils.getServerTargetModuleType((int)this.moduleType), (String)this.j2eeLevel);
            } else {
                IServer server = ServerCore.findServer((String)this.serverInstanceId_);
                runtimeTargetId = server.getRuntime().getId();
            }
            projectInfo.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", (Object)runtimeTargetId);
            projectInfo.setProperty("IFlexibleProjectCreationDataModelProperties.ADD_SERVER_TARGET", (Object)Boolean.TRUE);
            IDataModelOperation op = projectInfo.getDefaultOperation();
            if (this.env != null) {
                op.execute(this.monitor_, null);
            } else {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_CREATE_FLEX_PROJET, (Object[])new String[]{this.projectName}), (Throwable)e);
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    private Set getFacetsToAdd(String templateId) {
        facets = new HashSet<E>();
        this.setFacetRuntime();
        if (this.facetRuntime != null) {
            template = ProjectFacetsManager.getTemplate((String)templateId);
            templateFacets = template.getFixedProjectFacets();
            templateFacetsItr = templateFacets.iterator();
            block3: while (templateFacetsItr.hasNext()) {
                block9: {
                    fixedFacet = (IProjectFacet)templateFacetsItr.next();
                    versions = null;
                    try {
                        versions = fixedFacet.getSortedVersions(false);
                        break block9;
                    }
                    catch (VersionFormatException v0) {
                        versionSet = fixedFacet.getVersions();
                        itr = versionSet.iterator();
                        versions = new ArrayList<E>();
                        ** while (itr.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        versions.add(itr.next());
                        continue;
lbl21:
                        // 1 sources

                        break block9;
                    }
                    catch (CoreException v1) {
                        versionSet = fixedFacet.getVersions();
                        itr = versionSet.iterator();
                        versions = new ArrayList<E>();
                        ** while (itr.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        versions.add(itr.next());
                        continue;
                    }
                }
                versionsItr = versions.iterator();
                while (versionsItr.hasNext()) {
                    pfv = (IProjectFacetVersion)versionsItr.next();
                    pfvs = new HashSet<IProjectFacetVersion>();
                    pfvs.add(pfv);
                    if (!FacetUtils.doesRuntimeSupportFacets(this.facetRuntime, pfvs)) continue;
                    facets.add(pfv);
                    continue block3;
                }
            }
        } else {
            facets = FacetUtils.getInitialFacetVersionsFromTemplate(templateId);
        }
        return facets;
    }

    private void setFacetRuntime() {
        if (this.serverInstanceId_ != null && this.serverInstanceId_.length() > 0) {
            IServer server = ServerCore.findServer((String)this.serverInstanceId_);
            IRuntime sRuntime = server.getRuntime();
            this.facetRuntime = FacetUtil.getRuntime((IRuntime)sRuntime);
        } else {
            IRuntime serverRuntime = ServerUtils.getNonStubRuntime((String)this.serverFactoryId);
            if (serverRuntime != null) {
                this.facetRuntime = FacetUtil.getRuntime((IRuntime)serverRuntime);
            } else {
                IServerType st = ServerCore.findServerType((String)this.serverFactoryId);
                String runtimeTypeId = st.getRuntimeType().getId();
                IRuntime[] runtimes = ServerCore.getRuntimes();
                int i = 0;
                while (i < runtimes.length) {
                    IRuntime sRuntime = runtimes[i];
                    if (sRuntime.getRuntimeType().getId().equals(runtimeTypeId)) {
                        this.facetRuntime = FacetUtil.getRuntime((IRuntime)sRuntime);
                    }
                    ++i;
                }
            }
        }
    }

    private String getWebVersionFromJ2EELevel(String j2eeVersion) {
        int aVersion = Integer.valueOf(this.j2eeLevel);
        switch (aVersion) {
            case 12: {
                return "2.2";
            }
            case 13: {
                return "2.3";
            }
            case 14: {
                return "2.4";
            }
        }
        return "2.4";
    }

    private String getEJBVersionFromJ2EELevel(String j2eeVersion) {
        int aVersion = Integer.valueOf(this.j2eeLevel);
        switch (aVersion) {
            case 12: {
                return "1.1";
            }
            case 13: {
                return "2.0";
            }
            case 14: {
                return "2.1";
            }
        }
        return "2.1";
    }

    private String getAppClientVersionFromJ2EELevel(String j2eeVersion) {
        int aVersion = Integer.valueOf(this.j2eeLevel);
        switch (aVersion) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
        }
        return "1.4";
    }

    private String getEARVersionFromJ2EELevel(String j2eeVersion) {
        int aVersion = Integer.valueOf(this.j2eeLevel);
        switch (aVersion) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
        }
        return "1.4";
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public int getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(int moduleType) {
        this.moduleType = moduleType;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setJ2eeLevel(String level) {
        this.j2eeLevel = level != null && level.indexOf(".") != -1 ? J2EEUtils.getJ2EEIntVersionAsString((String)level) : level;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId_ = serverInstanceId;
    }
}

