/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.generatediff;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.util.ContainerContentProvider;

class PatchFileSelectionPage
extends WizardPage {
    private Text filenameCombo;
    private Button browseButton;
    private TreeViewer treeViewer;
    private IContainer selectedContainer;
    private Text workspaceFilename;
    private Button saveInFilesystem;
    private Button saveInWorkspace;
    private Button saveToClipboard;
    public final int CLIPBOARD = 1;
    public final int FILESYSTEM = 2;
    public final int WORKSPACE = 3;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 125;
    private static final int SIZING_SELECTION_PANE_WIDTH = 200;

    public PatchFileSelectionPage(String pageName, String title, ImageDescriptor image, IStructuredSelection selection) {
        super(pageName, title, image);
        this.setPageComplete(false);
    }

    protected boolean validatePage() {
        boolean valid = false;
        switch (this.getSaveType()) {
            case 3: {
                if (this.selectedContainer == null || this.getWorkspaceFile() == null) break;
                valid = true;
                break;
            }
            case 2: {
                File file = new File(this.getFilesystemFile());
                valid = this.isValidFile(file);
                break;
            }
            case 1: {
                valid = true;
            }
        }
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Policy.bind("GenerateSVNDiff.EnterFilename"));
        }
        this.setPageComplete(valid);
        return valid;
    }

    private boolean isValidFile(File file) {
        if (!file.isAbsolute()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (!parent.exists()) {
            return false;
        }
        return parent.isDirectory();
    }

    public String getFilesystemFile() {
        if (this.saveInFilesystem.getSelection()) {
            return this.filenameCombo.getText();
        }
        return null;
    }

    public IFile getWorkspaceFile() {
        if (this.saveInWorkspace.getSelection() && this.selectedContainer != null) {
            String filename = this.workspaceFilename.getText();
            if (filename == null || filename.length() == 0) {
                return null;
            }
            return this.selectedContainer.getFile((IPath)new Path(this.workspaceFilename.getText()));
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.patch_selection_page_context");
        this.saveToClipboard = new Button(composite, 16);
        this.saveToClipboard.setText(Policy.bind("GenerateSVNDiff.SaveToClipboard"));
        this.saveToClipboard.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PatchFileSelectionPage.this.validatePage();
                PatchFileSelectionPage.this.updateEnablements();
            }
        });
        this.saveInFilesystem = new Button(composite, 16);
        this.saveInFilesystem.setText(Policy.bind("GenerateSVNDiff.SaveInFileSystem"));
        this.saveInFilesystem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PatchFileSelectionPage.this.validatePage();
                PatchFileSelectionPage.this.updateEnablements();
            }
        });
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        nameGroup.setLayoutData((Object)data);
        this.filenameCombo = new Text(nameGroup, 2048);
        GridData gd = new GridData(768);
        this.filenameCombo.setLayoutData((Object)gd);
        this.filenameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatchFileSelectionPage.this.validatePage();
            }
        });
        this.browseButton = new Button(nameGroup, 0);
        this.browseButton.setText(Policy.bind("GenerateSVNDiff.Browse"));
        data = new GridData(128);
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(PatchFileSelectionPage.this.getShell(), 40960);
                d.setText(Policy.bind("GenerateSVNDiff.SavePatchAs"));
                d.setFileName(Policy.bind("GenerateSVNDiff.patchTxt"));
                String file = d.open();
                if (file != null) {
                    Path path = new Path(file);
                    PatchFileSelectionPage.this.setFilesystemFilename(path.toOSString());
                }
            }
        });
        this.saveInWorkspace = new Button(composite, 16);
        this.saveInWorkspace.setText(Policy.bind("GenerateSVNDiff.SaveInWorkspace"));
        this.saveInWorkspace.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PatchFileSelectionPage.this.validatePage();
                PatchFileSelectionPage.this.updateEnablements();
            }
        });
        this.createTreeViewer(composite);
        this.saveToClipboard.setSelection(true);
        this.validatePage();
        this.updateEnablements();
    }

    protected void setFilesystemFilename(String filename) {
        this.filenameCombo.setText(filename);
    }

    protected void createTreeViewer(Composite parent) {
        new Label(parent, 16384).setText(Policy.bind("GenerateSVNDiff.SelectFolderAndFilename"));
        this.treeViewer = new TreeViewer(parent, 2048);
        ContainerContentProvider cp = new ContainerContentProvider();
        cp.showClosedProjects(false);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = 125;
        this.treeViewer.getTree().setLayoutData((Object)data);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PatchFileSelectionPage.this.containerSelectionChanged((IContainer)selection.getFirstElement());
                PatchFileSelectionPage.this.validatePage();
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (PatchFileSelectionPage.this.treeViewer.getExpandedState(item)) {
                        PatchFileSelectionPage.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        PatchFileSelectionPage.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        Composite nameGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        data = new GridData(768);
        nameGroup.setLayoutData((Object)data);
        Label label = new Label(nameGroup, 0);
        label.setText(Policy.bind("GenerateSVNDiff.FileName"));
        this.workspaceFilename = new Text(nameGroup, 2048);
        data = new GridData(768);
        this.workspaceFilename.setLayoutData((Object)data);
        this.workspaceFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatchFileSelectionPage.this.validatePage();
            }
        });
    }

    protected void updateEnablements() {
        int type = this.getSaveType();
        this.browseButton.setEnabled(type == 2);
        this.filenameCombo.setEnabled(type == 2);
        this.treeViewer.getTree().setEnabled(type == 3);
        this.workspaceFilename.setEnabled(type == 3);
    }

    public int getSaveType() {
        if (this.saveInFilesystem.getSelection()) {
            return 2;
        }
        if (this.saveToClipboard.getSelection()) {
            return 1;
        }
        return 3;
    }

    public void containerSelectionChanged(IContainer container) {
        this.selectedContainer = container;
    }
}

