/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.rubypeople.rdt.core.Flags;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.ui.RubyElementImageDescriptor;

public class RubyElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;
    static /* synthetic */ Class class$0;

    public RubyElementImageProvider() {
        ISharedImages iSharedImages = RubyPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = iSharedImages.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = iSharedImages.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object object, int n) {
        return this.getImageLabel(this.computeDescriptor(object, n));
    }

    private Image getImageLabel(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        return this.getRegistry().get(imageDescriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = RubyPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object object, int n) {
        if (object instanceof IRubyElement) {
            return this.getRubyImageDescriptor((IRubyElement)object, n);
        }
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            if (RubyCore.isRubyLikeFileName((String)iFile.getName())) {
                return this.getCUResourceImageDescriptor(iFile, n);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)iFile, n);
        }
        if (object instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)object, n);
        }
        return null;
    }

    private static boolean showOverlayIcons(int n) {
        return (n & 1) != 0;
    }

    private static boolean useSmallSize(int n) {
        return (n & 2) != 0;
    }

    private static boolean useLightIcons(int n) {
        return (n & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile iFile, int n) {
        Point point = RubyElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new RubyElementImageDescriptor(RubyPluginImages.DESC_OBJS_RUBY_RESOURCE, 0, point);
    }

    public ImageDescriptor getRubyImageDescriptor(IRubyElement iRubyElement, int n) {
        int n2 = this.computeRubyAdornmentFlags(iRubyElement, n);
        Point point = RubyElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new RubyElementImageDescriptor(this.getBaseImageDescriptor(iRubyElement, n), n2, point);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable iAdaptable, int n) {
        IWorkbenchAdapter iWorkbenchAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iAdaptable);
        if (imageDescriptor == null) {
            return null;
        }
        Point point = RubyElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new RubyElementImageDescriptor(imageDescriptor, 0, point);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageDescriptor getBaseImageDescriptor(IRubyElement iRubyElement, int n) {
        try {
            switch (iRubyElement.getElementType()) {
                case 4: {
                    IMethod iMethod = (IMethod)iRubyElement;
                    iMethod.getDeclaringType();
                    int n2 = iMethod.getVisibility();
                    return RubyElementImageProvider.getMethodImageDescriptor(n2);
                }
                case 5: {
                    return RubyPluginImages.DESC_OBJS_GLOBAL;
                }
                case 8: {
                    return RubyPluginImages.DESC_OBJS_CLASS_VAR;
                }
                case 7: {
                    return RubyPluginImages.DESC_OBJS_CONSTANT;
                }
                case 10: {
                    return RubyPluginImages.DESC_OBJS_LOCAL_VAR;
                }
                case 9: {
                    return RubyPluginImages.DESC_OBJS_INSTANCE_VAR;
                }
                case 6: {
                    return RubyPluginImages.DESC_OBJS_IMPDECL;
                }
                case 14: {
                    return RubyPluginImages.DESC_OBJS_IMPCONT;
                }
                case 3: {
                    IType iType = (IType)iRubyElement;
                    IType iType2 = iType.getDeclaringType();
                    boolean bl = iType2 != null;
                    return RubyElementImageProvider.getTypeImageDescriptor(iType.isModule(), bl, RubyElementImageProvider.useLightIcons(n));
                }
                case 2: {
                    return RubyPluginImages.DESC_OBJS_SCRIPT;
                }
                case 1: {
                    ImageDescriptor imageDescriptor;
                    IWorkbenchAdapter iWorkbenchAdapter;
                    IRubyProject iRubyProject = (IRubyProject)iRubyElement;
                    if (!iRubyProject.getProject().isOpen()) return DESC_OBJ_PROJECT_CLOSED;
                    IProject iProject = iRubyProject.getProject();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iWorkbenchAdapter = (IWorkbenchAdapter)iProject.getAdapter((Class)clazz)) == null || (imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iProject)) == null) return DESC_OBJ_PROJECT;
                    return imageDescriptor;
                }
                case 0: {
                    return RubyPluginImages.DESC_OBJS_RUBY_MODEL;
                }
            }
            Assert.isTrue((boolean)false, (String)RubyUIMessages.RubyImageLabelprovider_assert_wrongImage);
            return RubyPluginImages.DESC_OBJS_GHOST;
        }
        catch (RubyModelException rubyModelException) {
            return RubyPluginImages.DESC_OBJS_UNKNOWN;
        }
    }

    public void dispose() {
    }

    private int computeRubyAdornmentFlags(IRubyElement iRubyElement, int n) {
        int n2 = 0;
        if (RubyElementImageProvider.showOverlayIcons(n) && iRubyElement instanceof IMember) {
            IMember cfr_ignored_0 = (IMember)iRubyElement;
            if (iRubyElement.getElementType() == 4 && ((IMethod)iRubyElement).isConstructor()) {
                n2 |= 0x200;
            }
        }
        return n2;
    }

    public static ImageDescriptor getMethodImageDescriptor(int n) {
        if (Flags.isPublic((int)n)) {
            return RubyPluginImages.DESC_MISC_PUBLIC;
        }
        if (Flags.isProtected((int)n)) {
            return RubyPluginImages.DESC_MISC_PROTECTED;
        }
        return RubyPluginImages.DESC_MISC_PRIVATE;
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (bl3) {
                return RubyPluginImages.DESC_OBJS_MODULEALT;
            }
            if (bl2) {
                return RubyElementImageProvider.getInnerModuleImageDescriptor();
            }
            return RubyPluginImages.DESC_OBJS_MODULE;
        }
        if (bl3) {
            return RubyPluginImages.DESC_OBJS_CLASSALT;
        }
        if (bl2) {
            return RubyElementImageProvider.getInnerClassImageDescriptor();
        }
        return RubyElementImageProvider.getClassImageDescriptor();
    }

    public static Image getDecoratedImage(ImageDescriptor imageDescriptor, int n, Point point) {
        return RubyPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new RubyElementImageDescriptor(imageDescriptor, n, point));
    }

    private static ImageDescriptor getClassImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_CLASS;
    }

    private static ImageDescriptor getInnerClassImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_INNER_CLASS;
    }

    private static ImageDescriptor getInnerModuleImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_MODULE;
    }

    public static ImageDescriptor getFieldImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_CLASS_VAR;
    }
}

